/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.eventhub.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.eventhub.EventHubNamespaceAuthorizationRule;
import com.microsoft.azure.management.eventhub.EventHubNamespaceAuthorizationRules;
import com.microsoft.azure.management.eventhub.implementation.AuthorizationRuleInner;
import com.microsoft.azure.management.eventhub.implementation.AuthorizationRulesBaseImpl;
import com.microsoft.azure.management.eventhub.implementation.EventHubManagementClientImpl;
import com.microsoft.azure.management.eventhub.implementation.EventHubManager;
import com.microsoft.azure.management.eventhub.implementation.EventHubNamespaceAuthorizationRuleImpl;
import com.microsoft.azure.management.eventhub.implementation.NamespacesInner;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import java.util.Objects;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class EventHubNamespaceAuthorizationRulesImpl
extends AuthorizationRulesBaseImpl<NamespacesInner, EventHubNamespaceAuthorizationRule, EventHubNamespaceAuthorizationRuleImpl>
implements EventHubNamespaceAuthorizationRules {
    EventHubNamespaceAuthorizationRulesImpl(EventHubManager manager) {
        super(manager, ((EventHubManagementClientImpl)((Object)manager.inner())).namespaces());
    }

    public EventHubNamespaceAuthorizationRuleImpl define(String name) {
        return new EventHubNamespaceAuthorizationRuleImpl(name, this.manager);
    }

    @Override
    public Observable<EventHubNamespaceAuthorizationRule> getByIdAsync(String id) {
        Objects.requireNonNull(id);
        ResourceId resourceId = ResourceId.fromString((String)id);
        return this.getByNameAsync(resourceId.resourceGroupName(), resourceId.parent().name(), resourceId.name());
    }

    @Override
    public EventHubNamespaceAuthorizationRule getByName(String resourceGroupName, String namespaceName, String name) {
        return (EventHubNamespaceAuthorizationRule)this.getByNameAsync(resourceGroupName, namespaceName, name).toBlocking().last();
    }

    @Override
    public Observable<EventHubNamespaceAuthorizationRule> getByNameAsync(String resourceGroupName, String namespaceName, String name) {
        return ((NamespacesInner)this.inner()).getAuthorizationRuleAsync(resourceGroupName, namespaceName, name).map((Func1)new Func1<AuthorizationRuleInner, EventHubNamespaceAuthorizationRule>(){

            public EventHubNamespaceAuthorizationRule call(AuthorizationRuleInner inner) {
                if (inner == null) {
                    return null;
                }
                return EventHubNamespaceAuthorizationRulesImpl.this.wrapModel(inner);
            }
        });
    }

    @Override
    public PagedList<EventHubNamespaceAuthorizationRule> listByNamespace(String resourceGroupName, String namespaceName) {
        return new PagedListConverter<AuthorizationRuleInner, EventHubNamespaceAuthorizationRule>(){

            public Observable<EventHubNamespaceAuthorizationRule> typeConvertAsync(AuthorizationRuleInner inner) {
                return Observable.just((Object)EventHubNamespaceAuthorizationRulesImpl.this.wrapModel(inner));
            }
        }.convert(((NamespacesInner)this.inner()).listAuthorizationRules(resourceGroupName, namespaceName));
    }

    @Override
    public Observable<EventHubNamespaceAuthorizationRule> listByNamespaceAsync(String resourceGroupName, String namespaceName) {
        return ((NamespacesInner)this.inner()).listAuthorizationRulesAsync(resourceGroupName, namespaceName).flatMapIterable((Func1)new Func1<Page<AuthorizationRuleInner>, Iterable<AuthorizationRuleInner>>(){

            public Iterable<AuthorizationRuleInner> call(Page<AuthorizationRuleInner> page) {
                return page.items();
            }
        }).map((Func1)new Func1<AuthorizationRuleInner, EventHubNamespaceAuthorizationRule>(){

            public EventHubNamespaceAuthorizationRule call(AuthorizationRuleInner inner) {
                return EventHubNamespaceAuthorizationRulesImpl.this.wrapModel(inner);
            }
        });
    }

    @Override
    public Completable deleteByIdAsync(String id) {
        Objects.requireNonNull(id);
        ResourceId resourceId = ResourceId.fromString((String)id);
        return this.deleteByNameAsync(resourceId.resourceGroupName(), resourceId.parent().name(), resourceId.name());
    }

    @Override
    public Completable deleteByNameAsync(String resourceGroupName, String namespaceName, String name) {
        return ((NamespacesInner)this.inner()).deleteAuthorizationRuleAsync(resourceGroupName, namespaceName, name).toCompletable();
    }

    @Override
    public void deleteByName(String resourceGroupName, String namespaceName, String name) {
        this.deleteByNameAsync(resourceGroupName, namespaceName, name).await();
    }

    @Override
    protected EventHubNamespaceAuthorizationRuleImpl wrapModel(AuthorizationRuleInner innerModel) {
        return new EventHubNamespaceAuthorizationRuleImpl(innerModel.name(), innerModel, this.manager);
    }
}

