/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.Resource;
import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.AvailabilitySet;
import com.microsoft.azure.management.compute.AvailabilitySetSkuTypes;
import com.microsoft.azure.management.compute.InstanceViewStatus;
import com.microsoft.azure.management.compute.Sku;
import com.microsoft.azure.management.compute.VirtualMachineSize;
import com.microsoft.azure.management.compute.implementation.AvailabilitySetInner;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.VirtualMachineSizeImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineSizeInner;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class AvailabilitySetImpl
extends GroupableResourceImpl<AvailabilitySet, AvailabilitySetInner, AvailabilitySetImpl, ComputeManager>
implements AvailabilitySet,
AvailabilitySet.Definition,
AvailabilitySet.Update {
    private Set<String> idOfVMsInSet;

    AvailabilitySetImpl(String name, AvailabilitySetInner innerModel, ComputeManager computeManager) {
        super(name, (Resource)innerModel, (ManagerBase)computeManager);
    }

    @Override
    public int updateDomainCount() {
        return Utils.toPrimitiveInt((Integer)((AvailabilitySetInner)((Object)this.inner())).platformUpdateDomainCount());
    }

    @Override
    public int faultDomainCount() {
        return Utils.toPrimitiveInt((Integer)((AvailabilitySetInner)((Object)this.inner())).platformFaultDomainCount());
    }

    @Override
    public AvailabilitySetSkuTypes sku() {
        if (((AvailabilitySetInner)((Object)this.inner())).sku() != null && ((AvailabilitySetInner)((Object)this.inner())).sku().name() != null) {
            return AvailabilitySetSkuTypes.fromString(((AvailabilitySetInner)((Object)this.inner())).sku().name());
        }
        return null;
    }

    @Override
    public Set<String> virtualMachineIds() {
        if (this.idOfVMsInSet == null) {
            this.idOfVMsInSet = new HashSet<String>();
            for (SubResource resource : ((AvailabilitySetInner)((Object)this.inner())).virtualMachines()) {
                this.idOfVMsInSet.add(resource.id());
            }
        }
        return Collections.unmodifiableSet(this.idOfVMsInSet);
    }

    @Override
    public List<InstanceViewStatus> statuses() {
        return Collections.unmodifiableList(((AvailabilitySetInner)((Object)this.inner())).statuses());
    }

    @Override
    public PagedList<VirtualMachineSize> listVirtualMachineSizes() {
        return Utils.toPagedList(((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).availabilitySets().listAvailableSizes(this.resourceGroupName(), this.name()), (Func1)new Func1<VirtualMachineSizeInner, VirtualMachineSize>(){

            public VirtualMachineSize call(VirtualMachineSizeInner inner) {
                return new VirtualMachineSizeImpl(inner);
            }
        });
    }

    public Observable<AvailabilitySet> refreshAsync() {
        return super.refreshAsync().map((Func1)new Func1<AvailabilitySet, AvailabilitySet>(){

            public AvailabilitySet call(AvailabilitySet availabilitySet) {
                AvailabilitySetImpl impl = (AvailabilitySetImpl)availabilitySet;
                impl.idOfVMsInSet = null;
                return impl;
            }
        });
    }

    protected Observable<AvailabilitySetInner> getInnerAsync() {
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).availabilitySets().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public AvailabilitySetImpl withUpdateDomainCount(int updateDomainCount) {
        ((AvailabilitySetInner)((Object)this.inner())).withPlatformUpdateDomainCount(updateDomainCount);
        return this;
    }

    @Override
    public AvailabilitySetImpl withFaultDomainCount(int faultDomainCount) {
        ((AvailabilitySetInner)((Object)this.inner())).withPlatformFaultDomainCount(faultDomainCount);
        return this;
    }

    @Override
    public AvailabilitySetImpl withSku(AvailabilitySetSkuTypes skuType) {
        if (((AvailabilitySetInner)((Object)this.inner())).sku() == null) {
            ((AvailabilitySetInner)((Object)this.inner())).withSku(new Sku());
        }
        ((AvailabilitySetInner)((Object)this.inner())).sku().withName(skuType.toString());
        return this;
    }

    public Observable<AvailabilitySet> createResourceAsync() {
        final AvailabilitySetImpl self = this;
        if (((AvailabilitySetInner)((Object)this.inner())).platformFaultDomainCount() == null) {
            ((AvailabilitySetInner)((Object)this.inner())).withPlatformFaultDomainCount(2);
        }
        if (((AvailabilitySetInner)((Object)this.inner())).platformUpdateDomainCount() == null) {
            ((AvailabilitySetInner)((Object)this.inner())).withPlatformUpdateDomainCount(5);
        }
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).availabilitySets().createOrUpdateAsync(this.resourceGroupName(), this.name(), (AvailabilitySetInner)((Object)this.inner())).map((Func1)new Func1<AvailabilitySetInner, AvailabilitySet>(){

            public AvailabilitySet call(AvailabilitySetInner availabilitySetInner) {
                self.setInner((Object)availabilitySetInner);
                AvailabilitySetImpl.this.idOfVMsInSet = null;
                return self;
            }
        });
    }
}

