/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.msi.implementation;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.AzureResponseBuilder;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.msi.Identities;
import com.microsoft.azure.management.msi.implementation.IdentitesImpl;
import com.microsoft.azure.management.msi.implementation.ManagedServiceIdentityClientImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.AzureConfigurable;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.Manager;
import com.microsoft.azure.management.resources.fluentcore.utils.ProviderRegistrationInterceptor;
import com.microsoft.azure.management.resources.fluentcore.utils.ResourceManagerThrottlingInterceptor;
import com.microsoft.azure.serializer.AzureJacksonAdapter;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.protocol.Environment;
import com.microsoft.rest.protocol.ResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;
import okhttp3.Interceptor;

public final class MSIManager
extends Manager<MSIManager, ManagedServiceIdentityClientImpl> {
    private final GraphRbacManager rbacManager;
    private Identities identities;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static MSIManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
        return new MSIManager(new RestClient.Builder().withBaseUrl((Environment)credentials.environment(), (Environment.Endpoint)AzureEnvironment.Endpoint.RESOURCE_MANAGER).withCredentials((ServiceClientCredentials)credentials).withSerializerAdapter((SerializerAdapter)new AzureJacksonAdapter()).withResponseBuilderFactory((ResponseBuilder.Factory)new AzureResponseBuilder.Factory()).withInterceptor((Interceptor)new ProviderRegistrationInterceptor(credentials)).withInterceptor((Interceptor)new ResourceManagerThrottlingInterceptor()).build(), subscriptionId);
    }

    public static MSIManager authenticate(RestClient restClient, String subscriptionId) {
        return new MSIManager(restClient, subscriptionId);
    }

    private MSIManager(RestClient restClient, String subscriptionId) {
        super(restClient, subscriptionId, (Object)new ManagedServiceIdentityClientImpl(restClient).withSubscriptionId(subscriptionId));
        this.rbacManager = GraphRbacManager.authenticate((RestClient)restClient, (String)((AzureTokenCredentials)restClient.credentials()).domain());
    }

    public Identities identities() {
        if (this.identities == null) {
            this.identities = new IdentitesImpl(((ManagedServiceIdentityClientImpl)((Object)this.inner())).userAssignedIdentities(), this);
        }
        return this.identities;
    }

    public GraphRbacManager graphRbacManager() {
        return this.rbacManager;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public MSIManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
            return MSIManager.authenticate(this.buildRestClient(credentials), subscriptionId);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public MSIManager authenticate(AzureTokenCredentials var1, String var2);
    }
}

