/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.redis.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.redis.RedisCache;
import com.microsoft.azure.management.redis.RedisPatchSchedule;
import com.microsoft.azure.management.redis.implementation.RedisCacheImpl;
import com.microsoft.azure.management.redis.implementation.RedisManagementClientImpl;
import com.microsoft.azure.management.redis.implementation.RedisManager;
import com.microsoft.azure.management.redis.implementation.RedisPatchScheduleImpl;
import com.microsoft.azure.management.redis.implementation.RedisPatchScheduleInner;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.ExternalChildResourcesCachedImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@LangDefinition
class RedisPatchSchedulesImpl
extends ExternalChildResourcesCachedImpl<RedisPatchScheduleImpl, RedisPatchSchedule, RedisPatchScheduleInner, RedisCacheImpl, RedisCache> {
    private final String patchScheduleName = "default";

    RedisPatchSchedulesImpl(RedisCacheImpl parent) {
        super((Object)parent, parent.taskGroup(), "PatchSchedule");
        if (parent.id() != null) {
            this.cacheCollection();
        }
    }

    Map<String, RedisPatchSchedule> patchSchedulesAsMap() {
        HashMap result = new HashMap();
        for (Map.Entry entry : this.collection().entrySet()) {
            RedisPatchScheduleImpl patchSchedule = (RedisPatchScheduleImpl)entry.getValue();
            result.put(entry.getKey(), patchSchedule);
        }
        return Collections.unmodifiableMap(result);
    }

    public void addPatchSchedule(RedisPatchScheduleImpl patchSchedule) {
        this.addChildResource(patchSchedule);
    }

    public RedisPatchScheduleImpl getPatchSchedule() {
        return (RedisPatchScheduleImpl)this.collection().get(this.patchScheduleName);
    }

    public void removePatchSchedule() {
        RedisPatchScheduleImpl psch = this.getPatchSchedule();
        if (psch != null) {
            psch.deleteResourceAsync().toBlocking().last();
        }
    }

    public RedisPatchScheduleImpl defineInlinePatchSchedule() {
        return (RedisPatchScheduleImpl)this.prepareInlineDefine(this.patchScheduleName);
    }

    public RedisPatchScheduleImpl updateInlinePatchSchedule() {
        return (RedisPatchScheduleImpl)this.prepareInlineUpdate(this.patchScheduleName);
    }

    public void deleteInlinePatchSchedule() {
        this.prepareInlineRemove(this.patchScheduleName);
    }

    protected List<RedisPatchScheduleImpl> listChildResources() {
        ArrayList<RedisPatchScheduleImpl> childResources = new ArrayList<RedisPatchScheduleImpl>();
        for (RedisPatchScheduleInner patchSchedule : ((RedisManagementClientImpl)((Object)((RedisManager)((RedisCacheImpl)this.parent()).manager()).inner())).patchSchedules().listByRedisResource(((RedisCacheImpl)this.parent()).resourceGroupName(), ((RedisCacheImpl)this.parent()).name())) {
            childResources.add(new RedisPatchScheduleImpl(patchSchedule.name(), (RedisCacheImpl)this.parent(), patchSchedule));
        }
        return Collections.unmodifiableList(childResources);
    }

    protected RedisPatchScheduleImpl newChildResource(String name) {
        return new RedisPatchScheduleImpl(name, (RedisCacheImpl)this.parent(), new RedisPatchScheduleInner());
    }
}

