/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.decoders.ProtonStreamDecoder;
import org.apache.qpid.protonj2.codec.decoders.UTF8StreamDecoder;

public final class ProtonStreamDecoderState
implements StreamDecoderState {
    private static final int MAX_CHAR_BUFFER_CACHE_SIZE = 100;
    private final CharsetDecoder STRING_DECODER = StandardCharsets.UTF_8.newDecoder();
    private final ProtonStreamDecoder decoder;
    private final char[] decodeCache = new char[100];
    private UTF8StreamDecoder stringDecoder;

    public ProtonStreamDecoderState(ProtonStreamDecoder decoder) {
        this.decoder = decoder;
    }

    @Override
    public ProtonStreamDecoder getDecoder() {
        return this.decoder;
    }

    @Override
    public ProtonStreamDecoderState reset() {
        return this;
    }

    public UTF8StreamDecoder getStringDecoder() {
        return this.stringDecoder;
    }

    public void setStringDecoder(UTF8StreamDecoder stringDecoder) {
        this.stringDecoder = stringDecoder;
    }

    @Override
    public String decodeUTF8(InputStream stream, int length) throws DecodeException {
        try {
            if (this.stringDecoder == null) {
                return ProtonStreamDecoderState.internalDecode(stream, length, this.STRING_DECODER, length > 100 ? new char[length] : this.decodeCache);
            }
            return this.stringDecoder.decodeUTF8(stream);
        }
        catch (Exception ex) {
            throw new DecodeException("Cannot parse encoded UTF8 String", ex);
        }
    }

    private static String internalDecode(InputStream stream, int length, CharsetDecoder decoder, char[] scratch) throws IOException {
        int offset;
        int lastRead = 0;
        for (offset = 0; offset < length; ++offset) {
            lastRead = stream.read();
            if (lastRead < 0) {
                throw new EOFException("Reached end of stream before decoding the full String content");
            }
            if (lastRead > 127) break;
            scratch[offset] = (char)lastRead;
        }
        if (offset == length) {
            return new String(scratch, 0, length);
        }
        return ProtonStreamDecoderState.internalDecodeUTF8(stream, length, scratch, (byte)lastRead, offset, decoder);
    }

    private static String internalDecodeUTF8(InputStream stream, int length, char[] chars, byte stoppageByte, int offset, CharsetDecoder decoder) throws IOException {
        CharBuffer out = CharBuffer.wrap(chars);
        out.position(offset);
        byte[] trailingBytes = new byte[length - offset];
        trailingBytes[0] = stoppageByte;
        stream.read(trailingBytes, 1, trailingBytes.length - 1);
        ByteBuffer byteBuffer = ByteBuffer.wrap(trailingBytes);
        try {
            Object cr;
            while (true) {
                Object object = cr = byteBuffer.hasRemaining() ? decoder.decode(byteBuffer, out, true) : CoderResult.UNDERFLOW;
                if (((CoderResult)cr).isUnderflow()) {
                    cr = decoder.flush(out);
                }
                if (((CoderResult)cr).isUnderflow()) break;
                ((CoderResult)cr).throwException();
            }
            cr = out.flip().toString();
            return cr;
        }
        catch (CharacterCodingException e) {
            throw new DecodeException("Cannot parse encoded UTF8 String", e);
        }
        finally {
            decoder.reset();
        }
    }
}

