/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.utilint.LongDiffStat;
import com.sleepycat.je.utilint.MapStat;
import com.sleepycat.je.utilint.Stat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;

public final class LongDiffMapStat
extends MapStat<Long, LongDiffStat> {
    private static final long serialVersionUID = 1L;
    private final long validityMillis;

    public LongDiffMapStat(StatGroup group, StatDefinition definition, long validityMillis) {
        super(group, definition);
        assert (definition.getType() == StatDefinition.StatType.CUMULATIVE);
        assert (validityMillis > 0L);
        this.validityMillis = validityMillis;
    }

    private LongDiffMapStat(LongDiffMapStat other) {
        super(other);
        this.validityMillis = other.validityMillis;
    }

    public synchronized LongDiffStat createStat(String key, Stat<Long> base) {
        LongDiffStat stat = new LongDiffStat(base, this.validityMillis);
        this.statMap.put(key, stat);
        return stat;
    }

    @Override
    public LongDiffMapStat copy() {
        return new LongDiffMapStat(this);
    }

    public LongDiffMapStat computeInterval(Stat<String> base) {
        return this.copy();
    }

    @Override
    public synchronized void negate() {
    }
}

