/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.math.BigDecimal;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.iapi.types.SQLDecimal;
import org.apache.derby.iapi.types.SQLDouble;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.iapi.types.SQLReal;
import org.apache.derby.iapi.types.SQLSmallint;
import org.apache.derby.iapi.types.SQLTinyint;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

public final class NumericConstantNode
extends ConstantNode {
    static final int K_TINYINT = 0;
    static final int K_SMALLINT = 1;
    static final int K_INT = 2;
    static final int K_BIGINT = 3;
    static final int K_DECIMAL = 4;
    static final int K_DOUBLE = 5;
    static final int K_REAL = 6;
    final int kind;

    NumericConstantNode(TypeId typeId, ContextManager contextManager) throws StandardException {
        super(contextManager);
        this.setType(typeId, this.getPrecision(typeId, null), this.getScale(typeId, null), true, this.getMaxWidth(typeId, null));
        this.kind = this.getKind(typeId);
    }

    NumericConstantNode(TypeId typeId, Number number, ContextManager contextManager) throws StandardException {
        super(contextManager);
        this.kind = this.getKind(typeId);
        this.setType(typeId, this.getPrecision(typeId, number), this.getScale(typeId, number), false, this.getMaxWidth(typeId, number));
        this.setValue(typeId, number);
    }

    private int getPrecision(TypeId typeId, Number number) throws StandardException {
        switch (typeId.getJDBCTypeId()) {
            case -6: {
                return 5;
            }
            case 4: {
                return 10;
            }
            case 5: {
                return 5;
            }
            case -5: {
                return 19;
            }
            case 3: {
                if (number != null) {
                    SQLDecimal sQLDecimal = new SQLDecimal((BigDecimal)number);
                    return sQLDecimal.getDecimalValuePrecision();
                }
                return 31;
            }
            case 8: {
                return 52;
            }
            case 7: {
                return 23;
            }
        }
        return 0;
    }

    private int getScale(TypeId typeId, Object object) throws StandardException {
        switch (typeId.getJDBCTypeId()) {
            case -6: {
                return 0;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 0;
            }
            case -5: {
                return 0;
            }
            case 3: {
                if (object != null) {
                    SQLDecimal sQLDecimal = new SQLDecimal((BigDecimal)object);
                    return sQLDecimal.getDecimalValueScale();
                }
                return 31;
            }
            case 8: {
                return 0;
            }
            case 7: {
                return 0;
            }
        }
        return 0;
    }

    private int getMaxWidth(TypeId typeId, Object object) throws StandardException {
        switch (typeId.getJDBCTypeId()) {
            case -6: {
                return object != null ? 2 : 0;
            }
            case 4: {
                return object != null ? 4 : 0;
            }
            case 5: {
                return object != null ? 2 : 0;
            }
            case -5: {
                return object != null ? 8 : 0;
            }
            case 3: {
                if (object != null) {
                    SQLDecimal sQLDecimal = new SQLDecimal((BigDecimal)object);
                    int n = sQLDecimal.getDecimalValuePrecision();
                    int n2 = sQLDecimal.getDecimalValueScale();
                    return DataTypeUtilities.computeMaxWidth(n, n2);
                }
                return 31;
            }
            case 8: {
                return object != null ? 8 : 0;
            }
            case 7: {
                return object != null ? 4 : 0;
            }
        }
        return 0;
    }

    private int getKind(TypeId typeId) {
        switch (typeId.getJDBCTypeId()) {
            case -6: {
                return 0;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 1;
            }
            case -5: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 8: {
                return 5;
            }
            case 7: {
                return 6;
            }
        }
        return -1;
    }

    private void setValue(TypeId typeId, Number number) throws StandardException {
        switch (typeId.getJDBCTypeId()) {
            case -6: {
                this.setValue(new SQLTinyint((Byte)number));
                break;
            }
            case 4: {
                this.setValue(new SQLInteger((Integer)number));
                break;
            }
            case 5: {
                this.setValue(new SQLSmallint((Short)number));
                break;
            }
            case -5: {
                this.setValue(new SQLLongint((Long)number));
                break;
            }
            case 3: {
                this.setValue(new SQLDecimal((BigDecimal)number));
                break;
            }
            case 8: {
                this.setValue(new SQLDouble((Double)number));
                break;
            }
            case 7: {
                this.setValue(new SQLReal((Float)number));
                break;
            }
        }
    }

    @Override
    Object getConstantValueAsObject() throws StandardException {
        return this.value.getObject();
    }

    @Override
    void generateConstant(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        switch (this.kind) {
            case 2: {
                methodBuilder.push(this.value.getInt());
                break;
            }
            case 0: {
                methodBuilder.push(this.value.getByte());
                break;
            }
            case 1: {
                methodBuilder.push(this.value.getShort());
                break;
            }
            case 4: {
                methodBuilder.pushNewStart("java.math.BigDecimal");
                methodBuilder.push(this.value.getString());
                methodBuilder.pushNewComplete(1);
                break;
            }
            case 5: {
                methodBuilder.push(this.value.getDouble());
                break;
            }
            case 6: {
                methodBuilder.push(this.value.getFloat());
                break;
            }
            case 3: {
                methodBuilder.push(this.value.getLong());
                break;
            }
        }
    }

    @Override
    boolean isSameNodeKind(ValueNode valueNode) {
        return super.isSameNodeKind(valueNode) && ((NumericConstantNode)valueNode).kind == this.kind;
    }
}

