/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.pinot.segment.local.segment.index.map;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.index.IndexReader;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.partition.PartitionFunction;
import org.apache.pinot.spi.data.ComplexFieldSpec;
import org.apache.pinot.spi.data.FieldSpec;


public class MapIndexReaderWrapper implements org.apache.pinot.segment.spi.index.reader.MapIndexReader {
  private final ForwardIndexReader _forwardIndexReader;
  private final ComplexFieldSpec.MapFieldSpec _mapFieldSpec;

  public MapIndexReaderWrapper(ForwardIndexReader forwardIndexReader, ComplexFieldSpec.MapFieldSpec mapFieldSpec) {
    _forwardIndexReader = forwardIndexReader;
    _mapFieldSpec = mapFieldSpec;
  }

  @Override
  public Set<String> getKeys() {
    throw new UnsupportedOperationException();
  }

  @Override
  public Map<IndexType, IndexReader> getKeyIndexes(String key) {
    return Map.of(StandardIndexes.forward(), new MapKeyIndexReader(_forwardIndexReader, key, getKeyFieldSpec(key)));
  }

  @Override
  public FieldSpec getKeyFieldSpec(String key) {
    return _mapFieldSpec.getValueFieldSpec();
  }

  @Override
  public FieldSpec.DataType getKeyStoredType(String key) {
    return _mapFieldSpec.getValueFieldSpec().getDataType();
  }

  @Override
  public ColumnMetadata getKeyMetadata(String key) {
    return new ColumnMetadata() {
      @Override
      public FieldSpec getFieldSpec() {
        return _mapFieldSpec.getValueFieldSpec();
      }

      @Override
      public int getTotalDocs() {
        return 0;
      }

      @Override
      public int getCardinality() {
        return 0;
      }

      @Override
      public boolean isSorted() {
        return false;
      }

      @Override
      public Comparable getMinValue() {
        return null;
      }

      @Override
      public Comparable getMaxValue() {
        return null;
      }

      @Override
      public boolean hasDictionary() {
        return false;
      }

      @Override
      public int getColumnMaxLength() {
        return 0;
      }

      @Override
      public int getBitsPerElement() {
        return 0;
      }

      @Override
      public int getMaxNumberOfMultiValues() {
        return 0;
      }

      @Override
      public int getTotalNumberOfEntries() {
        return 0;
      }

      @Nullable
      @Override
      public PartitionFunction getPartitionFunction() {
        return null;
      }

      @Nullable
      @Override
      public Set<Integer> getPartitions() {
        return null;
      }

      @Override
      public Map<IndexType<?, ?, ?>, Long> getIndexSizeMap() {
        return Map.of();
      }

      @Override
      public boolean isAutoGenerated() {
        return false;
      }
    };
  }

  @Override
  public IndexReader getKeyReader(String key, IndexType indexType) {
    return getKeyIndexes(key).get(indexType);
  }

  @Override
  public boolean isDictionaryEncoded() {
    return false;
  }

  @Override
  public boolean isSingleValue() {
    return true;
  }

  @Override
  public FieldSpec.DataType getStoredType() {
    return FieldSpec.DataType.MAP;
  }

  @Override
  public void close()
      throws IOException {
  }
}
