/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.optimizer;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.CombinerPackager;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PODistinct;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POGlobalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLimit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPreCombinerLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.Packager;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.util.PlanHelper;
import org.apache.pig.backend.hadoop.executionengine.spark.operator.POGlobalRearrangeSpark;
import org.apache.pig.backend.hadoop.executionengine.spark.operator.POReduceBySpark;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperPlan;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperator;
import org.apache.pig.backend.hadoop.executionengine.util.CombinerOptimizerUtil;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.plan.optimizer.OptimizerException;
import org.apache.pig.impl.util.Pair;

public class CombinerOptimizer
extends SparkOpPlanVisitor {
    private static Log LOG = LogFactory.getLog(CombinerOptimizer.class);

    public CombinerOptimizer(SparkOperPlan plan) {
        super(plan, (PlanWalker<SparkOperator, SparkOperPlan>)new DepthFirstWalker<SparkOperator, SparkOperPlan>(plan));
    }

    @Override
    public void visitSparkOp(SparkOperator sparkOp) throws VisitorException {
        try {
            this.addCombiner(sparkOp.physicalPlan);
        }
        catch (Exception e) {
            throw new VisitorException(e);
        }
    }

    private void addCombiner(PhysicalPlan phyPlan) throws VisitorException, PlanException, CloneNotSupportedException {
        List leaves = phyPlan.getLeaves();
        if (leaves == null || leaves.size() != 1) {
            return;
        }
        LinkedList<POGlobalRearrange> glrs = PlanHelper.getPhysicalOperators(phyPlan, POGlobalRearrange.class);
        if (glrs == null || glrs.size() == 0) {
            return;
        }
        for (POGlobalRearrange glr : glrs) {
            POForEach postReduceFE;
            List<PhysicalPlan> feInners;
            List<Pair<PhysicalOperator, PhysicalPlan>> algebraicOps;
            POForEach foreach;
            List<POForEach> foreachSuccessors;
            List<PhysicalOperator> limitSucs;
            PhysicalOperator successor;
            POPackage poPackage;
            List<POPackage> poPackageSuccessors;
            List<POGlobalRearrange> glrSuccessors = phyPlan.getSuccessors(glr);
            if (glrSuccessors == null || glrSuccessors.isEmpty() || !(glrSuccessors.get(0) instanceof POPackage) || (poPackageSuccessors = phyPlan.getSuccessors(poPackage = (POPackage)((Object)glrSuccessors.get(0)))) == null || poPackageSuccessors.size() != 1) continue;
            PhysicalOperator packageSuccessor = successor = (PhysicalOperator)poPackageSuccessors.get(0);
            if (successor instanceof POLimit && (limitSucs = phyPlan.getSuccessors(successor)) != null && limitSucs.size() == 1 && limitSucs.get(0) instanceof POForEach) {
                successor = limitSucs.get(0);
            }
            if (!(successor instanceof POForEach) || (foreachSuccessors = phyPlan.getSuccessors(foreach = (POForEach)successor)) == null || foreachSuccessors.size() != 1 || (algebraicOps = CombinerOptimizerUtil.findAlgebraicOps(feInners = (postReduceFE = foreach.clone()).getInputPlans())) == null || algebraicOps.size() == 0) continue;
            try {
                List<POGlobalRearrange> glrPredecessors = phyPlan.getPredecessors(glr);
                if (glrPredecessors == null || glrPredecessors.size() != 1 || !(glrPredecessors.get(0) instanceof POLocalRearrange)) continue;
                POLocalRearrange rearrange = (POLocalRearrange)((Object)glrPredecessors.get(0));
                LOG.info((Object)"Algebraic operations found. Optimizing plan to use combiner.");
                this.convertToMapSideForEach(phyPlan, poPackage);
                for (Pair<PhysicalOperator, PhysicalPlan> op2plan : algebraicOps) {
                    if (!(op2plan.first instanceof PODistinct)) continue;
                    CombinerOptimizerUtil.DistinctPatcher distinctPatcher = new CombinerOptimizerUtil.DistinctPatcher((PhysicalPlan)op2plan.second);
                    distinctPatcher.visit();
                    if (distinctPatcher.getDistinct() == null) {
                        int errCode = 2073;
                        String msg = "Problem with replacing distinct operator with distinct built-in function.";
                        throw new PlanException(msg, errCode, 4);
                    }
                    op2plan.first = distinctPatcher.getDistinct();
                }
                POForEach mfe = CombinerOptimizerUtil.createForEachWithGrpProj(postReduceFE, poPackage.getPkgr().getKeyType());
                HashMap op2newpos = Maps.newHashMap();
                Integer pos = 1;
                for (Pair<PhysicalOperator, PhysicalPlan> op2plan : algebraicOps) {
                    PhysicalPlan udfPlan = CombinerOptimizerUtil.createPlanWithPredecessors((PhysicalOperator)op2plan.first, (PhysicalPlan)op2plan.second);
                    mfe.addInputPlan(udfPlan, false);
                    Integer n = pos;
                    Integer n2 = pos = Integer.valueOf(pos + 1);
                    op2newpos.put(op2plan.first, n);
                }
                CombinerOptimizerUtil.changeFunc(mfe, (byte)0);
                for (PhysicalPlan mpl : mfe.getInputPlans()) {
                    try {
                        new CombinerOptimizerUtil.fixMapProjects(mpl).visit();
                    }
                    catch (VisitorException e) {
                        int errCode = 2089;
                        String msg = "Unable to flag project operator to use single tuple bag.";
                        throw new PlanException(msg, errCode, 4, (Throwable)e);
                    }
                }
                POForEach cfe = CombinerOptimizerUtil.createForEachWithGrpProj(postReduceFE, poPackage.getPkgr().getKeyType());
                CombinerOptimizerUtil.addAlgebraicFuncToCombineFE(cfe, op2newpos);
                mfe.setInputPlans(mfe.getInputPlans());
                cfe.setInputPlans(cfe.getInputPlans());
                int numFields = algebraicOps.size() + 1;
                boolean[] bags = new boolean[numFields];
                bags[0] = false;
                for (int i = 1; i < numFields; ++i) {
                    bags[i] = true;
                }
                CombinerPackager pkgr = new CombinerPackager(poPackage.getPkgr(), bags);
                POPackage combinePack = poPackage.clone();
                combinePack.setPkgr(pkgr);
                POLocalRearrange newRearrange = CombinerOptimizerUtil.getNewRearrange(rearrange);
                POPreCombinerLocalRearrange combinerLocalRearrange = CombinerOptimizerUtil.getPreCombinerLR(rearrange);
                phyPlan.replace(rearrange, combinerLocalRearrange);
                POReduceBySpark reduceOperator = new POReduceBySpark(cfe.getOperatorKey(), combinerLocalRearrange.getRequestedParallelism(), cfe.getInputPlans(), cfe.getToBeFlattened(), combinePack, newRearrange);
                reduceOperator.setCustomPartitioner(glr.getCustomPartitioner());
                this.fixReduceSideFE(postReduceFE, algebraicOps);
                CombinerOptimizerUtil.changeFunc(reduceOperator, (byte)1);
                this.updatePackager(reduceOperator, newRearrange);
                phyPlan.add(reduceOperator);
                phyPlan.add(mfe);
                phyPlan.connect(mfe, reduceOperator);
                phyPlan.disconnect(combinerLocalRearrange, packageSuccessor);
                phyPlan.connect(reduceOperator, packageSuccessor);
                phyPlan.connect(combinerLocalRearrange, mfe);
                phyPlan.add(postReduceFE);
                phyPlan.replace(foreach, postReduceFE);
            }
            catch (Exception e) {
                int errCode = 2018;
                String msg = "Internal error. Unable to introduce the combiner for optimization.";
                throw new OptimizerException(msg, errCode, 4, (Throwable)e);
            }
        }
    }

    private void fixReduceSideFE(POForEach postReduceFE, List<Pair<PhysicalOperator, PhysicalPlan>> algebraicOps) throws ExecException, PlanException {
        int i = 1;
        for (Pair<PhysicalOperator, PhysicalPlan> algebraicOp : algebraicOps) {
            POUserFunc combineUdf = (POUserFunc)algebraicOp.first;
            PhysicalPlan pplan = (PhysicalPlan)algebraicOp.second;
            combineUdf.setAlgebraicFunction((byte)2);
            POProject newProj = new POProject(CombinerOptimizerUtil.createOperatorKey(postReduceFE.getOperatorKey().getScope()), 1, i);
            newProj.setResultType((byte)120);
            for (PhysicalOperator originalUdfInput : pplan.getPredecessors(combineUdf).toArray(new PhysicalOperator[0])) {
                if (pplan.getPredecessors(originalUdfInput) != null) {
                    pplan.trimAbove(originalUdfInput);
                }
                pplan.remove(originalUdfInput);
            }
            pplan.add(newProj);
            pplan.connect(newProj, combineUdf);
            ++i;
        }
        postReduceFE.setResultType((byte)110);
    }

    private void convertToMapSideForEach(PhysicalPlan physicalPlan, POPackage poPackage) throws PlanException {
        LinkedList<PhysicalOperator> operatorsToRemove = new LinkedList<PhysicalOperator>();
        for (PhysicalOperator physicalOperator : physicalPlan.getPredecessors(poPackage)) {
            if (!(physicalOperator instanceof POGlobalRearrangeSpark)) continue;
            operatorsToRemove.add(physicalOperator);
            break;
        }
        for (PhysicalOperator physicalOperator : operatorsToRemove) {
            physicalPlan.removeAndReconnect(physicalOperator);
        }
        physicalPlan.removeAndReconnect(poPackage);
    }

    private void updatePackager(POReduceBySpark reduceOperator, POLocalRearrange lrearrange) throws OptimizerException {
        Packager pkgr = reduceOperator.getPKGOp().getPkgr();
        Map<Integer, Pair<Boolean, Map<Integer, Integer>>> keyInfo = pkgr.getKeyInfo();
        if (keyInfo == null) {
            keyInfo = new HashMap<Integer, Pair<Boolean, Map<Integer, Integer>>>();
        }
        if (keyInfo.get(lrearrange.getIndex()) != null) {
            int errCode = 2087;
            String msg = "Unexpected problem during optimization. Found index:" + lrearrange.getIndex() + " in multiple LocalRearrange operators.";
            throw new OptimizerException(msg, errCode, 4);
        }
        keyInfo.put(Integer.valueOf(lrearrange.getIndex()), new Pair<Boolean, Map<Integer, Integer>>(lrearrange.isProjectStar(), lrearrange.getProjectedColsMap()));
        pkgr.setKeyInfo(keyInfo);
        pkgr.setKeyTuple(lrearrange.isKeyTuple());
        pkgr.setKeyCompound(lrearrange.isKeyCompound());
    }

    private static POUserFunc getAlgebraicSuccessor(PhysicalPlan pplan) {
        List leaves = pplan.getLeaves();
        if (leaves == null || leaves.size() != 1) {
            return null;
        }
        PhysicalOperator succ = (PhysicalOperator)leaves.get(0);
        if (succ instanceof POUserFunc && ((POUserFunc)succ).combinable()) {
            return (POUserFunc)succ;
        }
        return null;
    }
}

