/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.ipc.Transceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatagramTransceiver
extends Transceiver {
    private static final Logger LOG = LoggerFactory.getLogger(DatagramTransceiver.class);
    private static final int MAX_SIZE = 16384;
    private DatagramChannel channel;
    private SocketAddress remote;
    private ByteBuffer buffer = ByteBuffer.allocate(16384);

    @Override
    public String getRemoteName() {
        return this.remote.toString();
    }

    public DatagramTransceiver(SocketAddress remote) throws IOException {
        this(DatagramChannel.open());
        this.remote = remote;
    }

    public DatagramTransceiver(DatagramChannel channel) {
        this.channel = channel;
    }

    @Override
    public synchronized List<ByteBuffer> readBuffers() throws IOException {
        this.buffer.clear();
        this.remote = this.channel.receive(this.buffer);
        LOG.info("received from " + this.remote);
        this.buffer.flip();
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        int length;
        while ((length = this.buffer.getInt()) != 0) {
            ByteBuffer chunk = this.buffer.slice();
            chunk.limit(length);
            this.buffer.position(this.buffer.position() + length);
            buffers.add(chunk);
        }
        return buffers;
    }

    @Override
    public synchronized void writeBuffers(List<ByteBuffer> buffers) throws IOException {
        this.buffer.clear();
        for (ByteBuffer b : buffers) {
            this.buffer.putInt(b.remaining());
            this.buffer.put(b);
        }
        this.buffer.putInt(0);
        this.buffer.flip();
        this.channel.send(this.buffer, this.remote);
        LOG.info("sent to " + this.remote);
    }
}

