/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;

class TimelineEntityConverterV2 {
    private static final Log LOG = LogFactory.getLog(TimelineEntityConverterV2.class);
    static final String JOB = "MAPREDUCE_JOB";
    static final String TASK = "MAPREDUCE_TASK";
    static final String TASK_ATTEMPT = "MAPREDUCE_TASK_ATTEMPT";

    TimelineEntityConverterV2() {
    }

    public List<TimelineEntity> createTimelineEntities(JobHistoryParser.JobInfo jobInfo, Configuration conf) {
        ArrayList<TimelineEntity> entities = new ArrayList<TimelineEntity>();
        TimelineEntity job = this.createJobEntity(jobInfo, conf);
        entities.add(job);
        List<TimelineEntity> tasksAndAttempts = this.createTaskAndTaskAttemptEntities(jobInfo);
        entities.addAll(tasksAndAttempts);
        return entities;
    }

    private TimelineEntity createJobEntity(JobHistoryParser.JobInfo jobInfo, Configuration conf) {
        TimelineEntity job = new TimelineEntity();
        job.setType(JOB);
        job.setId(jobInfo.getJobId().toString());
        job.setCreatedTime(Long.valueOf(jobInfo.getSubmitTime()));
        job.addInfo("JOBNAME", (Object)jobInfo.getJobname());
        job.addInfo("USERNAME", (Object)jobInfo.getUsername());
        job.addInfo("JOB_QUEUE_NAME", (Object)jobInfo.getJobQueueName());
        job.addInfo("SUBMIT_TIME", (Object)jobInfo.getSubmitTime());
        job.addInfo("LAUNCH_TIME", (Object)jobInfo.getLaunchTime());
        job.addInfo("FINISH_TIME", (Object)jobInfo.getFinishTime());
        job.addInfo("JOB_STATUS", (Object)jobInfo.getJobStatus());
        job.addInfo("PRIORITY", (Object)jobInfo.getPriority());
        job.addInfo("TOTAL_MAPS", (Object)jobInfo.getTotalMaps());
        job.addInfo("TOTAL_REDUCES", (Object)jobInfo.getTotalReduces());
        job.addInfo("UBERIZED", (Object)jobInfo.getUberized());
        job.addInfo("ERROR_INFO", (Object)jobInfo.getErrorInfo());
        Counters totalCounters = jobInfo.getTotalCounters();
        if (totalCounters != null) {
            this.addMetrics(job, totalCounters);
        }
        this.addConfiguration(job, conf);
        LOG.info((Object)("converted job " + jobInfo.getJobId() + " to a timeline entity"));
        return job;
    }

    private void addConfiguration(TimelineEntity job, Configuration conf) {
        for (Map.Entry e : conf) {
            job.addConfig((String)e.getKey(), (String)e.getValue());
        }
    }

    private void addMetrics(TimelineEntity entity, Counters counters) {
        for (CounterGroup g : counters) {
            String groupName = g.getName();
            for (Counter c : g) {
                String name = groupName + ":" + c.getName();
                TimelineMetric metric = new TimelineMetric();
                metric.setId(name);
                metric.addValue(System.currentTimeMillis(), (Number)c.getValue());
                entity.addMetric(metric);
            }
        }
    }

    private List<TimelineEntity> createTaskAndTaskAttemptEntities(JobHistoryParser.JobInfo jobInfo) {
        ArrayList<TimelineEntity> entities = new ArrayList<TimelineEntity>();
        Map taskInfoMap = jobInfo.getAllTasks();
        LOG.info((Object)("job " + jobInfo.getJobId() + " has " + taskInfoMap.size() + " tasks"));
        for (JobHistoryParser.TaskInfo taskInfo : taskInfoMap.values()) {
            TimelineEntity task = this.createTaskEntity(taskInfo);
            entities.add(task);
            Set<TimelineEntity> taskAttempts = this.createTaskAttemptEntities(taskInfo);
            entities.addAll(taskAttempts);
        }
        return entities;
    }

    private TimelineEntity createTaskEntity(JobHistoryParser.TaskInfo taskInfo) {
        TimelineEntity task = new TimelineEntity();
        task.setType(TASK);
        task.setId(taskInfo.getTaskId().toString());
        task.setCreatedTime(Long.valueOf(taskInfo.getStartTime()));
        task.addInfo("START_TIME", (Object)taskInfo.getStartTime());
        task.addInfo("FINISH_TIME", (Object)taskInfo.getFinishTime());
        task.addInfo("TASK_TYPE", (Object)taskInfo.getTaskType());
        task.addInfo("TASK_STATUS", (Object)taskInfo.getTaskStatus());
        task.addInfo("ERROR_INFO", (Object)taskInfo.getError());
        Counters counters = taskInfo.getCounters();
        if (counters != null) {
            this.addMetrics(task, counters);
        }
        LOG.info((Object)("converted task " + taskInfo.getTaskId() + " to a timeline entity"));
        return task;
    }

    private Set<TimelineEntity> createTaskAttemptEntities(JobHistoryParser.TaskInfo taskInfo) {
        HashSet<TimelineEntity> taskAttempts = new HashSet<TimelineEntity>();
        Map taskAttemptInfoMap = taskInfo.getAllTaskAttempts();
        LOG.info((Object)("task " + taskInfo.getTaskId() + " has " + taskAttemptInfoMap.size() + " task attempts"));
        for (JobHistoryParser.TaskAttemptInfo taskAttemptInfo : taskAttemptInfoMap.values()) {
            TimelineEntity taskAttempt = this.createTaskAttemptEntity(taskAttemptInfo);
            taskAttempts.add(taskAttempt);
        }
        return taskAttempts;
    }

    private TimelineEntity createTaskAttemptEntity(JobHistoryParser.TaskAttemptInfo taskAttemptInfo) {
        TimelineEntity taskAttempt = new TimelineEntity();
        taskAttempt.setType(TASK_ATTEMPT);
        taskAttempt.setId(taskAttemptInfo.getAttemptId().toString());
        taskAttempt.setCreatedTime(Long.valueOf(taskAttemptInfo.getStartTime()));
        taskAttempt.addInfo("START_TIME", (Object)taskAttemptInfo.getStartTime());
        taskAttempt.addInfo("FINISH_TIME", (Object)taskAttemptInfo.getFinishTime());
        taskAttempt.addInfo("MAP_FINISH_TIME", (Object)taskAttemptInfo.getMapFinishTime());
        taskAttempt.addInfo("SHUFFLE_FINISH_TIME", (Object)taskAttemptInfo.getShuffleFinishTime());
        taskAttempt.addInfo("SORT_FINISH_TIME", (Object)taskAttemptInfo.getSortFinishTime());
        taskAttempt.addInfo("TASK_STATUS", (Object)taskAttemptInfo.getTaskStatus());
        taskAttempt.addInfo("STATE", (Object)taskAttemptInfo.getState());
        taskAttempt.addInfo("ERROR", (Object)taskAttemptInfo.getError());
        taskAttempt.addInfo("CONTAINER_ID", (Object)taskAttemptInfo.getContainerId().toString());
        Counters counters = taskAttemptInfo.getCounters();
        if (counters != null) {
            this.addMetrics(taskAttempt, counters);
        }
        LOG.info((Object)("converted task attempt " + taskAttemptInfo.getAttemptId() + " to a timeline entity"));
        return taskAttempt;
    }
}

