/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestLambdaTestUtils
extends Assert {
    public static final int INTERVAL = 10;
    public static final int TIMEOUT = 50;
    private LambdaTestUtils.FixedRetryInterval retry = new LambdaTestUtils.FixedRetryInterval(10);
    public static final Callable<Boolean> ALWAYS_TRUE = new Callable<Boolean>(){

        @Override
        public Boolean call() throws Exception {
            return true;
        }
    };
    public static final Callable<Boolean> ALWAYS_FALSE = new Callable<Boolean>(){

        @Override
        public Boolean call() throws Exception {
            return false;
        }
    };
    public static final String MISSING = "not found";
    public static final Callable<Boolean> ALWAYS_FNFE = new Callable<Boolean>(){

        @Override
        public Boolean call() throws Exception {
            throw new FileNotFoundException(TestLambdaTestUtils.MISSING);
        }
    };
    public static final LambdaTestUtils.GenerateTimeout TIMEOUT_FAILURE_HANDLER = new LambdaTestUtils.GenerateTimeout();
    public static final Callable<Long> EVAL_3L = new Callable<Long>(){

        @Override
        public Long call() throws Exception {
            return 3L;
        }
    };
    public static final Callable<Long> EVAL_FNFE = new Callable<Long>(){

        @Override
        public Long call() throws Exception {
            throw new FileNotFoundException(TestLambdaTestUtils.MISSING);
        }
    };

    protected void assertRetryCount(int expected) {
        TestLambdaTestUtils.assertEquals((String)this.retry.toString(), (long)expected, (long)this.retry.getInvocationCount());
    }

    protected void assertMinRetryCount(int minCount) {
        TestLambdaTestUtils.assertTrue((String)("retry count of " + this.retry + " is not >= " + minCount), (minCount <= this.retry.getInvocationCount() ? 1 : 0) != 0);
    }

    @Test
    public void testAwaitAlwaysTrue() throws Throwable {
        LambdaTestUtils.await(50, ALWAYS_TRUE, new LambdaTestUtils.FixedRetryInterval(10), TIMEOUT_FAILURE_HANDLER);
    }

    @Test
    public void testAwaitAlwaysFalse() throws Throwable {
        try {
            LambdaTestUtils.await(50, ALWAYS_FALSE, this.retry, TIMEOUT_FAILURE_HANDLER);
            TestLambdaTestUtils.fail((String)"should not have got here");
        }
        catch (TimeoutException e) {
            this.assertMinRetryCount(1);
        }
    }

    @Test
    public void testAwaitLinearRetry() throws Throwable {
        LambdaTestUtils.ProportionalRetryInterval linearRetry = new LambdaTestUtils.ProportionalRetryInterval(20, 100);
        try {
            LambdaTestUtils.await(50, ALWAYS_FALSE, linearRetry, TIMEOUT_FAILURE_HANDLER);
            TestLambdaTestUtils.fail((String)"should not have got here");
        }
        catch (TimeoutException e) {
            TestLambdaTestUtils.assertEquals((String)linearRetry.toString(), (long)2L, (long)linearRetry.getInvocationCount());
        }
    }

    @Test
    public void testAwaitFNFE() throws Throwable {
        try {
            LambdaTestUtils.await(50, ALWAYS_FNFE, this.retry, TIMEOUT_FAILURE_HANDLER);
            TestLambdaTestUtils.fail((String)"should not have got here");
        }
        catch (TimeoutException e) {
            TestLambdaTestUtils.assertTrue((this.retry.getInvocationCount() > 0 ? 1 : 0) != 0);
            TestLambdaTestUtils.assertTrue((boolean)(e.getCause() instanceof FileNotFoundException));
            GenericTestUtils.assertExceptionContains(MISSING, e);
        }
    }

    @Test
    public void testRetryInterval() throws Throwable {
        LambdaTestUtils.ProportionalRetryInterval interval = new LambdaTestUtils.ProportionalRetryInterval(200, 1000);
        TestLambdaTestUtils.assertEquals((long)200L, (long)interval.call().intValue());
        TestLambdaTestUtils.assertEquals((long)400L, (long)interval.call().intValue());
        TestLambdaTestUtils.assertEquals((long)600L, (long)interval.call().intValue());
        TestLambdaTestUtils.assertEquals((long)800L, (long)interval.call().intValue());
        TestLambdaTestUtils.assertEquals((long)1000L, (long)interval.call().intValue());
        TestLambdaTestUtils.assertEquals((long)1000L, (long)interval.call().intValue());
        TestLambdaTestUtils.assertEquals((long)1000L, (long)interval.call().intValue());
    }

    @Test
    public void testInterceptSuccess() throws Throwable {
        IOException ioe = LambdaTestUtils.intercept(IOException.class, ALWAYS_FNFE);
        GenericTestUtils.assertExceptionContains(MISSING, ioe);
    }

    @Test
    public void testInterceptContains() throws Throwable {
        LambdaTestUtils.intercept(IOException.class, MISSING, ALWAYS_FNFE);
    }

    @Test
    public void testInterceptContainsWrongString() throws Throwable {
        try {
            FileNotFoundException e = LambdaTestUtils.intercept(FileNotFoundException.class, "404", ALWAYS_FNFE);
            TestLambdaTestUtils.assertNotNull((Object)e);
            throw e;
        }
        catch (AssertionError expected) {
            GenericTestUtils.assertExceptionContains(MISSING, (Throwable)((Object)expected));
            return;
        }
    }

    @Test
    public void testInterceptVoidCallable() throws Throwable {
        LambdaTestUtils.intercept(AssertionError.class, "(null)", new Callable<IOException>(){

            @Override
            public IOException call() throws Exception {
                return LambdaTestUtils.intercept(IOException.class, new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        return null;
                    }
                });
            }
        });
    }

    @Test
    public void testEventually() throws Throwable {
        long result = LambdaTestUtils.eventually(50, EVAL_3L, (Callable<Integer>)this.retry);
        TestLambdaTestUtils.assertEquals((long)3L, (long)result);
        TestLambdaTestUtils.assertEquals((long)0L, (long)this.retry.getInvocationCount());
    }

    @Test
    public void testEventuallyFailuresRetry() throws Throwable {
        try {
            LambdaTestUtils.eventually(50, EVAL_FNFE, (Callable<Integer>)this.retry);
            TestLambdaTestUtils.fail((String)"should not have got here");
        }
        catch (IOException expected) {
            this.assertMinRetryCount(1);
        }
    }
}

