/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import java.util.Properties;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;

public class TestConfigurationSubclass
extends TestCase {
    private static final String EMPTY_CONFIGURATION_XML = "/org/apache/hadoop/conf/empty-configuration.xml";

    public void testGetProps() {
        SubConf conf = new SubConf(true);
        Properties properties = conf.getProperties();
        TestConfigurationSubclass.assertNotNull((String)"hadoop.tmp.dir is not set", (Object)properties.getProperty("hadoop.tmp.dir"));
    }

    public void testReload() throws Throwable {
        SubConf conf = new SubConf(true);
        TestConfigurationSubclass.assertFalse((boolean)conf.isReloaded());
        Configuration.addDefaultResource((String)EMPTY_CONFIGURATION_XML);
        TestConfigurationSubclass.assertTrue((boolean)conf.isReloaded());
        Properties properties = conf.getProperties();
    }

    public void testReloadNotQuiet() throws Throwable {
        SubConf conf = new SubConf(true);
        conf.setQuietMode(false);
        TestConfigurationSubclass.assertFalse((boolean)conf.isReloaded());
        conf.addResource("not-a-valid-resource");
        TestConfigurationSubclass.assertFalse((boolean)conf.isReloaded());
        try {
            Properties properties = conf.getProperties();
            TestConfigurationSubclass.fail((String)"Should not have got here");
        }
        catch (RuntimeException e) {
            TestConfigurationSubclass.assertTrue((String)e.toString(), (boolean)e.getMessage().contains("not found"));
        }
    }

    private static class SubConf
    extends Configuration {
        private boolean reloaded;

        private SubConf(boolean loadDefaults) {
            super(loadDefaults);
        }

        public Properties getProperties() {
            return super.getProps();
        }

        public void reloadConfiguration() {
            super.reloadConfiguration();
            this.reloaded = true;
        }

        public boolean isReloaded() {
            return this.reloaded;
        }

        public void setReloaded(boolean reloaded) {
            this.reloaded = reloaded;
        }
    }
}

