/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.local;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.JobCounter;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobCounterUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptContainerAssignedEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocator;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocatorEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.RMCommunicator;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.ApplicationAttemptNotFoundException;
import org.apache.hadoop.yarn.exceptions.ApplicationMasterNotRegisteredException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;

public class LocalContainerAllocator
extends RMCommunicator
implements ContainerAllocator {
    private static final Log LOG = LogFactory.getLog(LocalContainerAllocator.class);
    private final EventHandler eventHandler;
    private long retryInterval;
    private long retrystartTime;
    private String nmHost;
    private int nmPort;
    private int nmHttpPort;
    private ContainerId containerId;
    protected int lastResponseID;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    public LocalContainerAllocator(ClientService clientService, AppContext context, String nmHost, int nmPort, int nmHttpPort, ContainerId cId) {
        super(clientService, context);
        this.eventHandler = context.getEventHandler();
        this.nmHost = nmHost;
        this.nmPort = nmPort;
        this.nmHttpPort = nmHttpPort;
        this.containerId = cId;
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        this.retryInterval = this.getConfig().getLong("yarn.app.mapreduce.am.scheduler.connection.wait.interval-ms", 360000L);
        this.retrystartTime = System.currentTimeMillis();
    }

    @Override
    protected synchronized void heartbeat() throws Exception {
        AllocateRequest allocateRequest = AllocateRequest.newInstance((int)this.lastResponseID, (float)super.getApplicationProgress(), new ArrayList(), new ArrayList(), null);
        AllocateResponse allocateResponse = null;
        try {
            allocateResponse = this.scheduler.allocate(allocateRequest);
            this.retrystartTime = System.currentTimeMillis();
        }
        catch (ApplicationAttemptNotFoundException e) {
            LOG.info((Object)"Event from RM: shutting down Application Master");
            this.eventHandler.handle((Event)new JobEvent(this.getJob().getID(), JobEventType.JOB_AM_REBOOT));
            throw new YarnRuntimeException("Resource Manager doesn't recognize AttemptId: " + this.getContext().getApplicationID(), (Throwable)e);
        }
        catch (ApplicationMasterNotRegisteredException e) {
            LOG.info((Object)"ApplicationMaster is out of sync with ResourceManager, hence resync and send outstanding requests.");
            this.lastResponseID = 0;
            this.register();
        }
        catch (Exception e) {
            if (System.currentTimeMillis() - this.retrystartTime >= this.retryInterval) {
                LOG.error((Object)("Could not contact RM after " + this.retryInterval + " milliseconds."));
                this.eventHandler.handle((Event)new JobEvent(this.getJob().getID(), JobEventType.INTERNAL_ERROR));
                throw new YarnRuntimeException("Could not contact RM after " + this.retryInterval + " milliseconds.");
            }
            throw e;
        }
        if (allocateResponse != null) {
            this.lastResponseID = allocateResponse.getResponseId();
            org.apache.hadoop.yarn.api.records.Token token = allocateResponse.getAMRMToken();
            if (token != null) {
                this.updateAMRMToken(token);
            }
            Priority priorityFromResponse = Priority.newInstance((int)allocateResponse.getApplicationPriority().getPriority());
            this.getJob().setJobPriority(priorityFromResponse);
        }
    }

    private void updateAMRMToken(org.apache.hadoop.yarn.api.records.Token token) throws IOException {
        Token amrmToken = new Token(token.getIdentifier().array(), token.getPassword().array(), new Text(token.getKind()), new Text(token.getService()));
        UserGroupInformation currentUGI = UserGroupInformation.getCurrentUser();
        currentUGI.addToken(amrmToken);
        amrmToken.setService(ClientRMProxy.getAMRMTokenService((Configuration)this.getConfig()));
    }

    public void handle(ContainerAllocatorEvent event) {
        if (event.getType() == ContainerAllocator.EventType.CONTAINER_REQ) {
            LOG.info((Object)("Processing the event " + event.toString()));
            ContainerId cID = ContainerId.newContainerId((ApplicationAttemptId)this.getContext().getApplicationAttemptId(), (long)this.containerId.getContainerId());
            Container container = (Container)this.recordFactory.newRecordInstance(Container.class);
            container.setId(cID);
            NodeId nodeId = NodeId.newInstance((String)this.nmHost, (int)this.nmPort);
            container.setResource(Resource.newInstance((int)0, (int)0));
            container.setNodeId(nodeId);
            container.setContainerToken(null);
            container.setNodeHttpAddress(this.nmHost + ":" + this.nmHttpPort);
            if (event.getAttemptID().getTaskId().getTaskType() == TaskType.MAP) {
                JobCounterUpdateEvent jce = new JobCounterUpdateEvent(event.getAttemptID().getTaskId().getJobId());
                jce.addCounterUpdate((Enum<?>)JobCounter.OTHER_LOCAL_MAPS, 1L);
                this.eventHandler.handle((Event)jce);
            }
            this.eventHandler.handle((Event)new TaskAttemptContainerAssignedEvent(event.getAttemptID(), container, this.applicationACLs));
        }
    }
}

