/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import jnr.ffi.Runtime;
import jnr.ffi.provider.AbstractMemoryIO;
import jnr.ffi.util.BufferUtil;

public abstract class AbstractBufferMemoryIO
extends AbstractMemoryIO {
    protected final ByteBuffer buffer;

    public AbstractBufferMemoryIO(Runtime runtime, ByteBuffer buffer, long address2) {
        super(runtime, address2, buffer.isDirect());
        this.buffer = buffer;
    }

    @Override
    public long size() {
        return this.buffer.remaining();
    }

    public final ByteBuffer getByteBuffer() {
        return this.buffer;
    }

    @Override
    public int arrayLength() {
        return this.getByteBuffer().remaining();
    }

    @Override
    public int arrayOffset() {
        return this.getByteBuffer().arrayOffset();
    }

    @Override
    public Object array() {
        return this.getByteBuffer().array();
    }

    @Override
    public boolean hasArray() {
        return this.getByteBuffer().hasArray();
    }

    @Override
    public byte getByte(long offset2) {
        return this.buffer.get((int)offset2);
    }

    @Override
    public short getShort(long offset2) {
        return this.buffer.getShort((int)offset2);
    }

    @Override
    public int getInt(long offset2) {
        return this.buffer.getInt((int)offset2);
    }

    @Override
    public long getLongLong(long offset2) {
        return this.buffer.getLong((int)offset2);
    }

    @Override
    public float getFloat(long offset2) {
        return this.buffer.getFloat((int)offset2);
    }

    @Override
    public double getDouble(long offset2) {
        return this.buffer.getDouble((int)offset2);
    }

    @Override
    public void putByte(long offset2, byte value2) {
        this.buffer.put((int)offset2, value2);
    }

    @Override
    public void putShort(long offset2, short value2) {
        this.buffer.putShort((int)offset2, value2);
    }

    @Override
    public void putInt(long offset2, int value2) {
        this.buffer.putInt((int)offset2, value2);
    }

    @Override
    public void putLongLong(long offset2, long value2) {
        this.buffer.putLong((int)offset2, value2);
    }

    @Override
    public void putFloat(long offset2, float value2) {
        this.buffer.putFloat((int)offset2, value2);
    }

    @Override
    public void putDouble(long offset2, double value2) {
        this.buffer.putDouble((int)offset2, value2);
    }

    public String getString(long offset2, int size2) {
        return BufferUtil.getString(BufferUtil.slice(this.buffer, (int)offset2), Charset.defaultCharset());
    }

    public void putString(long offset2, String string2) {
        BufferUtil.putString(BufferUtil.slice(this.buffer, (int)offset2), Charset.defaultCharset(), string2);
    }

    @Override
    public void get(long offset2, byte[] dst, int off, int len) {
        BufferUtil.slice(this.buffer, (int)offset2, len).get(dst, off, len);
    }

    @Override
    public void get(long offset2, short[] dst, int off, int len) {
        BufferUtil.slice(this.buffer, (int)offset2, len * 16 / 8).asShortBuffer().get(dst, off, len);
    }

    @Override
    public void get(long offset2, int[] dst, int off, int len) {
        BufferUtil.slice(this.buffer, (int)offset2, len * 32 / 8).asIntBuffer().get(dst, off, len);
    }

    @Override
    public void get(long offset2, long[] dst, int off, int len) {
        BufferUtil.slice(this.buffer, (int)offset2, len * 64 / 8).asLongBuffer().get(dst, off, len);
    }

    @Override
    public void get(long offset2, float[] dst, int off, int len) {
        BufferUtil.slice(this.buffer, (int)offset2, len * 32 / 8).asFloatBuffer().get(dst, off, len);
    }

    @Override
    public void get(long offset2, double[] dst, int off, int len) {
        BufferUtil.slice(this.buffer, (int)offset2, len * 64 / 8).asDoubleBuffer().get(dst, off, len);
    }

    @Override
    public void put(long offset2, byte[] dst, int off, int len) {
        BufferUtil.slice(this.buffer, (int)offset2, len).put(dst, off, len);
    }

    @Override
    public void put(long offset2, short[] dst, int off, int len) {
        BufferUtil.slice(this.buffer, (int)offset2, len * 16 / 8).asShortBuffer().put(dst, off, len);
    }

    @Override
    public void put(long offset2, int[] src, int off, int len) {
        BufferUtil.slice(this.buffer, (int)offset2, len * 32 / 8).asIntBuffer().put(src, off, len);
    }

    @Override
    public void put(long offset2, long[] src, int off, int len) {
        BufferUtil.slice(this.buffer, (int)offset2, len * 64 / 8).asLongBuffer().put(src, off, len);
    }

    @Override
    public void put(long offset2, float[] src, int off, int len) {
        BufferUtil.slice(this.buffer, (int)offset2, len * 32 / 8).asFloatBuffer().put(src, off, len);
    }

    @Override
    public void put(long offset2, double[] src, int off, int len) {
        BufferUtil.slice(this.buffer, (int)offset2, len * 64 / 8).asDoubleBuffer().put(src, off, len);
    }

    @Override
    public String getString(long offset2) {
        return BufferUtil.getString(BufferUtil.slice(this.buffer, (int)offset2), Charset.defaultCharset());
    }

    @Override
    public String getString(long offset2, int maxLength, Charset cs) {
        return BufferUtil.getString(BufferUtil.slice(this.buffer, (int)offset2, maxLength), cs);
    }

    @Override
    public void putString(long offset2, String string2, int maxLength, Charset cs) {
        BufferUtil.putString(BufferUtil.slice(this.buffer, (int)offset2, maxLength), cs, string2);
    }

    @Override
    public int indexOf(long offset2, byte value2, int maxlen) {
        while (offset2 > -1L) {
            if (this.buffer.get((int)offset2) == value2) {
                return (int)offset2;
            }
            ++offset2;
        }
        return -1;
    }

    @Override
    public void setMemory(long offset2, long size2, byte value2) {
        int i2 = 0;
        while ((long)i2 < size2) {
            this.buffer.put((int)offset2 + i2, value2);
            ++i2;
        }
    }
}

