/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.runtime;

import org.apache.hadoop.mapreduce.Counter;
import org.apache.pig.backend.hadoop.executionengine.TaskContext;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.mapreduce.hadoop.mapred.MRCounters;
import org.apache.tez.runtime.api.ProcessorContext;

public class TezTaskContext
extends TaskContext<ProcessorContext> {
    private ProcessorContext context;

    public TezTaskContext(ProcessorContext context) {
        this.context = context;
    }

    @Override
    public ProcessorContext get() {
        return this.context;
    }

    @Override
    public Counter getCounter(Enum<?> name) {
        if (this.context == null) {
            return null;
        }
        TezCounter tezCounter = this.context.getCounters().findCounter(name);
        return new MRCounters.MRCounter(tezCounter);
    }

    @Override
    public Counter getCounter(String group, String name) {
        if (this.context == null) {
            return null;
        }
        TezCounter tezCounter = ((CounterGroup)this.context.getCounters().getGroup(group)).findCounter(name);
        return new MRCounters.MRCounter(tezCounter);
    }

    @Override
    public boolean incrCounter(Enum<?> name, long delta) {
        if (this.context == null) {
            return false;
        }
        TezCounter counter = this.context.getCounters().findCounter(name);
        counter.increment(delta);
        return true;
    }

    @Override
    public boolean incrCounter(String group, String name, long delta) {
        if (this.context == null) {
            return false;
        }
        TezCounter counter = ((CounterGroup)this.context.getCounters().getGroup(group)).findCounter(name);
        counter.increment(delta);
        return true;
    }

    @Override
    public void progress() {
        if (this.context == null) {
            return;
        }
        this.context.notifyProgress();
    }
}

