/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jline.ConsoleReader;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.iterators.AggregatingIterator;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.aggregation.Aggregator;
import org.apache.accumulo.core.iterators.user.AgeOffFilter;
import org.apache.accumulo.core.iterators.user.RegExFilter;
import org.apache.accumulo.core.iterators.user.ReqVisFilter;
import org.apache.accumulo.core.iterators.user.VersioningIterator;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.accumulo.core.util.shell.ShellCommandException;
import org.apache.accumulo.core.util.shell.commands.OptUtil;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.apache.accumulo.start.classloader.vfs.ContextManager;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.vfs2.FileSystemException;

public class SetIterCommand
extends Shell.Command {
    private Option mincScopeOpt;
    private Option majcScopeOpt;
    private Option scanScopeOpt;
    private Option nameOpt;
    private Option priorityOpt;
    private Option aggTypeOpt;
    private Option ageoffTypeOpt;
    private Option regexTypeOpt;
    private Option versionTypeOpt;
    private Option reqvisTypeOpt;
    private Option classnameTypeOpt;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, IOException, ShellCommandException {
        int priority = Integer.parseInt(cl.getOptionValue(this.priorityOpt.getOpt()));
        HashMap<String, String> options = new HashMap<String, String>();
        String classname = cl.getOptionValue(this.classnameTypeOpt.getOpt());
        if (cl.hasOption(this.aggTypeOpt.getOpt())) {
            String deprecatedClassName;
            Shell.log.warn((Object)"aggregators are deprecated");
            classname = deprecatedClassName = AggregatingIterator.class.getName();
        } else if (cl.hasOption(this.regexTypeOpt.getOpt())) {
            classname = RegExFilter.class.getName();
        } else if (cl.hasOption(this.ageoffTypeOpt.getOpt())) {
            classname = AgeOffFilter.class.getName();
        } else if (cl.hasOption(this.versionTypeOpt.getOpt())) {
            classname = VersioningIterator.class.getName();
        } else if (cl.hasOption(this.reqvisTypeOpt.getOpt())) {
            classname = ReqVisFilter.class.getName();
        }
        ClassLoader classloader = this.getClassLoader(cl, shellState);
        String name = cl.getOptionValue(this.nameOpt.getOpt(), SetIterCommand.setUpOptions(classloader, shellState.getReader(), classname, options));
        this.setTableProperties(cl, shellState, priority, options, classname, name);
        return 0;
    }

    private ClassLoader getClassLoader(CommandLine cl, final Shell shellState) throws AccumuloException, TableNotFoundException, AccumuloSecurityException, IOException, FileSystemException {
        ClassLoader classloader;
        String classpath = null;
        Iterable<Map.Entry<String, String>> tableProps = shellState.getConnector().tableOperations().getProperties(OptUtil.getTableOpt(cl, shellState));
        for (Map.Entry<String, String> entry : tableProps) {
            if (!entry.getKey().equals(Property.TABLE_CLASSPATH.getKey())) continue;
            classpath = entry.getValue();
        }
        if (classpath != null && !classpath.equals("")) {
            shellState.getConnector().instanceOperations().getSystemConfiguration().get(Property.VFS_CONTEXT_CLASSPATH_PROPERTY.getKey() + classpath);
            try {
                AccumuloVFSClassLoader.getContextManager().setContextConfig((ContextManager.ContextsConfig)new ContextManager.DefaultContextsConfig((Iterable)new Iterable<Map.Entry<String, String>>(){

                    @Override
                    public Iterator<Map.Entry<String, String>> iterator() {
                        try {
                            return shellState.getConnector().instanceOperations().getSystemConfiguration().entrySet().iterator();
                        }
                        catch (AccumuloException e) {
                            throw new RuntimeException(e);
                        }
                        catch (AccumuloSecurityException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }));
            }
            catch (IllegalStateException ise) {
                // empty catch block
            }
            classloader = AccumuloVFSClassLoader.getContextManager().getClassLoader(classpath);
        } else {
            classloader = AccumuloVFSClassLoader.getClassLoader();
        }
        return classloader;
    }

    protected void setTableProperties(CommandLine cl, Shell shellState, int priority, Map<String, String> options, String classname, String name) throws AccumuloException, AccumuloSecurityException, ShellCommandException, TableNotFoundException {
        String tableName = OptUtil.getTableOpt(cl, shellState);
        if (!shellState.getConnector().tableOperations().testClassLoad(tableName, classname, SortedKeyValueIterator.class.getName())) {
            throw new ShellCommandException(ShellCommandException.ErrorCode.INITIALIZATION_FAILURE, "Servers are unable to load " + classname + " as type " + SortedKeyValueIterator.class.getName());
        }
        String aggregatorClass = options.get("aggregatorClass");
        String deprecatedAggregatorClassName = Aggregator.class.getName();
        if (aggregatorClass != null && !shellState.getConnector().tableOperations().testClassLoad(tableName, aggregatorClass, deprecatedAggregatorClassName)) {
            throw new ShellCommandException(ShellCommandException.ErrorCode.INITIALIZATION_FAILURE, "Servers are unable to load " + aggregatorClass + " as type " + deprecatedAggregatorClassName);
        }
        Iterator<Map.Entry<String, String>> i = options.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, String> entry = i.next();
            if (entry.getValue() != null && !entry.getValue().isEmpty()) continue;
            i.remove();
        }
        EnumSet<IteratorUtil.IteratorScope> scopes = EnumSet.noneOf(IteratorUtil.IteratorScope.class);
        if (cl.hasOption(this.mincScopeOpt.getOpt())) {
            scopes.add(IteratorUtil.IteratorScope.minc);
        }
        if (cl.hasOption(this.majcScopeOpt.getOpt())) {
            scopes.add(IteratorUtil.IteratorScope.majc);
        }
        if (cl.hasOption(this.scanScopeOpt.getOpt())) {
            scopes.add(IteratorUtil.IteratorScope.scan);
        }
        if (scopes.isEmpty()) {
            throw new IllegalArgumentException("You must select at least one scope to configure");
        }
        IteratorSetting setting = new IteratorSetting(priority, name, classname, options);
        shellState.getConnector().tableOperations().attachIterator(tableName, setting, scopes);
    }

    private static String setUpOptions(ClassLoader classloader, ConsoleReader reader, String className, Map<String, String> options) throws IOException, ShellCommandException {
        OptionDescriber skvi;
        Class<OptionDescriber> clazz;
        try {
            clazz = classloader.loadClass(className).asSubclass(OptionDescriber.class);
            skvi = clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            StringBuilder msg = new StringBuilder("Unable to load ").append(className);
            if (className.indexOf(46) < 0) {
                msg.append("; did you use a fully qualified package name?");
            } else {
                msg.append("; class not found.");
            }
            throw new ShellCommandException(ShellCommandException.ErrorCode.INITIALIZATION_FAILURE, msg.toString());
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (ClassCastException e) {
            StringBuilder msg = new StringBuilder("Loaded ");
            msg.append(className).append(" but it does not implement ");
            msg.append(OptionDescriber.class.getSimpleName());
            msg.append("; use 'config -s' instead.");
            throw new ShellCommandException(ShellCommandException.ErrorCode.INITIALIZATION_FAILURE, msg.toString());
        }
        OptionDescriber.IteratorOptions itopts = skvi.describeOptions();
        if (itopts.getName() == null) {
            throw new IllegalArgumentException(className + " described its default distinguishing name as null");
        }
        String shortClassName = className;
        if (className.contains(".")) {
            shortClassName = className.substring(className.lastIndexOf(46) + 1);
        }
        HashMap localOptions = new HashMap();
        do {
            String input;
            String prompt;
            for (String key : localOptions.keySet()) {
                options.remove(key);
            }
            localOptions.clear();
            reader.printString(itopts.getDescription());
            reader.printNewline();
            if (itopts.getNamedOptions() != null) {
                for (Map.Entry entry : itopts.getNamedOptions().entrySet()) {
                    prompt = Shell.repeat("-", 10) + "> set " + shortClassName + " parameter " + (String)entry.getKey() + ", " + (String)entry.getValue() + ": ";
                    reader.flushConsole();
                    input = reader.readLine(prompt);
                    if (input == null) {
                        reader.printNewline();
                        throw new IOException("Input stream closed");
                    }
                    input = new String(input);
                    localOptions.put(entry.getKey(), input);
                }
            }
            if (itopts.getUnnamedOptionDescriptions() != null) {
                block8: for (String string : itopts.getUnnamedOptionDescriptions()) {
                    reader.printString(Shell.repeat("-", 10) + "> entering options: " + string + "\n");
                    input = "start";
                    while (true) {
                        prompt = Shell.repeat("-", 10) + "> set " + shortClassName + " option (<name> <value>, hit enter to skip): ";
                        reader.flushConsole();
                        input = reader.readLine(prompt);
                        if (input == null) {
                            reader.printNewline();
                            throw new IOException("Input stream closed");
                        }
                        if ((input = new String(input)).length() == 0) continue block8;
                        String[] sa = input.split(" ", 2);
                        localOptions.put(sa[0], sa[1]);
                    }
                }
            }
            options.putAll(localOptions);
            if (skvi.validateOptions(options)) continue;
            reader.printString("invalid options for " + clazz.getName() + "\n");
        } while (!skvi.validateOptions(options));
        return itopts.getName();
    }

    @Override
    public String description() {
        return "sets a table-specific iterator";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.priorityOpt = new Option("p", "priority", true, "the order in which the iterator is applied");
        this.priorityOpt.setArgName("pri");
        this.priorityOpt.setRequired(true);
        this.nameOpt = new Option("n", "name", true, "iterator to set");
        this.nameOpt.setArgName("itername");
        this.mincScopeOpt = new Option(IteratorUtil.IteratorScope.minc.name(), "minor-compaction", false, "applied at minor compaction");
        this.majcScopeOpt = new Option(IteratorUtil.IteratorScope.majc.name(), "major-compaction", false, "applied at major compaction");
        this.scanScopeOpt = new Option(IteratorUtil.IteratorScope.scan.name(), "scan-time", false, "applied at scan time");
        OptionGroup typeGroup = new OptionGroup();
        this.classnameTypeOpt = new Option("class", "class-name", true, "a java class that implements SortedKeyValueIterator");
        this.classnameTypeOpt.setArgName("name");
        this.aggTypeOpt = new Option("agg", "aggregator", false, "an aggregating type");
        this.regexTypeOpt = new Option("regex", "regular-expression", false, "a regex matching iterator");
        this.versionTypeOpt = new Option("vers", "version", false, "a versioning iterator");
        this.reqvisTypeOpt = new Option("reqvis", "require-visibility", false, "an iterator that omits entries with empty visibilities");
        this.ageoffTypeOpt = new Option("ageoff", "ageoff", false, "an aging off iterator");
        typeGroup.addOption(this.classnameTypeOpt);
        typeGroup.addOption(this.aggTypeOpt);
        typeGroup.addOption(this.regexTypeOpt);
        typeGroup.addOption(this.versionTypeOpt);
        typeGroup.addOption(this.reqvisTypeOpt);
        typeGroup.addOption(this.ageoffTypeOpt);
        typeGroup.setRequired(true);
        o.addOption(OptUtil.tableOpt("table to configure iterators on"));
        o.addOption(this.priorityOpt);
        o.addOption(this.nameOpt);
        o.addOption(this.mincScopeOpt);
        o.addOption(this.majcScopeOpt);
        o.addOption(this.scanScopeOpt);
        o.addOptionGroup(typeGroup);
        return o;
    }

    @Override
    public int numArgs() {
        return 0;
    }
}

