/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mock;

import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.BatchDeleter;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.client.admin.SecurityOperations;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.client.mock.MockAccumulo;
import org.apache.accumulo.core.client.mock.MockBatchDeleter;
import org.apache.accumulo.core.client.mock.MockBatchWriter;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.client.mock.MockInstanceOperations;
import org.apache.accumulo.core.client.mock.MockMultiTableBatchWriter;
import org.apache.accumulo.core.client.mock.MockScanner;
import org.apache.accumulo.core.client.mock.MockSecurityOperations;
import org.apache.accumulo.core.client.mock.MockTable;
import org.apache.accumulo.core.client.mock.MockTableOperations;
import org.apache.accumulo.core.security.Authorizations;

public class MockConnector
extends Connector {
    String username;
    private final MockAccumulo acu;
    private final Instance instance;

    MockConnector(String username, MockInstance instance) {
        this(username, new MockAccumulo(MockInstance.getDefaultFileSystem()), instance);
    }

    MockConnector(String username, MockAccumulo acu, MockInstance instance) {
        this.username = username;
        this.acu = acu;
        this.instance = instance;
    }

    @Override
    public BatchScanner createBatchScanner(String tableName, Authorizations authorizations, int numQueryThreads) throws TableNotFoundException {
        if (this.acu.tables.get(tableName) == null) {
            throw new TableNotFoundException(tableName, tableName, "no such table");
        }
        return this.acu.createBatchScanner(tableName, authorizations);
    }

    @Override
    @Deprecated
    public BatchDeleter createBatchDeleter(String tableName, Authorizations authorizations, int numQueryThreads, long maxMemory, long maxLatency, int maxWriteThreads) throws TableNotFoundException {
        if (this.acu.tables.get(tableName) == null) {
            throw new TableNotFoundException(tableName, tableName, "no such table");
        }
        return new MockBatchDeleter(this.acu, tableName, authorizations);
    }

    @Override
    public BatchDeleter createBatchDeleter(String tableName, Authorizations authorizations, int numQueryThreads, BatchWriterConfig config) throws TableNotFoundException {
        return this.createBatchDeleter(tableName, authorizations, numQueryThreads, config.getMaxMemory(), config.getMaxLatency(TimeUnit.MILLISECONDS), config.getMaxWriteThreads());
    }

    @Override
    @Deprecated
    public BatchWriter createBatchWriter(String tableName, long maxMemory, long maxLatency, int maxWriteThreads) throws TableNotFoundException {
        if (this.acu.tables.get(tableName) == null) {
            throw new TableNotFoundException(tableName, tableName, "no such table");
        }
        return new MockBatchWriter(this.acu, tableName);
    }

    @Override
    public BatchWriter createBatchWriter(String tableName, BatchWriterConfig config) throws TableNotFoundException {
        return this.createBatchWriter(tableName, config.getMaxMemory(), config.getMaxLatency(TimeUnit.MILLISECONDS), config.getMaxWriteThreads());
    }

    @Override
    @Deprecated
    public MultiTableBatchWriter createMultiTableBatchWriter(long maxMemory, long maxLatency, int maxWriteThreads) {
        return new MockMultiTableBatchWriter(this.acu);
    }

    @Override
    public MultiTableBatchWriter createMultiTableBatchWriter(BatchWriterConfig config) {
        return this.createMultiTableBatchWriter(config.getMaxMemory(), config.getMaxLatency(TimeUnit.MILLISECONDS), config.getMaxWriteThreads());
    }

    @Override
    public Scanner createScanner(String tableName, Authorizations authorizations) throws TableNotFoundException {
        MockTable table = this.acu.tables.get(tableName);
        if (table == null) {
            throw new TableNotFoundException(tableName, tableName, "no such table");
        }
        return new MockScanner(table, authorizations);
    }

    @Override
    public Instance getInstance() {
        return this.instance;
    }

    @Override
    public String whoami() {
        return this.username;
    }

    @Override
    public TableOperations tableOperations() {
        return new MockTableOperations(this.acu, this.username);
    }

    @Override
    public SecurityOperations securityOperations() {
        return new MockSecurityOperations(this.acu);
    }

    @Override
    public InstanceOperations instanceOperations() {
        return new MockInstanceOperations(this.acu);
    }
}

