/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.RowIterator;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.ScannerOptions;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.KeyValue;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.file.FileUtil;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.system.ColumnFamilySkippingIterator;
import org.apache.accumulo.core.iterators.system.ColumnQualifierFilter;
import org.apache.accumulo.core.iterators.system.DeletingIterator;
import org.apache.accumulo.core.iterators.system.MultiIterator;
import org.apache.accumulo.core.iterators.system.VisibilityFilter;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.security.CredentialHelper;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.LocalityGroupUtil;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;

class OfflineIterator
implements Iterator<Map.Entry<Key, Value>> {
    private SortedKeyValueIterator<Key, Value> iter;
    private Range range;
    private KeyExtent currentExtent;
    private Connector conn;
    private String tableId;
    private Authorizations authorizations;
    private Instance instance;
    private ScannerOptions options;
    private ArrayList<SortedKeyValueIterator<Key, Value>> readers;

    public OfflineIterator(ScannerOptions options, Instance instance, TCredentials credentials, Authorizations authorizations, Text table, Range range) {
        this.options = new ScannerOptions(options);
        this.instance = instance;
        this.range = range;
        if (this.options.fetchedColumns.size() > 0) {
            this.range = range.bound(this.options.fetchedColumns.first(), this.options.fetchedColumns.last());
        }
        this.tableId = table.toString();
        this.authorizations = authorizations;
        this.readers = new ArrayList();
        try {
            this.conn = instance.getConnector(credentials.getPrincipal(), CredentialHelper.extractToken(credentials));
            this.nextTablet();
            while (this.iter != null && !this.iter.hasTop()) {
                this.nextTablet();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.iter != null && this.iter.hasTop();
    }

    @Override
    public Map.Entry<Key, Value> next() {
        try {
            byte[] v = this.iter.getTopValue().get();
            KeyValue ret = new KeyValue(new Key(this.iter.getTopKey()), Arrays.copyOf(v, v.length));
            this.iter.next();
            while (this.iter != null && !this.iter.hasTop()) {
                this.nextTablet();
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void nextTablet() throws TableNotFoundException, AccumuloException, IOException {
        Range nextRange = null;
        if (this.currentExtent == null) {
            Text startRow = this.range.getStartKey() != null ? this.range.getStartKey().getRow() : new Text();
            nextRange = new Range(new KeyExtent(new Text(this.tableId), startRow, null).getMetadataEntry(), true, null, false);
        } else {
            if (this.currentExtent.getEndRow() == null) {
                this.iter = null;
                return;
            }
            if (this.range.afterEndKey(new Key(this.currentExtent.getEndRow()).followingKey(PartialKey.ROW))) {
                this.iter = null;
                return;
            }
            nextRange = new Range(this.currentExtent.getMetadataEntry(), false, null, false);
        }
        ArrayList<String> relFiles = new ArrayList<String>();
        Pair<KeyExtent, String> eloc = this.getTabletFiles(nextRange, relFiles);
        while (eloc.getSecond() != null) {
            if (Tables.getTableState(this.instance, this.tableId) != TableState.OFFLINE) {
                Tables.clearCache(this.instance);
                if (Tables.getTableState(this.instance, this.tableId) != TableState.OFFLINE) {
                    throw new AccumuloException("Table is online " + this.tableId + " cannot scan tablet in offline mode " + eloc.getFirst());
                }
            }
            UtilWaitThread.sleep(250L);
            eloc = this.getTabletFiles(nextRange, relFiles);
        }
        KeyExtent extent = eloc.getFirst();
        if (!extent.getTableId().toString().equals(this.tableId)) {
            throw new AccumuloException(" did not find tablets for table " + this.tableId + " " + extent);
        }
        if (this.currentExtent != null && !extent.isPreviousExtent(this.currentExtent)) {
            throw new AccumuloException(" " + this.currentExtent + " is not previous extent " + extent);
        }
        String tablesDir = Constants.getTablesDir(this.instance.getConfiguration());
        ArrayList<String> absFiles = new ArrayList<String>();
        for (String relPath : relFiles) {
            if (relPath.startsWith("..")) {
                absFiles.add(tablesDir + relPath.substring(2));
                continue;
            }
            absFiles.add(tablesDir + "/" + this.tableId + relPath);
        }
        this.iter = this.createIterator(extent, absFiles);
        this.iter.seek(this.range, LocalityGroupUtil.families(this.options.fetchedColumns), this.options.fetchedColumns.size() != 0);
        this.currentExtent = extent;
    }

    private Pair<KeyExtent, String> getTabletFiles(Range nextRange, List<String> relFiles) throws TableNotFoundException {
        Scanner scanner = this.conn.createScanner("!METADATA", Constants.NO_AUTHS);
        scanner.setBatchSize(100);
        scanner.setRange(nextRange);
        RowIterator rowIter = new RowIterator(scanner);
        Object row = rowIter.next();
        KeyExtent extent = null;
        String location = null;
        while (row.hasNext()) {
            Map.Entry entry = (Map.Entry)row.next();
            Key key = (Key)entry.getKey();
            if (key.getColumnFamily().equals((Object)Constants.METADATA_DATAFILE_COLUMN_FAMILY)) {
                relFiles.add(key.getColumnQualifier().toString());
            }
            if (key.getColumnFamily().equals((Object)Constants.METADATA_CURRENT_LOCATION_COLUMN_FAMILY) || key.getColumnFamily().equals((Object)Constants.METADATA_FUTURE_LOCATION_COLUMN_FAMILY)) {
                location = ((Value)entry.getValue()).toString();
            }
            if (!Constants.METADATA_PREV_ROW_COLUMN.hasColumns(key)) continue;
            extent = new KeyExtent(key.getRow(), (Value)entry.getValue());
        }
        return new Pair<Object, Object>(extent, location);
    }

    private SortedKeyValueIterator<Key, Value> createIterator(KeyExtent extent, List<String> absFiles) throws TableNotFoundException, AccumuloException, IOException {
        AccumuloConfiguration acuTableConf = AccumuloConfiguration.getTableConfiguration(this.conn, this.tableId);
        Configuration conf = CachedConfiguration.getInstance();
        FileSystem fs = FileUtil.getFileSystem(conf, this.instance.getConfiguration());
        for (SortedKeyValueIterator<Key, Value> reader : this.readers) {
            ((FileSKVIterator)reader).close();
        }
        this.readers.clear();
        for (String file : absFiles) {
            FileSKVIterator reader = FileOperations.getInstance().openReader(file, false, fs, conf, acuTableConf, null, null);
            this.readers.add(reader);
        }
        MultiIterator multiIter = new MultiIterator(this.readers, extent);
        OfflineIteratorEnvironment iterEnv = new OfflineIteratorEnvironment();
        DeletingIterator delIter = new DeletingIterator(multiIter, false);
        ColumnFamilySkippingIterator cfsi = new ColumnFamilySkippingIterator(delIter);
        ColumnQualifierFilter colFilter = new ColumnQualifierFilter(cfsi, new HashSet<Column>(this.options.fetchedColumns));
        ColumnVisibility cv = new ColumnVisibility(acuTableConf.get(Property.TABLE_DEFAULT_SCANTIME_VISIBILITY));
        byte[] defaultSecurityLabel = cv.getExpression();
        VisibilityFilter visFilter = new VisibilityFilter(colFilter, this.authorizations, defaultSecurityLabel);
        return iterEnv.getTopLevelIterator(IteratorUtil.loadIterators(IteratorUtil.IteratorScope.scan, visFilter, extent, acuTableConf, this.options.serverSideIteratorList, this.options.serverSideIteratorOptions, iterEnv, false));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    static class OfflineIteratorEnvironment
    implements IteratorEnvironment {
        private ArrayList<SortedKeyValueIterator<Key, Value>> topLevelIterators = new ArrayList();

        OfflineIteratorEnvironment() {
        }

        @Override
        public SortedKeyValueIterator<Key, Value> reserveMapFileReader(String mapFileName) throws IOException {
            throw new NotImplementedException();
        }

        @Override
        public AccumuloConfiguration getConfig() {
            return AccumuloConfiguration.getDefaultConfiguration();
        }

        @Override
        public IteratorUtil.IteratorScope getIteratorScope() {
            return IteratorUtil.IteratorScope.scan;
        }

        @Override
        public boolean isFullMajorCompaction() {
            return false;
        }

        @Override
        public void registerSideChannel(SortedKeyValueIterator<Key, Value> iter) {
            this.topLevelIterators.add(iter);
        }

        SortedKeyValueIterator<Key, Value> getTopLevelIterator(SortedKeyValueIterator<Key, Value> iter) {
            if (this.topLevelIterators.isEmpty()) {
                return iter;
            }
            ArrayList<SortedKeyValueIterator<Key, Value>> allIters = new ArrayList<SortedKeyValueIterator<Key, Value>>(this.topLevelIterators);
            allIters.add(iter);
            return new MultiIterator(allIters, false);
        }
    }
}

