/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.udf;

import java.sql.Date;
import java.sql.Timestamp;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriterFactory;
import org.apache.hadoop.hive.ql.exec.vector.udf.VectorUDFArgDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableBooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableFloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.Text;

public class VectorUDFAdaptor
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int outputColumn;
    private String resultType;
    private VectorUDFArgDesc[] argDescs;
    private ExprNodeGenericFuncDesc expr;
    private transient GenericUDF genericUDF;
    private transient GenericUDF.DeferredObject[] deferredChildren;
    private transient ObjectInspector outputOI;
    private transient ObjectInspector[] childrenOIs;
    private transient VectorExpressionWriter[] writers;

    public VectorUDFAdaptor() {
    }

    public VectorUDFAdaptor(ExprNodeGenericFuncDesc expr, int outputColumn, String resultType, VectorUDFArgDesc[] argDescs) throws HiveException {
        this();
        this.expr = expr;
        this.outputColumn = outputColumn;
        this.resultType = resultType;
        this.argDescs = argDescs;
    }

    public void init() throws HiveException, UDFArgumentException {
        int i;
        this.genericUDF = this.expr.getGenericUDF();
        this.deferredChildren = new GenericUDF.DeferredObject[this.expr.getChildren().size()];
        this.childrenOIs = new ObjectInspector[this.expr.getChildren().size()];
        this.writers = VectorExpressionWriterFactory.getExpressionWriters(this.expr.getChildren());
        for (i = 0; i < this.childrenOIs.length; ++i) {
            this.childrenOIs[i] = this.writers[i].getObjectInspector();
        }
        this.outputOI = VectorExpressionWriterFactory.genVectorExpressionWritable(this.expr).getObjectInspector();
        this.genericUDF.initialize(this.childrenOIs);
        for (i = 0; i < this.argDescs.length; ++i) {
            if (!this.argDescs[i].isConstant()) continue;
            this.argDescs[i].prepareConstant();
        }
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.genericUDF == null) {
            try {
                this.init();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        int[] sel = batch.selected;
        int n = batch.size;
        ColumnVector outV = batch.cols[this.outputColumn];
        if (outV instanceof BytesColumnVector) {
            ((BytesColumnVector)outV).initBuffer();
        }
        if (n == 0) {
            return;
        }
        batch.cols[this.outputColumn].noNulls = true;
        if (this.allInputColsRepeating(batch)) {
            this.setResult(0, batch);
            batch.cols[this.outputColumn].isRepeating = true;
            return;
        }
        batch.cols[this.outputColumn].isRepeating = false;
        if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                this.setResult(i, batch);
            }
        } else {
            for (int i = 0; i != n; ++i) {
                this.setResult(i, batch);
            }
        }
    }

    private boolean allInputColsRepeating(VectorizedRowBatch batch) {
        int varArgCount = 0;
        for (int i = 0; i < this.argDescs.length; ++i) {
            if (this.argDescs[i].isVariable() && !batch.cols[this.argDescs[i].getColumnNum()].isRepeating) {
                return false;
            }
            ++varArgCount;
        }
        return varArgCount > 0;
    }

    private void setResult(int i, VectorizedRowBatch b) {
        Object result;
        for (int j = 0; j < this.argDescs.length; ++j) {
            this.deferredChildren[j] = this.argDescs[j].getDeferredJavaObject(i, b, j, this.writers);
        }
        try {
            result = this.genericUDF.evaluate(this.deferredChildren);
        }
        catch (HiveException e) {
            result = null;
        }
        if (result == null) {
            b.cols[this.outputColumn].noNulls = false;
            b.cols[this.outputColumn].isNull[i] = true;
        } else {
            b.cols[this.outputColumn].isNull[i] = false;
            this.setOutputCol(b.cols[this.outputColumn], i, result);
        }
    }

    private void setOutputCol(ColumnVector colVec, int i, Object value) {
        if (this.outputOI instanceof WritableStringObjectInspector) {
            BytesColumnVector bv = (BytesColumnVector)colVec;
            Text t = value instanceof String ? new Text((String)value) : ((WritableStringObjectInspector)this.outputOI).getPrimitiveWritableObject(value);
            bv.setVal(i, t.getBytes(), 0, t.getLength());
        } else if (this.outputOI instanceof WritableHiveCharObjectInspector) {
            WritableHiveCharObjectInspector writableHiveCharObjectOI = (WritableHiveCharObjectInspector)this.outputOI;
            int maxLength = ((CharTypeInfo)writableHiveCharObjectOI.getTypeInfo()).getLength();
            BytesColumnVector bv = (BytesColumnVector)colVec;
            HiveCharWritable hiveCharWritable = value instanceof HiveCharWritable ? (HiveCharWritable)value : writableHiveCharObjectOI.getPrimitiveWritableObject(value);
            Text t = hiveCharWritable.getTextValue();
            StringExpr.rightTrimAndTruncate(bv, i, t.getBytes(), 0, t.getLength(), maxLength);
        } else if (this.outputOI instanceof WritableHiveVarcharObjectInspector) {
            WritableHiveVarcharObjectInspector writableHiveVarcharObjectOI = (WritableHiveVarcharObjectInspector)this.outputOI;
            int maxLength = ((VarcharTypeInfo)writableHiveVarcharObjectOI.getTypeInfo()).getLength();
            BytesColumnVector bv = (BytesColumnVector)colVec;
            HiveVarcharWritable hiveVarcharWritable = value instanceof HiveVarcharWritable ? (HiveVarcharWritable)value : writableHiveVarcharObjectOI.getPrimitiveWritableObject(value);
            Text t = hiveVarcharWritable.getTextValue();
            StringExpr.truncate(bv, i, t.getBytes(), 0, t.getLength(), maxLength);
        } else if (this.outputOI instanceof WritableIntObjectInspector) {
            LongColumnVector lv = (LongColumnVector)colVec;
            lv.vector[i] = value instanceof Integer ? (long)((Integer)value).intValue() : (long)((WritableIntObjectInspector)this.outputOI).get(value);
        } else if (this.outputOI instanceof WritableLongObjectInspector) {
            LongColumnVector lv = (LongColumnVector)colVec;
            lv.vector[i] = value instanceof Long ? ((Long)value).longValue() : ((WritableLongObjectInspector)this.outputOI).get(value);
        } else if (this.outputOI instanceof WritableDoubleObjectInspector) {
            DoubleColumnVector dv = (DoubleColumnVector)colVec;
            dv.vector[i] = value instanceof Double ? ((Double)value).doubleValue() : ((WritableDoubleObjectInspector)this.outputOI).get(value);
        } else if (this.outputOI instanceof WritableFloatObjectInspector) {
            DoubleColumnVector dv = (DoubleColumnVector)colVec;
            dv.vector[i] = value instanceof Float ? (double)((Float)value).floatValue() : (double)((WritableFloatObjectInspector)this.outputOI).get(value);
        } else if (this.outputOI instanceof WritableShortObjectInspector) {
            LongColumnVector lv = (LongColumnVector)colVec;
            lv.vector[i] = value instanceof Short ? (long)((Short)value).shortValue() : (long)((WritableShortObjectInspector)this.outputOI).get(value);
        } else if (this.outputOI instanceof WritableByteObjectInspector) {
            LongColumnVector lv = (LongColumnVector)colVec;
            lv.vector[i] = value instanceof Byte ? (long)((Byte)value).byteValue() : (long)((WritableByteObjectInspector)this.outputOI).get(value);
        } else if (this.outputOI instanceof WritableTimestampObjectInspector) {
            long l;
            LongColumnVector lv = (LongColumnVector)colVec;
            Timestamp ts = value instanceof Timestamp ? (Timestamp)value : ((WritableTimestampObjectInspector)this.outputOI).getPrimitiveJavaObject(value);
            lv.vector[i] = l = ts.getTime() * 1000000L + (long)(ts.getNanos() % 1000000);
        } else if (this.outputOI instanceof WritableDateObjectInspector) {
            long l;
            LongColumnVector lv = (LongColumnVector)colVec;
            Date ts = value instanceof Date ? (Date)value : ((WritableDateObjectInspector)this.outputOI).getPrimitiveJavaObject(value);
            lv.vector[i] = l = (long)DateWritable.dateToDays((Date)ts);
        } else if (this.outputOI instanceof WritableBooleanObjectInspector) {
            LongColumnVector lv = (LongColumnVector)colVec;
            lv.vector[i] = value instanceof Boolean ? ((Boolean)value != false ? 1L : 0L) : (((WritableBooleanObjectInspector)this.outputOI).get(value) ? 1L : 0L);
        } else if (this.outputOI instanceof WritableHiveDecimalObjectInspector) {
            DecimalColumnVector dcv = (DecimalColumnVector)colVec;
            if (value instanceof HiveDecimal) {
                dcv.set(i, (HiveDecimal)value);
            } else {
                HiveDecimal hd = ((WritableHiveDecimalObjectInspector)this.outputOI).getPrimitiveJavaObject(value);
                dcv.set(i, hd);
            }
        } else {
            throw new RuntimeException("Unhandled object type " + this.outputOI.getTypeName());
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public String getOutputType() {
        return this.resultType;
    }

    public String getResultType() {
        return this.resultType;
    }

    public void setResultType(String resultType) {
        this.resultType = resultType;
    }

    public VectorUDFArgDesc[] getArgDescs() {
        return this.argDescs;
    }

    public void setArgDescs(VectorUDFArgDesc[] argDescs) {
        this.argDescs = argDescs;
    }

    public ExprNodeGenericFuncDesc getExpr() {
        return this.expr;
    }

    public void setExpr(ExprNodeGenericFuncDesc expr) {
        this.expr = expr;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().build();
    }
}

