/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.opencensus.trace;

import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.Context;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.opencensus.common.Scope;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.opencensus.trace.Span;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.opencensus.trace.Status;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.opencensus.trace.unsafe.ContextUtils;

final class CurrentSpanUtils {
    private CurrentSpanUtils() {
    }

    @Nullable
    static Span getCurrentSpan() {
        return ContextUtils.getValue(Context.current());
    }

    static Scope withSpan(Span span, boolean endSpan) {
        return new ScopeInSpan(span, endSpan);
    }

    static Runnable withSpan(Span span, boolean endSpan, Runnable runnable2) {
        return new RunnableInSpan(span, runnable2, endSpan);
    }

    static <C> Callable<C> withSpan(Span span, boolean endSpan, Callable<C> callable) {
        return new CallableInSpan(span, callable, endSpan);
    }

    private static void setErrorStatus(Span span, Throwable t2) {
        span.setStatus(Status.UNKNOWN.withDescription(t2.getMessage() == null ? t2.getClass().getSimpleName() : t2.getMessage()));
    }

    private static final class CallableInSpan<V>
    implements Callable<V> {
        private final Span span;
        private final Callable<V> callable;
        private final boolean endSpan;

        private CallableInSpan(Span span, Callable<V> callable, boolean endSpan) {
            this.span = span;
            this.callable = callable;
            this.endSpan = endSpan;
        }

        @Override
        public V call() throws Exception {
            Context origContext = ContextUtils.withValue(Context.current(), this.span).attach();
            try {
                V v = this.callable.call();
                return v;
            }
            catch (Exception e) {
                CurrentSpanUtils.setErrorStatus(this.span, e);
                throw e;
            }
            catch (Throwable t2) {
                CurrentSpanUtils.setErrorStatus(this.span, t2);
                if (t2 instanceof Error) {
                    throw (Error)t2;
                }
                throw new RuntimeException("unexpected", t2);
            }
            finally {
                Context.current().detach(origContext);
                if (this.endSpan) {
                    this.span.end();
                }
            }
        }
    }

    private static final class RunnableInSpan
    implements Runnable {
        private final Span span;
        private final Runnable runnable;
        private final boolean endSpan;

        private RunnableInSpan(Span span, Runnable runnable2, boolean endSpan) {
            this.span = span;
            this.runnable = runnable2;
            this.endSpan = endSpan;
        }

        @Override
        public void run() {
            Context origContext = ContextUtils.withValue(Context.current(), this.span).attach();
            try {
                this.runnable.run();
            }
            catch (Throwable t2) {
                CurrentSpanUtils.setErrorStatus(this.span, t2);
                if (t2 instanceof RuntimeException) {
                    throw (RuntimeException)t2;
                }
                if (t2 instanceof Error) {
                    throw (Error)t2;
                }
                throw new RuntimeException("unexpected", t2);
            }
            finally {
                Context.current().detach(origContext);
                if (this.endSpan) {
                    this.span.end();
                }
            }
        }
    }

    private static final class ScopeInSpan
    implements Scope {
        private final Context origContext;
        private final Span span;
        private final boolean endSpan;

        private ScopeInSpan(Span span, boolean endSpan) {
            this.span = span;
            this.endSpan = endSpan;
            this.origContext = ContextUtils.withValue(Context.current(), span).attach();
        }

        @Override
        public void close() {
            Context.current().detach(this.origContext);
            if (this.endSpan) {
                this.span.end();
            }
        }
    }
}

