/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.util;

import java.util.Map;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.Internal;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.LoadBalancer;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.LoadBalancerProvider;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.NameResolver;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.Status;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.internal.JsonUtil;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.internal.TimeProvider;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.util.GracefulSwitchLoadBalancer;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.util.OutlierDetectionLoadBalancer;

@Internal
public final class OutlierDetectionLoadBalancerProvider
extends LoadBalancerProvider {
    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new OutlierDetectionLoadBalancer(helper, TimeProvider.SYSTEM_TIME_PROVIDER);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public String getPolicyName() {
        return "outlier_detection_experimental";
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawConfig) {
        try {
            return this.parseLoadBalancingPolicyConfigInternal(rawConfig);
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError(Status.UNAVAILABLE.withCause(e).withDescription("Failed parsing configuration for " + this.getPolicyName()));
        }
    }

    private NameResolver.ConfigOrError parseLoadBalancingPolicyConfigInternal(Map<String, ?> rawConfig) {
        NameResolver.ConfigOrError childConfig;
        Map<String, ?> rawFailurePercentageEjection;
        Map<String, ?> rawSuccessRateEjection;
        Long intervalNanos = JsonUtil.getStringAsDuration(rawConfig, "interval");
        Long baseEjectionTimeNanos = JsonUtil.getStringAsDuration(rawConfig, "baseEjectionTime");
        Long maxEjectionTimeNanos = JsonUtil.getStringAsDuration(rawConfig, "maxEjectionTime");
        Integer maxEjectionPercentage = JsonUtil.getNumberAsInteger(rawConfig, "maxEjectionPercentage");
        OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.Builder configBuilder = new OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.Builder();
        if (intervalNanos != null) {
            configBuilder.setIntervalNanos(intervalNanos);
        }
        if (baseEjectionTimeNanos != null) {
            configBuilder.setBaseEjectionTimeNanos(baseEjectionTimeNanos);
        }
        if (maxEjectionTimeNanos != null) {
            configBuilder.setMaxEjectionTimeNanos(maxEjectionTimeNanos);
        }
        if (maxEjectionPercentage != null) {
            configBuilder.setMaxEjectionPercent(maxEjectionPercentage);
        }
        if ((rawSuccessRateEjection = JsonUtil.getObject(rawConfig, "successRateEjection")) != null) {
            OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.SuccessRateEjection.Builder successRateEjectionBuilder = new OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.SuccessRateEjection.Builder();
            Integer stdevFactor = JsonUtil.getNumberAsInteger(rawSuccessRateEjection, "stdevFactor");
            Integer enforcementPercentage = JsonUtil.getNumberAsInteger(rawSuccessRateEjection, "enforcementPercentage");
            Integer minimumHosts = JsonUtil.getNumberAsInteger(rawSuccessRateEjection, "minimumHosts");
            Integer requestVolume = JsonUtil.getNumberAsInteger(rawSuccessRateEjection, "requestVolume");
            if (stdevFactor != null) {
                successRateEjectionBuilder.setStdevFactor(stdevFactor);
            }
            if (enforcementPercentage != null) {
                successRateEjectionBuilder.setEnforcementPercentage(enforcementPercentage);
            }
            if (minimumHosts != null) {
                successRateEjectionBuilder.setMinimumHosts(minimumHosts);
            }
            if (requestVolume != null) {
                successRateEjectionBuilder.setRequestVolume(requestVolume);
            }
            configBuilder.setSuccessRateEjection(successRateEjectionBuilder.build());
        }
        if ((rawFailurePercentageEjection = JsonUtil.getObject(rawConfig, "failurePercentageEjection")) != null) {
            OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.FailurePercentageEjection.Builder failurePercentageEjectionBuilder = new OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.FailurePercentageEjection.Builder();
            Integer threshold = JsonUtil.getNumberAsInteger(rawFailurePercentageEjection, "threshold");
            Integer enforcementPercentage = JsonUtil.getNumberAsInteger(rawFailurePercentageEjection, "enforcementPercentage");
            Integer minimumHosts = JsonUtil.getNumberAsInteger(rawFailurePercentageEjection, "minimumHosts");
            Integer requestVolume = JsonUtil.getNumberAsInteger(rawFailurePercentageEjection, "requestVolume");
            if (threshold != null) {
                failurePercentageEjectionBuilder.setThreshold(threshold);
            }
            if (enforcementPercentage != null) {
                failurePercentageEjectionBuilder.setEnforcementPercentage(enforcementPercentage);
            }
            if (minimumHosts != null) {
                failurePercentageEjectionBuilder.setMinimumHosts(minimumHosts);
            }
            if (requestVolume != null) {
                failurePercentageEjectionBuilder.setRequestVolume(requestVolume);
            }
            configBuilder.setFailurePercentageEjection(failurePercentageEjectionBuilder.build());
        }
        if ((childConfig = GracefulSwitchLoadBalancer.parseLoadBalancingPolicyConfig(JsonUtil.getListOfObjects(rawConfig, "childPolicy"))).getError() != null) {
            return NameResolver.ConfigOrError.fromError(Status.INTERNAL.withDescription("Failed to parse child in outlier_detection_experimental: " + rawConfig).withCause(childConfig.getError().asRuntimeException()));
        }
        configBuilder.setChildConfig(childConfig.getConfig());
        return NameResolver.ConfigOrError.fromConfig(configBuilder.build());
    }
}

