/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.netty.client;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.ozone.shaded.org.apache.ratis.client.RaftClientConfigKeys;
import org.apache.ozone.shaded.org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ozone.shaded.org.apache.ratis.client.impl.RaftClientRpcWithProxy;
import org.apache.ozone.shaded.org.apache.ratis.conf.RaftProperties;
import org.apache.ozone.shaded.org.apache.ratis.netty.NettyRpcProxy;
import org.apache.ozone.shaded.org.apache.ratis.proto.RaftProtos;
import org.apache.ozone.shaded.org.apache.ratis.proto.netty.NettyProtos;
import org.apache.ozone.shaded.org.apache.ratis.protocol.ClientId;
import org.apache.ozone.shaded.org.apache.ratis.protocol.GroupInfoRequest;
import org.apache.ozone.shaded.org.apache.ratis.protocol.GroupListRequest;
import org.apache.ozone.shaded.org.apache.ratis.protocol.GroupManagementRequest;
import org.apache.ozone.shaded.org.apache.ratis.protocol.LeaderElectionManagementRequest;
import org.apache.ozone.shaded.org.apache.ratis.protocol.RaftClientReply;
import org.apache.ozone.shaded.org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ozone.shaded.org.apache.ratis.protocol.RaftPeerId;
import org.apache.ozone.shaded.org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ozone.shaded.org.apache.ratis.protocol.SnapshotManagementRequest;
import org.apache.ozone.shaded.org.apache.ratis.protocol.TransferLeadershipRequest;
import org.apache.ozone.shaded.org.apache.ratis.protocol.exceptions.TimeoutIOException;
import org.apache.ozone.shaded.org.apache.ratis.util.JavaUtils;
import org.apache.ozone.shaded.org.apache.ratis.util.TimeDuration;
import org.apache.ozone.shaded.org.apache.ratis.util.TimeoutExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyClientRpc
extends RaftClientRpcWithProxy<NettyRpcProxy> {
    public static final Logger LOG = LoggerFactory.getLogger(NettyClientRpc.class);
    private ClientId clientId;
    private final TimeDuration requestTimeout;
    private final TimeoutExecutor scheduler = TimeoutExecutor.getInstance();

    public NettyClientRpc(ClientId clientId, RaftProperties properties) {
        super(new NettyRpcProxy.PeerMap(clientId.toString(), properties));
        this.clientId = clientId;
        this.requestTimeout = RaftClientConfigKeys.Rpc.requestTimeout(properties);
    }

    @Override
    public CompletableFuture<RaftClientReply> sendRequestAsync(RaftClientRequest request) {
        RaftPeerId serverId = request.getServerId();
        long callId = request.getCallId();
        try {
            NettyRpcProxy proxy = (NettyRpcProxy)this.getProxies().getProxy(serverId);
            NettyProtos.RaftNettyServerRequestProto serverRequestProto = this.buildRequestProto(request);
            CompletableFuture<RaftClientReply> replyFuture = new CompletableFuture<RaftClientReply>();
            ((CompletableFuture)proxy.sendAsync(serverRequestProto).thenApply(replyProto -> {
                if (request instanceof GroupListRequest) {
                    return ClientProtoUtils.toGroupListReply(replyProto.getGroupListReply());
                }
                if (request instanceof GroupInfoRequest) {
                    return ClientProtoUtils.toGroupInfoReply(replyProto.getGroupInfoReply());
                }
                return ClientProtoUtils.toRaftClientReply(replyProto.getRaftClientReply());
            })).whenComplete((reply, e) -> {
                if (e == null) {
                    if (reply == null) {
                        e = new NullPointerException("Both reply==null && e==null");
                    }
                    if (e == null) {
                        e = reply.getNotLeaderException();
                    }
                    if (e == null) {
                        e = reply.getLeaderNotReadyException();
                    }
                }
                if (e != null) {
                    replyFuture.completeExceptionally((Throwable)e);
                } else {
                    replyFuture.complete((RaftClientReply)reply);
                }
            });
            this.scheduler.onTimeout(this.requestTimeout, () -> {
                if (!replyFuture.isDone()) {
                    String s2 = this.clientId + "->" + serverId + " request #" + callId + " timeout " + this.requestTimeout.getDuration();
                    replyFuture.completeExceptionally(new TimeoutIOException(s2));
                }
            }, LOG, () -> "Timeout check for client request #" + callId);
            return replyFuture;
        }
        catch (Throwable e2) {
            return JavaUtils.completeExceptionally(e2);
        }
    }

    @Override
    public RaftClientReply sendRequest(RaftClientRequest request) throws IOException {
        RaftPeerId serverId = request.getServerId();
        NettyRpcProxy proxy = (NettyRpcProxy)this.getProxies().getProxy(serverId);
        NettyProtos.RaftNettyServerRequestProto serverRequestProto = this.buildRequestProto(request);
        RaftProtos.RaftRpcRequestProto rpcRequest = this.getRpcRequestProto(serverRequestProto);
        if (request instanceof GroupListRequest) {
            return ClientProtoUtils.toGroupListReply(proxy.send(rpcRequest, serverRequestProto).getGroupListReply());
        }
        if (request instanceof GroupInfoRequest) {
            return ClientProtoUtils.toGroupInfoReply(proxy.send(rpcRequest, serverRequestProto).getGroupInfoReply());
        }
        return ClientProtoUtils.toRaftClientReply(proxy.send(rpcRequest, serverRequestProto).getRaftClientReply());
    }

    private NettyProtos.RaftNettyServerRequestProto buildRequestProto(RaftClientRequest request) {
        NettyProtos.RaftNettyServerRequestProto.Builder b = NettyProtos.RaftNettyServerRequestProto.newBuilder();
        if (request instanceof GroupManagementRequest) {
            RaftProtos.GroupManagementRequestProto proto = ClientProtoUtils.toGroupManagementRequestProto((GroupManagementRequest)request);
            b.setGroupManagementRequest(proto);
        } else if (request instanceof SetConfigurationRequest) {
            RaftProtos.SetConfigurationRequestProto proto = ClientProtoUtils.toSetConfigurationRequestProto((SetConfigurationRequest)request);
            b.setSetConfigurationRequest(proto);
        } else if (request instanceof GroupListRequest) {
            RaftProtos.GroupListRequestProto proto = ClientProtoUtils.toGroupListRequestProto((GroupListRequest)request);
            b.setGroupListRequest(proto);
        } else if (request instanceof GroupInfoRequest) {
            RaftProtos.GroupInfoRequestProto proto = ClientProtoUtils.toGroupInfoRequestProto((GroupInfoRequest)request);
            b.setGroupInfoRequest(proto);
        } else if (request instanceof TransferLeadershipRequest) {
            RaftProtos.TransferLeadershipRequestProto proto = ClientProtoUtils.toTransferLeadershipRequestProto((TransferLeadershipRequest)request);
            b.setTransferLeadershipRequest(proto);
        } else if (request instanceof SnapshotManagementRequest) {
            RaftProtos.SnapshotManagementRequestProto proto = ClientProtoUtils.toSnapshotManagementRequestProto((SnapshotManagementRequest)request);
            b.setSnapshotManagementRequest(proto);
        } else if (request instanceof LeaderElectionManagementRequest) {
            RaftProtos.LeaderElectionManagementRequestProto proto = ClientProtoUtils.toLeaderElectionManagementRequestProto((LeaderElectionManagementRequest)request);
            b.setLeaderElectionManagementRequest(proto);
        } else {
            RaftProtos.RaftClientRequestProto proto = ClientProtoUtils.toRaftClientRequestProto(request);
            b.setRaftClientRequest(proto);
        }
        return b.build();
    }

    private RaftProtos.RaftRpcRequestProto getRpcRequestProto(NettyProtos.RaftNettyServerRequestProto serverRequestProto) {
        if (serverRequestProto.hasGroupManagementRequest()) {
            return serverRequestProto.getGroupManagementRequest().getRpcRequest();
        }
        if (serverRequestProto.hasSetConfigurationRequest()) {
            return serverRequestProto.getSetConfigurationRequest().getRpcRequest();
        }
        if (serverRequestProto.hasGroupListRequest()) {
            return serverRequestProto.getGroupListRequest().getRpcRequest();
        }
        if (serverRequestProto.hasGroupInfoRequest()) {
            return serverRequestProto.getGroupInfoRequest().getRpcRequest();
        }
        return serverRequestProto.getRaftClientRequest().getRpcRequest();
    }
}

