/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.commons.validator;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.ozone.shaded.org.apache.commons.logging.Log;
import org.apache.ozone.shaded.org.apache.commons.logging.LogFactory;
import org.apache.ozone.shaded.org.apache.commons.validator.Form;

public class FormSet
implements Serializable {
    private static final long serialVersionUID = -8936513232763306055L;
    protected static final int GLOBAL_FORMSET = 1;
    protected static final int LANGUAGE_FORMSET = 2;
    protected static final int COUNTRY_FORMSET = 3;
    protected static final int VARIANT_FORMSET = 4;
    private transient Log log = LogFactory.getLog(FormSet.class);
    private boolean processed;
    private String language;
    private String country;
    private String variant;
    private final Map<String, Form> forms = new HashMap<String, Form>();
    private final Map<String, String> constants = new HashMap<String, String>();
    private volatile boolean merged;

    public void addConstant(String name, String value) {
        if (this.constants.containsKey(name)) {
            this.getLog().error((Object)("Constant '" + name + "' already exists in FormSet[" + this.displayKey() + "] - ignoring."));
        } else {
            this.constants.put(name, value);
        }
    }

    public void addForm(Form f) {
        String formName = f.getName();
        if (this.forms.containsKey(formName)) {
            this.getLog().error((Object)("Form '" + formName + "' already exists in FormSet[" + this.displayKey() + "] - ignoring."));
        } else {
            this.forms.put(f.getName(), f);
        }
    }

    public String displayKey() {
        StringBuilder results = new StringBuilder();
        if (this.language != null && !this.language.isEmpty()) {
            results.append("language=");
            results.append(this.language);
        }
        if (this.country != null && !this.country.isEmpty()) {
            if (results.length() > 0) {
                results.append(", ");
            }
            results.append("country=");
            results.append(this.country);
        }
        if (this.variant != null && !this.variant.isEmpty()) {
            if (results.length() > 0) {
                results.append(", ");
            }
            results.append("variant=");
            results.append(this.variant);
        }
        if (results.length() == 0) {
            results.append("default");
        }
        return results.toString();
    }

    public String getCountry() {
        return this.country;
    }

    public Form getForm(String formName) {
        return this.forms.get(formName);
    }

    public Map<String, Form> getForms() {
        return Collections.unmodifiableMap(this.forms);
    }

    public String getLanguage() {
        return this.language;
    }

    private Log getLog() {
        if (this.log == null) {
            this.log = LogFactory.getLog(FormSet.class);
        }
        return this.log;
    }

    protected int getType() {
        String myLanguage = this.getLanguage();
        String myCountry = this.getCountry();
        if (this.getVariant() != null) {
            Objects.requireNonNull(myLanguage, "When variant is specified, country and language must be specified.");
            Objects.requireNonNull(myCountry, "When variant is specified, country and language must be specified.");
            return 4;
        }
        if (myCountry != null) {
            Objects.requireNonNull(myLanguage, "When country is specified, language must be specified.");
            return 3;
        }
        if (myLanguage != null) {
            return 2;
        }
        return 1;
    }

    public String getVariant() {
        return this.variant;
    }

    protected boolean isMerged() {
        return this.merged;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    protected void merge(FormSet depends) {
        if (depends != null) {
            Map<String, Form> myForms = this.getForms();
            Map<String, Form> dependsForms = depends.getForms();
            for (Map.Entry<String, Form> entry : dependsForms.entrySet()) {
                String key = entry.getKey();
                Form form = myForms.get(key);
                if (form != null) {
                    form.merge(entry.getValue());
                    continue;
                }
                this.addForm(entry.getValue());
            }
        }
        this.merged = true;
    }

    synchronized void process(Map<String, String> globalConstants) {
        for (Form f : this.forms.values()) {
            f.process(globalConstants, this.constants, this.forms);
        }
        this.processed = true;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }

    public String toString() {
        StringBuilder results = new StringBuilder();
        results.append("FormSet: language=");
        results.append(this.language);
        results.append("  country=");
        results.append(this.country);
        results.append("  variant=");
        results.append(this.variant);
        results.append("\n");
        for (Form name : this.getForms().values()) {
            results.append("   ");
            results.append(name);
            results.append("\n");
        }
        return results.toString();
    }
}

