/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.logs;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.Marshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.Serializer;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.InstrumentationScopeMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.ResourceMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.logs.InstrumentationScopeLogsMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.logs.LogMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.proto.logs.v1.internal.ResourceLogs;
import org.apache.ozone.shaded.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.ozone.shaded.io.opentelemetry.sdk.logs.data.LogRecordData;
import org.apache.ozone.shaded.io.opentelemetry.sdk.resources.Resource;

public final class ResourceLogsMarshaler
extends MarshalerWithSize {
    private final ResourceMarshaler resourceMarshaler;
    private final byte[] schemaUrl;
    private final InstrumentationScopeLogsMarshaler[] instrumentationScopeLogsMarshalers;

    public static ResourceLogsMarshaler[] create(Collection<LogRecordData> logs) {
        Map<Resource, Map<InstrumentationScopeInfo, List<Marshaler>>> resourceAndScopeMap = ResourceLogsMarshaler.groupByResourceAndScope(logs);
        ResourceLogsMarshaler[] resourceLogsMarshalers = new ResourceLogsMarshaler[resourceAndScopeMap.size()];
        int posResource = 0;
        for (Map.Entry<Resource, Map<InstrumentationScopeInfo, List<Marshaler>>> entry : resourceAndScopeMap.entrySet()) {
            InstrumentationScopeLogsMarshaler[] instrumentationScopeLogsMarshalers = new InstrumentationScopeLogsMarshaler[entry.getValue().size()];
            int posInstrumentation = 0;
            for (Map.Entry<InstrumentationScopeInfo, List<Marshaler>> entryIs : entry.getValue().entrySet()) {
                instrumentationScopeLogsMarshalers[posInstrumentation++] = new InstrumentationScopeLogsMarshaler(InstrumentationScopeMarshaler.create(entryIs.getKey()), MarshalerUtil.toBytes(entryIs.getKey().getSchemaUrl()), entryIs.getValue());
            }
            resourceLogsMarshalers[posResource++] = new ResourceLogsMarshaler(ResourceMarshaler.create(entry.getKey()), MarshalerUtil.toBytes(entry.getKey().getSchemaUrl()), instrumentationScopeLogsMarshalers);
        }
        return resourceLogsMarshalers;
    }

    ResourceLogsMarshaler(ResourceMarshaler resourceMarshaler, byte[] schemaUrl, InstrumentationScopeLogsMarshaler[] instrumentationScopeLogsMarshalers) {
        super(ResourceLogsMarshaler.calculateSize(resourceMarshaler, schemaUrl, instrumentationScopeLogsMarshalers));
        this.resourceMarshaler = resourceMarshaler;
        this.schemaUrl = schemaUrl;
        this.instrumentationScopeLogsMarshalers = instrumentationScopeLogsMarshalers;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeMessage(ResourceLogs.RESOURCE, this.resourceMarshaler);
        output.serializeRepeatedMessage(ResourceLogs.SCOPE_LOGS, this.instrumentationScopeLogsMarshalers);
        output.serializeString(ResourceLogs.SCHEMA_URL, this.schemaUrl);
    }

    private static int calculateSize(ResourceMarshaler resourceMarshaler, byte[] schemaUrl, InstrumentationScopeLogsMarshaler[] instrumentationScopeLogsMarshalers) {
        int size = 0;
        size += MarshalerUtil.sizeMessage(ResourceLogs.RESOURCE, resourceMarshaler);
        size += MarshalerUtil.sizeBytes(ResourceLogs.SCHEMA_URL, schemaUrl);
        return size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)ResourceLogs.SCOPE_LOGS, (Marshaler[])instrumentationScopeLogsMarshalers);
    }

    private static Map<Resource, Map<InstrumentationScopeInfo, List<Marshaler>>> groupByResourceAndScope(Collection<LogRecordData> logs) {
        return MarshalerUtil.groupByResourceAndScope(logs, LogRecordData::getResource, LogRecordData::getInstrumentationScopeInfo, LogMarshaler::create);
    }
}

