/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.exporter.internal;

import javax.annotation.Nullable;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.grpc.GrpcResponse;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.http.HttpSender;

public abstract class FailedExportException
extends Exception {
    private static final long serialVersionUID = 6988924855140178789L;

    private FailedExportException(@Nullable Throwable cause) {
        super(cause);
    }

    public static HttpExportException httpFailedWithResponse(HttpSender.Response response) {
        return new HttpExportException(response, null);
    }

    public static HttpExportException httpFailedExceptionally(Throwable cause) {
        return new HttpExportException(null, cause);
    }

    public static GrpcExportException grpcFailedWithResponse(GrpcResponse response) {
        return new GrpcExportException(response, null);
    }

    public static GrpcExportException grpcFailedExceptionally(Throwable cause) {
        return new GrpcExportException(null, cause);
    }

    public abstract boolean failedWithResponse();

    public static final class HttpExportException
    extends FailedExportException {
        private static final long serialVersionUID = -6787390183017184775L;
        @Nullable
        private final HttpSender.Response response;
        @Nullable
        private final Throwable cause;

        private HttpExportException(@Nullable HttpSender.Response response, @Nullable Throwable cause) {
            super(cause);
            this.response = response;
            this.cause = cause;
        }

        @Override
        public boolean failedWithResponse() {
            return this.response != null;
        }

        @Nullable
        public HttpSender.Response getResponse() {
            return this.response;
        }

        @Override
        @Nullable
        public Throwable getCause() {
            return this.cause;
        }
    }

    public static final class GrpcExportException
    extends FailedExportException {
        private static final long serialVersionUID = -9157548250286695364L;
        @Nullable
        private final GrpcResponse response;
        @Nullable
        private final Throwable cause;

        private GrpcExportException(@Nullable GrpcResponse response, @Nullable Throwable cause) {
            super(cause);
            this.response = response;
            this.cause = cause;
        }

        @Override
        public boolean failedWithResponse() {
            return this.response != null;
        }

        @Nullable
        public GrpcResponse getResponse() {
            return this.response;
        }

        @Override
        @Nullable
        public Throwable getCause() {
            return this.cause;
        }
    }
}

