/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.hadoop.hdds.server.YamlUtils;
import org.apache.hadoop.ozone.util.ObjectSerializer;
import org.apache.hadoop.ozone.util.WithChecksum;
import org.apache.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.ozone.shaded.org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.ozone.shaded.org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.ozone.shaded.org.apache.ratis.util.function.UncheckedAutoCloseableSupplier;
import org.apache.ozone.shaded.org.yaml.snakeyaml.Yaml;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class YamlSerializer<T extends WithChecksum<T>>
implements ObjectSerializer<T> {
    private static final Logger LOG = LoggerFactory.getLogger(YamlSerializer.class);
    private final GenericObjectPool<Yaml> yamlPool;

    public YamlSerializer(BasePooledObjectFactory<Yaml> yamlFactory) {
        this.yamlPool = new GenericObjectPool<Yaml>(yamlFactory);
    }

    private UncheckedAutoCloseableSupplier<Yaml> getYaml() throws IOException {
        try {
            final Yaml yaml = this.yamlPool.borrowObject();
            return new UncheckedAutoCloseableSupplier<Yaml>(){

                @Override
                public void close() {
                    YamlSerializer.this.yamlPool.returnObject(yaml);
                }

                @Override
                public Yaml get() {
                    return yaml;
                }
            };
        }
        catch (Exception e) {
            throw new IOException("Failed to get yaml object.", e);
        }
    }

    @Override
    public T load(File yamlFile) throws IOException {
        Preconditions.checkNotNull(yamlFile, "yamlFile cannot be null");
        try (InputStream inputFileStream = Files.newInputStream(yamlFile.toPath(), new OpenOption[0]);){
            T t2 = this.load(inputFileStream);
            return t2;
        }
    }

    @Override
    public T load(InputStream input) throws IOException {
        WithChecksum dataYaml;
        try (UncheckedAutoCloseableSupplier<Yaml> yaml = this.getYaml();){
            dataYaml = (WithChecksum)((Yaml)yaml.get()).load(input);
        }
        catch (Exception e) {
            throw new IOException("Failed to load file", e);
        }
        if (dataYaml == null) {
            throw new IOException("Failed to load file. File is empty.");
        }
        return (T)dataYaml;
    }

    @Override
    public boolean verifyChecksum(T data) throws IOException {
        Preconditions.checkNotNull(data, "data cannot be null");
        String storedChecksum = data.getChecksum();
        if (storedChecksum == null) {
            LOG.warn("No checksum found in snapshot data for verification");
            return false;
        }
        WithChecksum copy = (WithChecksum)data.copyObject();
        try (UncheckedAutoCloseableSupplier<Yaml> yaml = this.getYaml();){
            this.computeAndSetChecksum((Yaml)yaml.get(), copy);
            String computedChecksum = copy.getChecksum();
            boolean isValid = storedChecksum.equals(computedChecksum);
            if (!isValid) {
                LOG.warn("Checksum verification failed for snapshot local data. Stored: {}, Computed: {}", (Object)storedChecksum, (Object)computedChecksum);
            }
            boolean bl = isValid;
            return bl;
        }
    }

    @Override
    public void save(File yamlFile, T data) throws IOException {
        try (UncheckedAutoCloseableSupplier<Yaml> yaml = this.getYaml();){
            this.computeAndSetChecksum((Yaml)yaml.get(), data);
            YamlUtils.dump((Yaml)yaml.get(), data, yamlFile, LOG);
        }
    }

    @Override
    public void close() {
        this.yamlPool.close();
    }

    public abstract void computeAndSetChecksum(Yaml var1, T var2) throws IOException;
}

