/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CodecBuffer;
import org.apache.ozone.shaded.jakarta.annotation.Nonnull;

public final class BooleanCodec
implements Codec<Boolean> {
    private static final byte TRUE = 1;
    private static final byte FALSE = 0;
    private static final BooleanCodec INSTANCE = new BooleanCodec();

    public static BooleanCodec get() {
        return INSTANCE;
    }

    private BooleanCodec() {
    }

    @Override
    public Class<Boolean> getTypeClass() {
        return Boolean.class;
    }

    @Override
    public boolean supportCodecBuffer() {
        return true;
    }

    @Override
    public CodecBuffer toCodecBuffer(Boolean object, CodecBuffer.Allocator allocator) {
        return ((CodecBuffer)allocator.apply(1)).put((byte)1);
    }

    @Override
    public Boolean fromCodecBuffer(@Nonnull CodecBuffer buffer) {
        return buffer.asReadOnlyByteBuffer().get() == 1;
    }

    @Override
    public byte[] toPersistedFormat(Boolean object) {
        byte[] byArray;
        if (object.booleanValue()) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 1;
        } else {
            byte[] byArray3 = new byte[1];
            byArray = byArray3;
            byArray3[0] = 0;
        }
        return byArray;
    }

    @Override
    public Boolean fromPersistedFormat(byte[] rawData) {
        if (rawData.length != 1) {
            throw new IllegalStateException("Byte Buffer for boolean should be of length 1 but provided byte array of length " + rawData.length);
        }
        return rawData[0] == 1;
    }

    @Override
    public Boolean copyObject(Boolean object) {
        return object;
    }
}

