/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.vault.response;

import com.bettercloud.vault.json.Json;
import com.bettercloud.vault.json.JsonObject;
import com.bettercloud.vault.json.ParseException;
import com.bettercloud.vault.response.VaultResponse;
import com.bettercloud.vault.rest.RestResponse;
import java.nio.charset.StandardCharsets;

public class SealResponse
extends VaultResponse {
    private Boolean sealed;
    private Long threshold;
    private Long numberOfShares;
    private Long progress;

    public SealResponse(RestResponse restResponse, int retries) {
        super(restResponse, retries);
        try {
            String responseJson = new String(restResponse.getBody(), StandardCharsets.UTF_8);
            JsonObject jsonObject = Json.parse(responseJson).asObject();
            this.sealed = jsonObject.getBoolean("sealed", false);
            this.threshold = jsonObject.getLong("t", 0L);
            this.numberOfShares = jsonObject.getLong("n", 0L);
            this.progress = jsonObject.getLong("progress", 0L);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public Boolean getSealed() {
        return this.sealed;
    }

    public Long getThreshold() {
        return this.threshold;
    }

    public Long getNumberOfShares() {
        return this.numberOfShares;
    }

    public Long getProgress() {
        return this.progress;
    }
}

