/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.exceptions;

import java.io.IOException;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.NotLeaderException;

public class OMNotLeaderException
extends IOException {
    private final String leaderPeerId;
    private final String leaderAddress;

    public OMNotLeaderException(RaftPeerId currentPeerId) {
        super("OM:" + currentPeerId + " is not the leader. Could not determine the leader node.");
        this.leaderPeerId = null;
        this.leaderAddress = null;
    }

    public OMNotLeaderException(RaftPeerId currentPeerId, RaftPeerId suggestedLeaderPeerId) {
        this(currentPeerId, suggestedLeaderPeerId, null);
    }

    public OMNotLeaderException(RaftPeerId currentPeerId, RaftPeerId suggestedLeaderPeerId, String suggestedLeaderAddress) {
        super("OM:" + currentPeerId + " is not the leader. Suggested leader is OM:" + suggestedLeaderPeerId + "[" + suggestedLeaderAddress + "].");
        this.leaderPeerId = suggestedLeaderPeerId.toString();
        this.leaderAddress = suggestedLeaderAddress;
    }

    public OMNotLeaderException(String msg) {
        super(msg);
        this.leaderPeerId = null;
        this.leaderAddress = null;
    }

    public String getSuggestedLeaderNodeId() {
        return this.leaderPeerId;
    }

    public String getSuggestedLeaderAddress() {
        return this.leaderAddress;
    }

    public static OMNotLeaderException convertToOMNotLeaderException(NotLeaderException notLeaderException, RaftPeerId currentPeer) {
        RaftPeerId suggestedLeader = notLeaderException.getSuggestedLeader() != null ? notLeaderException.getSuggestedLeader().getId() : null;
        String suggestedLeaderAddress = notLeaderException.getSuggestedLeader() != null ? notLeaderException.getSuggestedLeader().getAddress() : null;
        OMNotLeaderException omNotLeaderException = suggestedLeader != null ? new OMNotLeaderException(currentPeer, suggestedLeader, suggestedLeaderAddress) : new OMNotLeaderException(currentPeer);
        return omNotLeaderException;
    }
}

