/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.ozone.shaded.org.apache.ratis.util.JavaUtils;
import org.apache.ozone.shaded.org.apache.ratis.util.TimeDuration;
import org.apache.ozone.shaded.org.apache.ratis.util.function.CheckedConsumer;
import org.apache.ozone.shaded.org.apache.ratis.util.function.CheckedFunction;

public interface ConcurrentUtils {
    public static <E, THROWABLE extends Throwable> E updateAndGet(AtomicReference<E> reference, CheckedFunction<E, E, THROWABLE> update) throws THROWABLE {
        AtomicReference throwableRef = new AtomicReference();
        E updated = reference.updateAndGet(value -> {
            try {
                return update.apply(value);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable t2) {
                throwableRef.set(t2);
                return value;
            }
        });
        Throwable t2 = (Throwable)throwableRef.get();
        if (t2 != null) {
            throw t2;
        }
        return updated;
    }

    public static ThreadFactory newThreadFactory(String namePrefix) {
        AtomicInteger numThread = new AtomicInteger();
        return runnable2 -> {
            int id = numThread.incrementAndGet();
            Thread t2 = new Thread(runnable2);
            t2.setName(namePrefix + "-thread" + id);
            return t2;
        };
    }

    public static ExecutorService newSingleThreadExecutor(String name) {
        return Executors.newSingleThreadExecutor((Runnable runnable2) -> {
            Thread t2 = new Thread(runnable2);
            t2.setName(name);
            return t2;
        });
    }

    public static ExecutorService newCachedThreadPool(int maximumPoolSize, ThreadFactory threadFactory) {
        return maximumPoolSize == 0 ? Executors.newCachedThreadPool(threadFactory) : new ThreadPoolExecutor(0, maximumPoolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    public static ExecutorService newThreadPoolWithMax(boolean cached, int maximumPoolSize, String namePrefix) {
        ThreadFactory f = ConcurrentUtils.newThreadFactory(namePrefix);
        return cached ? ConcurrentUtils.newCachedThreadPool(maximumPoolSize, f) : Executors.newFixedThreadPool(maximumPoolSize, f);
    }

    public static void shutdownAndWait(ExecutorService executor) {
        ConcurrentUtils.shutdownAndWait(TimeDuration.ONE_DAY, executor, timeout2 -> {
            throw new IllegalStateException(executor.getClass().getName() + " shutdown timeout in " + timeout2);
        });
    }

    public static void shutdownAndWait(TimeDuration waitTime, ExecutorService executor, Consumer<TimeDuration> timoutHandler) {
        executor.shutdown();
        try {
            if (executor.awaitTermination(waitTime.getDuration(), waitTime.getUnit())) {
                return;
            }
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            return;
        }
        if (timoutHandler != null) {
            timoutHandler.accept(waitTime);
        }
    }

    public static <E, THROWABLE extends Throwable> CompletableFuture<Void> parallelForEachAsync(Stream<E> stream, int size, CheckedConsumer<? super E, THROWABLE> action, Executor executor) {
        ArrayList futures = new ArrayList(size);
        stream.forEach(element -> {
            CompletableFuture f = new CompletableFuture();
            futures.add(f);
            executor.execute(() -> ConcurrentUtils.accept(action, element, f));
        });
        return JavaUtils.allOf(futures);
    }

    public static <E, THROWABLE extends Throwable> CompletableFuture<Void> parallelForEachAsync(Collection<E> collection, CheckedConsumer<? super E, THROWABLE> action, Executor executor) {
        return ConcurrentUtils.parallelForEachAsync(collection.stream(), collection.size(), action, executor);
    }

    public static <THROWABLE extends Throwable> CompletableFuture<Void> parallelForEachAsync(int size, CheckedConsumer<Integer, THROWABLE> action, Executor executor) {
        AtomicInteger i = new AtomicInteger();
        return ConcurrentUtils.parallelForEachAsync(Stream.generate(i::getAndIncrement).limit(size), size, action, executor);
    }

    public static <E, THROWABLE extends Throwable> void accept(CheckedConsumer<? super E, THROWABLE> action, E element, CompletableFuture<E> f) {
        try {
            action.accept(element);
            f.complete(element);
        }
        catch (Throwable t2) {
            f.completeExceptionally(t2);
        }
    }
}

