/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.sdk.trace;

import java.io.Closeable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.ozone.shaded.io.opentelemetry.api.trace.Tracer;
import org.apache.ozone.shaded.io.opentelemetry.api.trace.TracerBuilder;
import org.apache.ozone.shaded.io.opentelemetry.api.trace.TracerProvider;
import org.apache.ozone.shaded.io.opentelemetry.sdk.common.Clock;
import org.apache.ozone.shaded.io.opentelemetry.sdk.common.CompletableResultCode;
import org.apache.ozone.shaded.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.ozone.shaded.io.opentelemetry.sdk.internal.ComponentRegistry;
import org.apache.ozone.shaded.io.opentelemetry.sdk.internal.ExceptionAttributeResolver;
import org.apache.ozone.shaded.io.opentelemetry.sdk.internal.ScopeConfigurator;
import org.apache.ozone.shaded.io.opentelemetry.sdk.resources.Resource;
import org.apache.ozone.shaded.io.opentelemetry.sdk.trace.IdGenerator;
import org.apache.ozone.shaded.io.opentelemetry.sdk.trace.SdkTracer;
import org.apache.ozone.shaded.io.opentelemetry.sdk.trace.SdkTracerBuilder;
import org.apache.ozone.shaded.io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import org.apache.ozone.shaded.io.opentelemetry.sdk.trace.SpanLimits;
import org.apache.ozone.shaded.io.opentelemetry.sdk.trace.SpanProcessor;
import org.apache.ozone.shaded.io.opentelemetry.sdk.trace.TracerSharedState;
import org.apache.ozone.shaded.io.opentelemetry.sdk.trace.internal.TracerConfig;
import org.apache.ozone.shaded.io.opentelemetry.sdk.trace.samplers.Sampler;

public final class SdkTracerProvider
implements TracerProvider,
Closeable {
    private static final Logger logger = Logger.getLogger(SdkTracerProvider.class.getName());
    static final String DEFAULT_TRACER_NAME = "";
    private final TracerSharedState sharedState;
    private final ComponentRegistry<SdkTracer> tracerSdkComponentRegistry;
    private ScopeConfigurator<TracerConfig> tracerConfigurator;

    public static SdkTracerProviderBuilder builder() {
        return new SdkTracerProviderBuilder();
    }

    SdkTracerProvider(Clock clock, IdGenerator idsGenerator, Resource resource, Supplier<SpanLimits> spanLimitsSupplier, Sampler sampler, List<SpanProcessor> spanProcessors, ScopeConfigurator<TracerConfig> tracerConfigurator, ExceptionAttributeResolver exceptionAttributeResolver) {
        this.sharedState = new TracerSharedState(clock, idsGenerator, resource, spanLimitsSupplier, sampler, spanProcessors, exceptionAttributeResolver);
        this.tracerSdkComponentRegistry = new ComponentRegistry<SdkTracer>(instrumentationScopeInfo -> SdkTracer.create(this.sharedState, instrumentationScopeInfo, this.getTracerConfig((InstrumentationScopeInfo)instrumentationScopeInfo)));
        this.tracerConfigurator = tracerConfigurator;
    }

    private TracerConfig getTracerConfig(InstrumentationScopeInfo instrumentationScopeInfo) {
        TracerConfig tracerConfig = (TracerConfig)this.tracerConfigurator.apply((TracerConfig)((Object)instrumentationScopeInfo));
        return tracerConfig == null ? TracerConfig.defaultConfig() : tracerConfig;
    }

    @Override
    public Tracer get(String instrumentationScopeName) {
        return this.tracerBuilder(instrumentationScopeName).build();
    }

    @Override
    public Tracer get(String instrumentationScopeName, String instrumentationScopeVersion) {
        return this.tracerBuilder(instrumentationScopeName).setInstrumentationVersion(instrumentationScopeVersion).build();
    }

    @Override
    public TracerBuilder tracerBuilder(@Nullable String instrumentationScopeName) {
        if (instrumentationScopeName == null || instrumentationScopeName.isEmpty()) {
            logger.fine("Tracer requested without instrumentation scope name.");
            instrumentationScopeName = DEFAULT_TRACER_NAME;
        }
        return new SdkTracerBuilder(this.tracerSdkComponentRegistry, instrumentationScopeName);
    }

    public SpanLimits getSpanLimits() {
        return this.sharedState.getSpanLimits();
    }

    public Sampler getSampler() {
        return this.sharedState.getSampler();
    }

    void setTracerConfigurator(ScopeConfigurator<TracerConfig> tracerConfigurator) {
        this.tracerConfigurator = tracerConfigurator;
        this.tracerSdkComponentRegistry.getComponents().forEach(sdkTracer -> sdkTracer.updateTracerConfig(this.getTracerConfig(sdkTracer.getInstrumentationScopeInfo())));
    }

    public CompletableResultCode shutdown() {
        if (this.sharedState.hasBeenShutdown()) {
            logger.log(Level.INFO, "Calling shutdown() multiple times.");
            return CompletableResultCode.ofSuccess();
        }
        return this.sharedState.shutdown();
    }

    public CompletableResultCode forceFlush() {
        return this.sharedState.getActiveSpanProcessor().forceFlush();
    }

    @Override
    public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }

    public String toString() {
        return "SdkTracerProvider{clock=" + this.sharedState.getClock() + ", idGenerator=" + this.sharedState.getIdGenerator() + ", resource=" + this.sharedState.getResource() + ", spanLimitsSupplier=" + this.sharedState.getSpanLimits() + ", sampler=" + this.sharedState.getSampler() + ", spanProcessor=" + this.sharedState.getActiveSpanProcessor() + ", tracerConfigurator=" + this.tracerConfigurator + '}';
    }
}

