/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.debug;

import java.util.Locale;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.debug.SourceInfo;

final class StackTraceSourceInfo
implements SourceInfo {
    private final StackTraceElement[] stackTraceElements;

    StackTraceSourceInfo(StackTraceElement[] stackTraceElements) {
        this.stackTraceElements = stackTraceElements;
    }

    @Override
    public String shortDebugString() {
        if (this.stackTraceElements.length > 0) {
            for (StackTraceElement e : this.stackTraceElements) {
                if (!StackTraceSourceInfo.isInterestingStackTrace(e)) continue;
                return String.format(Locale.ROOT, "%s:%d", e.getFileName(), e.getLineNumber());
            }
        }
        return "unknown source";
    }

    @Override
    public String multiLineDebugString() {
        if (this.stackTraceElements.length > 0) {
            StringBuilder result2 = new StringBuilder();
            for (StackTraceElement e : this.stackTraceElements) {
                if (!StackTraceSourceInfo.isInterestingStackTrace(e)) continue;
                result2.append("\tat ").append(e).append("\n");
            }
            return result2.toString();
        }
        return "\tat unknown source";
    }

    private static boolean isInterestingStackTrace(StackTraceElement e) {
        return !e.getClassName().startsWith("org.apache.ozone.shaded.io.opentelemetry.sdk.metrics") && !e.getClassName().startsWith("java.lang");
    }
}

