/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.exporter.sender.okhttp.internal;

import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import org.apache.ozone.shaded.io.opentelemetry.api.internal.InstrumentationUtil;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.RetryUtil;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.compression.Compressor;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.http.HttpSender;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.Marshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.sender.okhttp.internal.OkHttpUtil;
import org.apache.ozone.shaded.io.opentelemetry.exporter.sender.okhttp.internal.RetryInterceptor;
import org.apache.ozone.shaded.io.opentelemetry.sdk.common.CompletableResultCode;
import org.apache.ozone.shaded.io.opentelemetry.sdk.common.export.ProxyOptions;
import org.apache.ozone.shaded.io.opentelemetry.sdk.common.export.RetryPolicy;
import org.apache.ozone.shaded.okhttp3.Call;
import org.apache.ozone.shaded.okhttp3.Callback;
import org.apache.ozone.shaded.okhttp3.ConnectionSpec;
import org.apache.ozone.shaded.okhttp3.Dispatcher;
import org.apache.ozone.shaded.okhttp3.HttpUrl;
import org.apache.ozone.shaded.okhttp3.MediaType;
import org.apache.ozone.shaded.okhttp3.OkHttpClient;
import org.apache.ozone.shaded.okhttp3.Request;
import org.apache.ozone.shaded.okhttp3.RequestBody;
import org.apache.ozone.shaded.okhttp3.Response;
import org.apache.ozone.shaded.okhttp3.ResponseBody;
import org.apache.ozone.shaded.okio.BufferedSink;
import org.apache.ozone.shaded.okio.Okio;

public final class OkHttpHttpSender
implements HttpSender {
    private final boolean managedExecutor;
    private final OkHttpClient client;
    private final HttpUrl url;
    @Nullable
    private final Compressor compressor;
    private final boolean exportAsJson;
    private final Supplier<Map<String, List<String>>> headerSupplier;
    private final MediaType mediaType;

    public OkHttpHttpSender(String endpoint, @Nullable Compressor compressor, boolean exportAsJson, String contentType, long timeoutNanos, long connectionTimeoutNanos, Supplier<Map<String, List<String>>> headerSupplier, @Nullable ProxyOptions proxyOptions, @Nullable RetryPolicy retryPolicy, @Nullable SSLContext sslContext, @Nullable X509TrustManager trustManager, @Nullable ExecutorService executorService) {
        boolean isPlainHttp;
        Dispatcher dispatcher;
        int callTimeoutMillis = (int)Math.min(Duration.ofNanos(timeoutNanos).toMillis(), Integer.MAX_VALUE);
        int connectTimeoutMillis = (int)Math.min(Duration.ofNanos(connectionTimeoutNanos).toMillis(), Integer.MAX_VALUE);
        if (executorService == null) {
            dispatcher = OkHttpUtil.newDispatcher();
            this.managedExecutor = true;
        } else {
            dispatcher = new Dispatcher(executorService);
            this.managedExecutor = false;
        }
        OkHttpClient.Builder builder = new OkHttpClient.Builder().dispatcher(dispatcher).connectTimeout(Duration.ofMillis(connectTimeoutMillis)).callTimeout(Duration.ofMillis(callTimeoutMillis));
        if (proxyOptions != null) {
            builder.proxySelector(proxyOptions.getProxySelector());
        }
        if (retryPolicy != null) {
            builder.addInterceptor(new RetryInterceptor(retryPolicy, OkHttpHttpSender::isRetryable));
        }
        if (isPlainHttp = endpoint.startsWith("http://")) {
            builder.connectionSpecs(Collections.singletonList(ConnectionSpec.CLEARTEXT));
        } else if (sslContext != null && trustManager != null) {
            builder.sslSocketFactory(sslContext.getSocketFactory(), trustManager);
        }
        this.client = builder.build();
        this.url = HttpUrl.get(endpoint);
        this.compressor = compressor;
        this.exportAsJson = exportAsJson;
        this.mediaType = MediaType.parse(contentType);
        this.headerSupplier = headerSupplier;
    }

    @Override
    public void send(Marshaler marshaler, int contentLength, final Consumer<HttpSender.Response> onResponse, final Consumer<Throwable> onError) {
        Request.Builder requestBuilder = new Request.Builder().url(this.url);
        Map<String, List<String>> headers = this.headerSupplier.get();
        if (headers != null) {
            headers.forEach((key, values2) -> values2.forEach(value -> requestBuilder.addHeader((String)key, (String)value)));
        }
        RawRequestBody body = new RawRequestBody(marshaler, this.exportAsJson, contentLength, this.mediaType);
        if (this.compressor != null) {
            requestBuilder.addHeader("Content-Encoding", this.compressor.getEncoding());
            requestBuilder.post(new CompressedRequestBody(this.compressor, body));
        } else {
            requestBuilder.post(body);
        }
        InstrumentationUtil.suppressInstrumentation(() -> this.client.newCall(requestBuilder.build()).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                onError.accept(e);
            }

            @Override
            public void onResponse(Call call, final Response response) {
                try (final ResponseBody body = response.body();){
                    onResponse.accept(new HttpSender.Response(){
                        @Nullable
                        private byte[] bodyBytes;

                        @Override
                        public int statusCode() {
                            return response.code();
                        }

                        @Override
                        public String statusMessage() {
                            return response.message();
                        }

                        @Override
                        public byte[] responseBody() throws IOException {
                            if (this.bodyBytes == null) {
                                this.bodyBytes = body.bytes();
                            }
                            return this.bodyBytes;
                        }
                    });
                }
            }
        }));
    }

    @Override
    public CompletableResultCode shutdown() {
        this.client.dispatcher().cancelAll();
        if (this.managedExecutor) {
            this.client.dispatcher().executorService().shutdownNow();
        }
        this.client.connectionPool().evictAll();
        return CompletableResultCode.ofSuccess();
    }

    static boolean isRetryable(Response response) {
        return RetryUtil.retryableHttpResponseCodes().contains(response.code());
    }

    private static class RawRequestBody
    extends RequestBody {
        private final Marshaler marshaler;
        private final boolean exportAsJson;
        private final int contentLength;
        private final MediaType mediaType;

        private RawRequestBody(Marshaler marshaler, boolean exportAsJson, int contentLength, MediaType mediaType) {
            this.marshaler = marshaler;
            this.exportAsJson = exportAsJson;
            this.contentLength = contentLength;
            this.mediaType = mediaType;
        }

        @Override
        public long contentLength() {
            return this.contentLength;
        }

        @Override
        public MediaType contentType() {
            return this.mediaType;
        }

        @Override
        public void writeTo(BufferedSink bufferedSink) throws IOException {
            if (this.exportAsJson) {
                this.marshaler.writeJsonTo(bufferedSink.outputStream());
            } else {
                this.marshaler.writeBinaryTo(bufferedSink.outputStream());
            }
        }
    }

    private static class CompressedRequestBody
    extends RequestBody {
        private final Compressor compressor;
        private final RequestBody requestBody;

        private CompressedRequestBody(Compressor compressor, RequestBody requestBody) {
            this.compressor = compressor;
            this.requestBody = requestBody;
        }

        @Override
        public MediaType contentType() {
            return this.requestBody.contentType();
        }

        @Override
        public long contentLength() {
            return -1L;
        }

        @Override
        public void writeTo(BufferedSink bufferedSink) throws IOException {
            BufferedSink compressedSink = Okio.buffer(Okio.sink(this.compressor.compress(bufferedSink.outputStream())));
            this.requestBody.writeTo(compressedSink);
            compressedSink.close();
        }
    }
}

