/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.api.common;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import org.apache.ozone.shaded.io.opentelemetry.api.common.Value;
import org.apache.ozone.shaded.io.opentelemetry.api.common.ValueType;

final class ValueBytes
implements Value<ByteBuffer> {
    private final byte[] raw;

    private ValueBytes(byte[] value) {
        this.raw = value;
    }

    static Value<ByteBuffer> create(byte[] value) {
        Objects.requireNonNull(value, "value must not be null");
        return new ValueBytes(Arrays.copyOf(value, value.length));
    }

    @Override
    public ValueType getType() {
        return ValueType.BYTES;
    }

    @Override
    public ByteBuffer getValue() {
        return ByteBuffer.wrap(this.raw).asReadOnlyBuffer();
    }

    @Override
    public String asString() {
        return Base64.getEncoder().encodeToString(this.raw);
    }

    public String toString() {
        return "ValueBytes{" + this.asString() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof ValueBytes && Arrays.equals(this.raw, ((ValueBytes)o).raw);
    }

    public int hashCode() {
        return Arrays.hashCode(this.raw);
    }
}

