/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.util;

import java.util.UUID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.shaded.com.google.protobuf.CodedOutputStream;

public final class ProtobufUtils {
    private ProtobufUtils() {
    }

    public static HddsProtos.UUID toProtobuf(UUID uuid) {
        return HddsProtos.UUID.newBuilder().setMostSigBits(uuid.getMostSignificantBits()).setLeastSigBits(uuid.getLeastSignificantBits()).build();
    }

    public static UUID fromProtobuf(HddsProtos.UUID proto) {
        return new UUID(proto.getMostSigBits(), proto.getLeastSigBits());
    }

    public static int computeRepeatedStringSize(String value) {
        return CodedOutputStream.computeStringSizeNoTag(value);
    }

    public static int computeLongSizeWithTag(int fieldNumber, long value) {
        return CodedOutputStream.computeInt64Size(fieldNumber, value);
    }
}

