/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.security;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.function.BiConsumer;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.ozone.OzoneConsts;
import org.apache.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.ozone.shaded.org.apache.commons.lang3.RandomStringUtils;

public class GDPRSymmetricKey {
    private static final ThreadLocal<SecureRandom> RANDOM = ThreadLocal.withInitial(SecureRandom::new);
    private final SecretKeySpec secretKey;
    private final Cipher cipher;
    private final String algorithm;
    private final String secret;

    public static GDPRSymmetricKey newDefaultInstance() {
        try {
            return new GDPRSymmetricKey(RANDOM.get());
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create default " + GDPRSymmetricKey.class.getSimpleName(), e);
        }
    }

    static String randomSecret(SecureRandom secureRandom) {
        return RandomStringUtils.random(16, 0, 0, true, true, null, secureRandom);
    }

    public SecretKeySpec getSecretKey() {
        return this.secretKey;
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    public GDPRSymmetricKey(SecureRandom secureRandom) throws NoSuchPaddingException, NoSuchAlgorithmException {
        this(GDPRSymmetricKey.randomSecret(secureRandom), "AES");
    }

    public GDPRSymmetricKey(String secret, String algorithm) throws NoSuchPaddingException, NoSuchAlgorithmException {
        Preconditions.checkNotNull(secret, "Secret cannot be null");
        Preconditions.checkArgument(secret.length() == 16, "Secret must be exactly 16 characters");
        Preconditions.checkNotNull(algorithm, "Algorithm cannot be null");
        this.secret = secret;
        this.algorithm = algorithm;
        this.secretKey = new SecretKeySpec(secret.getBytes(OzoneConsts.GDPR_CHARSET), algorithm);
        this.cipher = Cipher.getInstance(algorithm);
    }

    public void acceptKeyDetails(BiConsumer<String, String> consumer) {
        consumer.accept("secret", this.secret);
        consumer.accept("algorithm", this.algorithm);
    }
}

