/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.lock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.utils.CompositeKey;
import org.apache.hadoop.hdds.utils.SimpleStriped;
import org.apache.hadoop.ipc.ProcessingDetails;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ozone.om.lock.FlatResource;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OMLockDetails;
import org.apache.hadoop.ozone.om.lock.OMLockMetrics;
import org.apache.hadoop.util.Time;
import org.apache.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.ozone.shaded.com.google.common.collect.ImmutableMap;
import org.apache.ozone.shaded.com.google.common.util.concurrent.Striped;
import org.apache.ozone.shaded.org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzoneManagerLock
implements IOzoneManagerLock {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneManagerLock.class);
    private final Map<Class<? extends IOzoneManagerLock.Resource>, Pair<Map<IOzoneManagerLock.Resource, Striped<ReadWriteLock>>, ResourceLockManager>> resourcelockMap;
    private OMLockMetrics omLockMetrics = OMLockMetrics.create();

    public OzoneManagerLock(ConfigurationSource conf) {
        this.resourcelockMap = ImmutableMap.of(LeveledResource.class, this.getLeveledLocks(conf), FlatResource.class, this.getFlatLocks(conf));
    }

    private Pair<Map<IOzoneManagerLock.Resource, Striped<ReadWriteLock>>, ResourceLockManager> getLeveledLocks(ConfigurationSource conf) {
        EnumMap<LeveledResource, Striped<ReadWriteLock>> stripedLockMap = new EnumMap<LeveledResource, Striped<ReadWriteLock>>(LeveledResource.class);
        for (LeveledResource r : LeveledResource.values()) {
            stripedLockMap.put(r, this.createStripeLock(r, conf));
        }
        return Pair.of(Collections.unmodifiableMap(stripedLockMap), new LeveledResourceLockManager());
    }

    private Pair<Map<IOzoneManagerLock.Resource, Striped<ReadWriteLock>>, ResourceLockManager> getFlatLocks(ConfigurationSource conf) {
        EnumMap<FlatResource, Striped<ReadWriteLock>> stripedLockMap = new EnumMap<FlatResource, Striped<ReadWriteLock>>(FlatResource.class);
        for (FlatResource r : FlatResource.values()) {
            stripedLockMap.put(r, this.createStripeLock(r, conf));
        }
        return Pair.of(Collections.unmodifiableMap(stripedLockMap), new FlatResourceLockManager());
    }

    private Striped<ReadWriteLock> createStripeLock(IOzoneManagerLock.Resource r, ConfigurationSource conf) {
        boolean fair = conf.getBoolean("ozone.om.lock.fair", false);
        String stripeSizeKey = "ozone.om.lock.stripes." + r.getName().toLowerCase();
        int size = conf.getInt(stripeSizeKey, 512);
        return SimpleStriped.readWriteLock(size, fair);
    }

    private Iterable<ReadWriteLock> getAllLocks(Striped<ReadWriteLock> striped) {
        return IntStream.range(0, striped.size()).mapToObj(striped::getAt).collect(Collectors.toList());
    }

    private Iterable<ReadWriteLock> bulkGetLock(Striped<ReadWriteLock> striped, Collection<String[]> keys2) {
        ArrayList<Object> lockKeys = new ArrayList<Object>(keys2.size());
        for (Object[] objectArray : keys2) {
            if (!Objects.nonNull(objectArray)) continue;
            lockKeys.add(CompositeKey.combineKeys(objectArray));
        }
        return striped.bulkGet(lockKeys);
    }

    private ReentrantReadWriteLock getLock(Map<IOzoneManagerLock.Resource, Striped<ReadWriteLock>> lockMap, IOzoneManagerLock.Resource resource, String ... keys2) {
        Striped<ReadWriteLock> striped = lockMap.get(resource);
        Object key = CompositeKey.combineKeys(keys2);
        return (ReentrantReadWriteLock)striped.get(key);
    }

    @Override
    public OMLockDetails acquireReadLock(IOzoneManagerLock.Resource resource, String ... keys2) {
        return this.acquireLock(resource, true, keys2);
    }

    @Override
    public OMLockDetails acquireReadLocks(IOzoneManagerLock.Resource resource, Collection<String[]> keys2) {
        return this.acquireLocks(resource, true, striped -> this.bulkGetLock((Striped<ReadWriteLock>)striped, keys2));
    }

    @Override
    public OMLockDetails acquireWriteLock(IOzoneManagerLock.Resource resource, String ... keys2) {
        return this.acquireLock(resource, false, keys2);
    }

    @Override
    public OMLockDetails acquireWriteLocks(IOzoneManagerLock.Resource resource, Collection<String[]> keys2) {
        return this.acquireLocks(resource, false, striped -> this.bulkGetLock((Striped<ReadWriteLock>)striped, keys2));
    }

    @Override
    public OMLockDetails acquireResourceWriteLock(IOzoneManagerLock.Resource resource) {
        return this.acquireLocks(resource, false, this::getAllLocks);
    }

    private void acquireLock(IOzoneManagerLock.Resource resource, boolean isReadLock, ReadWriteLock lock, long startWaitingTimeNanos) {
        if (isReadLock) {
            lock.readLock().lock();
            this.updateReadLockMetrics(resource, (ReentrantReadWriteLock)lock, startWaitingTimeNanos);
        } else {
            lock.writeLock().lock();
            this.updateWriteLockMetrics(resource, (ReentrantReadWriteLock)lock, startWaitingTimeNanos);
        }
    }

    private OMLockDetails acquireLocks(IOzoneManagerLock.Resource resource, boolean isReadLock, Function<Striped<ReadWriteLock>, Iterable<ReadWriteLock>> lockListProvider) {
        Pair<Map<IOzoneManagerLock.Resource, Striped<ReadWriteLock>>, ResourceLockManager> resourceLockPair = this.resourcelockMap.get(resource.getClass());
        ResourceLockManager resourceLockManager = resourceLockPair.getRight();
        resourceLockManager.clearLockDetails();
        if (!resourceLockManager.canLockResource(resource)) {
            String errorMessage = this.getErrorMessage(resource);
            LOG.error(errorMessage);
            throw new RuntimeException(errorMessage);
        }
        long startWaitingTimeNanos = Time.monotonicNowNanos();
        for (ReadWriteLock lock : lockListProvider.apply(resourceLockPair.getKey().get(resource))) {
            this.acquireLock(resource, isReadLock, lock, startWaitingTimeNanos);
        }
        return resourceLockManager.lockResource(resource);
    }

    private OMLockDetails acquireLock(IOzoneManagerLock.Resource resource, boolean isReadLock, String ... keys2) {
        Pair<Map<IOzoneManagerLock.Resource, Striped<ReadWriteLock>>, ResourceLockManager> resourceLockPair = this.resourcelockMap.get(resource.getClass());
        ResourceLockManager resourceLockManager = resourceLockPair.getRight();
        resourceLockManager.clearLockDetails();
        if (!resourceLockManager.canLockResource(resource)) {
            String errorMessage = this.getErrorMessage(resource);
            LOG.error(errorMessage);
            throw new RuntimeException(errorMessage);
        }
        long startWaitingTimeNanos = Time.monotonicNowNanos();
        ReentrantReadWriteLock lock = this.getLock(resourceLockPair.getKey(), resource, keys2);
        this.acquireLock(resource, isReadLock, lock, startWaitingTimeNanos);
        return resourceLockManager.lockResource(resource);
    }

    private void updateReadLockMetrics(IOzoneManagerLock.Resource resource, ReentrantReadWriteLock lock, long startWaitingTimeNanos) {
        if (lock.getReadHoldCount() == 1) {
            long readLockWaitingTimeNanos = Time.monotonicNowNanos() - startWaitingTimeNanos;
            this.omLockMetrics.setReadLockWaitingTimeMsStat(TimeUnit.NANOSECONDS.toMillis(readLockWaitingTimeNanos));
            this.updateProcessingDetails(this.resourcelockMap.get(resource.getClass()).getValue(), ProcessingDetails.Timing.LOCKWAIT, readLockWaitingTimeNanos);
            resource.getResourceManager().setStartReadHeldTimeNanos(Time.monotonicNowNanos());
        }
    }

    private void updateWriteLockMetrics(IOzoneManagerLock.Resource resource, ReentrantReadWriteLock lock, long startWaitingTimeNanos) {
        if (lock.getWriteHoldCount() == 1 && lock.isWriteLockedByCurrentThread()) {
            long writeLockWaitingTimeNanos = Time.monotonicNowNanos() - startWaitingTimeNanos;
            this.omLockMetrics.setWriteLockWaitingTimeMsStat(TimeUnit.NANOSECONDS.toMillis(writeLockWaitingTimeNanos));
            this.updateProcessingDetails(this.resourcelockMap.get(resource.getClass()).getValue(), ProcessingDetails.Timing.LOCKWAIT, writeLockWaitingTimeNanos);
            resource.getResourceManager().setStartWriteHeldTimeNanos(Time.monotonicNowNanos());
        }
    }

    private String getErrorMessage(IOzoneManagerLock.Resource resource) {
        return "Thread '" + Thread.currentThread().getName() + "' cannot acquire " + resource.getName() + " lock while holding " + this.getCurrentLocks().toString() + " lock(s).";
    }

    @VisibleForTesting
    List<String> getCurrentLocks() {
        return this.resourcelockMap.values().stream().map(Pair::getValue).flatMap(rlm -> rlm.getCurrentLockedResources()).map(IOzoneManagerLock.Resource::getName).collect(Collectors.toList());
    }

    @Override
    public boolean acquireMultiUserLock(String firstUser, String secondUser) {
        return this.acquireWriteLocks(LeveledResource.USER_LOCK, Arrays.asList({firstUser}, {secondUser})).isLockAcquired();
    }

    @Override
    public void releaseMultiUserLock(String firstUser, String secondUser) {
        this.releaseWriteLocks(LeveledResource.USER_LOCK, Arrays.asList({firstUser}, {secondUser}));
    }

    @Override
    public OMLockDetails releaseWriteLock(IOzoneManagerLock.Resource resource, String ... keys2) {
        return this.releaseLock(resource, false, keys2);
    }

    @Override
    public OMLockDetails releaseWriteLocks(IOzoneManagerLock.Resource resource, Collection<String[]> keys2) {
        return this.releaseLocks(resource, false, striped -> this.bulkGetLock((Striped<ReadWriteLock>)striped, keys2));
    }

    @Override
    public OMLockDetails releaseResourceWriteLock(IOzoneManagerLock.Resource resource) {
        return this.releaseLocks(resource, false, this::getAllLocks);
    }

    @Override
    public OMLockDetails releaseReadLock(IOzoneManagerLock.Resource resource, String ... keys2) {
        return this.releaseLock(resource, true, keys2);
    }

    @Override
    public OMLockDetails releaseReadLocks(IOzoneManagerLock.Resource resource, Collection<String[]> keys2) {
        return this.releaseLocks(resource, true, striped -> this.bulkGetLock((Striped<ReadWriteLock>)striped, keys2));
    }

    private OMLockDetails releaseLock(IOzoneManagerLock.Resource resource, boolean isReadLock, String ... keys2) {
        Pair<Map<IOzoneManagerLock.Resource, Striped<ReadWriteLock>>, ResourceLockManager> resourceLockPair = this.resourcelockMap.get(resource.getClass());
        ResourceLockManager resourceLockManager = resourceLockPair.getRight();
        resourceLockManager.clearLockDetails();
        ReentrantReadWriteLock lock = this.getLock(resourceLockPair.getKey(), resource, keys2);
        if (isReadLock) {
            lock.readLock().unlock();
            this.updateReadUnlockMetrics(resource, lock);
        } else {
            boolean isWriteLocked = lock.isWriteLockedByCurrentThread();
            lock.writeLock().unlock();
            this.updateWriteUnlockMetrics(resource, lock, isWriteLocked);
        }
        return resourceLockManager.unlockResource(resource);
    }

    private OMLockDetails releaseLocks(IOzoneManagerLock.Resource resource, boolean isReadLock, Function<Striped<ReadWriteLock>, Iterable<ReadWriteLock>> lockListProvider) {
        Pair<Map<IOzoneManagerLock.Resource, Striped<ReadWriteLock>>, ResourceLockManager> resourceLockPair = this.resourcelockMap.get(resource.getClass());
        ResourceLockManager resourceLockManager = resourceLockPair.getRight();
        resourceLockManager.clearLockDetails();
        List locks = StreamSupport.stream(lockListProvider.apply(resourceLockPair.getKey().get(resource)).spliterator(), false).collect(Collectors.toList());
        Collections.reverse(locks);
        for (ReadWriteLock lock : locks) {
            if (isReadLock) {
                lock.readLock().unlock();
                this.updateReadUnlockMetrics(resource, (ReentrantReadWriteLock)lock);
                continue;
            }
            boolean isWriteLocked = ((ReentrantReadWriteLock)lock).isWriteLockedByCurrentThread();
            lock.writeLock().unlock();
            this.updateWriteUnlockMetrics(resource, (ReentrantReadWriteLock)lock, isWriteLocked);
        }
        return resourceLockManager.unlockResource(resource);
    }

    private void updateReadUnlockMetrics(IOzoneManagerLock.Resource resource, ReentrantReadWriteLock lock) {
        if (lock.getReadHoldCount() == 0) {
            long readLockHeldTimeNanos = Time.monotonicNowNanos() - resource.getResourceManager().getStartReadHeldTimeNanos();
            this.omLockMetrics.setReadLockHeldTimeMsStat(TimeUnit.NANOSECONDS.toMillis(readLockHeldTimeNanos));
            this.updateProcessingDetails(this.resourcelockMap.get(resource.getClass()).getValue(), ProcessingDetails.Timing.LOCKSHARED, readLockHeldTimeNanos);
        }
    }

    private void updateWriteUnlockMetrics(IOzoneManagerLock.Resource resource, ReentrantReadWriteLock lock, boolean isWriteLocked) {
        if (lock.getWriteHoldCount() == 0 && isWriteLocked) {
            long writeLockHeldTimeNanos = Time.monotonicNowNanos() - resource.getResourceManager().getStartWriteHeldTimeNanos();
            this.omLockMetrics.setWriteLockHeldTimeMsStat(TimeUnit.NANOSECONDS.toMillis(writeLockHeldTimeNanos));
            this.updateProcessingDetails(this.resourcelockMap.get(resource.getClass()).getValue(), ProcessingDetails.Timing.LOCKEXCLUSIVE, writeLockHeldTimeNanos);
        }
    }

    @Override
    @VisibleForTesting
    public int getReadHoldCount(IOzoneManagerLock.Resource resource, String ... keys2) {
        return this.getLock(this.resourcelockMap.get(resource.getClass()).getKey(), resource, keys2).getReadHoldCount();
    }

    @Override
    @VisibleForTesting
    public int getWriteHoldCount(IOzoneManagerLock.Resource resource, String ... keys2) {
        return this.getLock(this.resourcelockMap.get(resource.getClass()).getKey(), resource, keys2).getWriteHoldCount();
    }

    @Override
    @VisibleForTesting
    public boolean isWriteLockedByCurrentThread(IOzoneManagerLock.Resource resource, String ... keys2) {
        return this.getLock(this.resourcelockMap.get(resource.getClass()).getKey(), resource, keys2).isWriteLockedByCurrentThread();
    }

    @Override
    public void cleanup() {
        this.omLockMetrics.unRegister();
    }

    @Override
    public OMLockMetrics getOMLockMetrics() {
        return this.omLockMetrics;
    }

    private void updateProcessingDetails(ResourceLockManager<? extends IOzoneManagerLock.Resource> resourceLockManager, ProcessingDetails.Timing type, long deltaNanos) {
        Server.Call call = (Server.Call)Server.getCurCall().get();
        if (call != null) {
            call.getProcessingDetails().add(type, deltaNanos, TimeUnit.NANOSECONDS);
        } else {
            switch (type) {
                case LOCKWAIT: {
                    ((OMLockDetails)((ResourceLockManager)resourceLockManager).omLockDetails.get()).add(deltaNanos, OMLockDetails.LockOpType.WAIT);
                    break;
                }
                case LOCKSHARED: {
                    ((OMLockDetails)((ResourceLockManager)resourceLockManager).omLockDetails.get()).add(deltaNanos, OMLockDetails.LockOpType.READ);
                    break;
                }
                case LOCKEXCLUSIVE: {
                    ((OMLockDetails)((ResourceLockManager)resourceLockManager).omLockDetails.get()).add(deltaNanos, OMLockDetails.LockOpType.WRITE);
                    break;
                }
                default: {
                    LOG.error("Unsupported Timing type {}", (Object)type);
                }
            }
        }
    }

    public static enum LeveledResource implements IOzoneManagerLock.Resource
    {
        S3_BUCKET_LOCK(0, "S3_BUCKET_LOCK"),
        VOLUME_LOCK(1, "VOLUME_LOCK"),
        BUCKET_LOCK(2, "BUCKET_LOCK"),
        USER_LOCK(3, "USER_LOCK"),
        S3_SECRET_LOCK(4, "S3_SECRET_LOCK"),
        KEY_PATH_LOCK(5, "KEY_PATH_LOCK"),
        PREFIX_LOCK(6, "PREFIX_LOCK"),
        SNAPSHOT_LOCK(7, "SNAPSHOT_LOCK");

        private short mask;
        private short setMask;
        private String name;
        private IOzoneManagerLock.ResourceManager resourceManager;

        private LeveledResource(byte pos, String name) {
            this.mask = (short)(Math.pow(2.0, pos + 1) - 1.0);
            this.setMask = (short)Math.pow(2.0, pos);
            this.name = name;
            this.resourceManager = new IOzoneManagerLock.ResourceManager();
        }

        boolean canLock(short lockSetVal) {
            if (((LeveledResource.USER_LOCK.setMask & lockSetVal) == LeveledResource.USER_LOCK.setMask || (LeveledResource.S3_SECRET_LOCK.setMask & lockSetVal) == LeveledResource.S3_SECRET_LOCK.setMask || (LeveledResource.PREFIX_LOCK.setMask & lockSetVal) == LeveledResource.PREFIX_LOCK.setMask) && this.setMask <= lockSetVal) {
                return false;
            }
            return lockSetVal <= this.mask;
        }

        short setLock(short lockSetVal) {
            return (short)(lockSetVal | this.setMask);
        }

        short clearLock(short lockSetVal) {
            return (short)(lockSetVal & ~this.setMask);
        }

        boolean isLevelLocked(short lockSetVal) {
            return (lockSetVal & this.setMask) == this.setMask;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public IOzoneManagerLock.ResourceManager getResourceManager() {
            return this.resourceManager;
        }

        short getMask() {
            return this.mask;
        }
    }

    private static final class LeveledResourceLockManager
    extends ResourceLockManager<LeveledResource> {
        private final ThreadLocal<Short> lockSet = ThreadLocal.withInitial(() -> (short)0);

        private LeveledResourceLockManager() {
        }

        @Override
        public boolean canLockResource(LeveledResource resource) {
            return resource.canLock(this.lockSet.get());
        }

        @Override
        Stream<LeveledResource> getCurrentLockedResources() {
            short lockSetVal = this.lockSet.get();
            return Arrays.stream(LeveledResource.values()).filter(leveledResource -> leveledResource.isLevelLocked(lockSetVal));
        }

        @Override
        public OMLockDetails unlockResource(LeveledResource resource) {
            this.lockSet.set(resource.clearLock(this.lockSet.get()));
            return super.unlockResource(resource);
        }

        @Override
        public OMLockDetails lockResource(LeveledResource resource) {
            this.lockSet.set(resource.setLock(this.lockSet.get()));
            return super.lockResource(resource);
        }
    }

    private static final class FlatResourceLockManager
    extends ResourceLockManager<FlatResource> {
        private EnumMap<FlatResource, ThreadLocal<Boolean>> acquiredLocksMap = new EnumMap(FlatResource.class);

        private FlatResourceLockManager() {
            for (FlatResource flatResource : FlatResource.values()) {
                this.acquiredLocksMap.put(flatResource, ThreadLocal.withInitial(() -> Boolean.FALSE));
            }
        }

        @Override
        OMLockDetails lockResource(FlatResource resource) {
            this.acquiredLocksMap.get(resource).set(Boolean.TRUE);
            return super.lockResource(resource);
        }

        @Override
        OMLockDetails unlockResource(FlatResource resource) {
            this.acquiredLocksMap.get(resource).set(Boolean.FALSE);
            return super.unlockResource(resource);
        }

        @Override
        public boolean canLockResource(FlatResource resource) {
            return true;
        }

        @Override
        Stream<FlatResource> getCurrentLockedResources() {
            return this.acquiredLocksMap.keySet().stream().filter(flatResource -> this.acquiredLocksMap.get(flatResource).get());
        }
    }

    private static abstract class ResourceLockManager<T extends IOzoneManagerLock.Resource> {
        private final ThreadLocal<OMLockDetails> omLockDetails = ThreadLocal.withInitial(OMLockDetails::new);

        private ResourceLockManager() {
        }

        abstract boolean canLockResource(T var1);

        abstract Stream<T> getCurrentLockedResources();

        OMLockDetails clearLockDetails() {
            this.omLockDetails.get().clear();
            return this.omLockDetails.get();
        }

        OMLockDetails unlockResource(T resource) {
            return this.omLockDetails.get();
        }

        OMLockDetails lockResource(T resource) {
            this.omLockDetails.get().setLockAcquired(true);
            return this.omLockDetails.get();
        }
    }
}

