/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import org.apache.ozone.shaded.com.google.common.base.Preconditions;

public class OmTenantArgs {
    private final String tenantId;
    private final String volumeName;
    private boolean forceCreationWhenVolumeExists;

    public OmTenantArgs(String tenantId) {
        this.volumeName = this.tenantId = tenantId;
    }

    public OmTenantArgs(String tenantId, String volumeName) {
        this.tenantId = tenantId;
        this.volumeName = volumeName;
    }

    public OmTenantArgs(String tenantId, String volumeName, boolean forceCreationWhenVolumeExists) {
        this.tenantId = tenantId;
        this.volumeName = volumeName;
        this.forceCreationWhenVolumeExists = forceCreationWhenVolumeExists;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public boolean getForceCreationWhenVolumeExists() {
        return this.forceCreationWhenVolumeExists;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String tenantId;
        private String volumeName;
        private boolean forceCreationWhenVolumeExists;

        public Builder setTenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder setVolumeName(String volumeName) {
            this.volumeName = volumeName;
            return this;
        }

        public Builder setForceCreationWhenVolumeExists(boolean forceCreationWhenVolumeExists) {
            this.forceCreationWhenVolumeExists = forceCreationWhenVolumeExists;
            return this;
        }

        public OmTenantArgs build() {
            Preconditions.checkNotNull(this.tenantId);
            Preconditions.checkNotNull(this.volumeName);
            return new OmTenantArgs(this.tenantId, this.volumeName, this.forceCreationWhenVolumeExists);
        }
    }
}

