/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.Proto2Codec;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public final class OmDBAccessIdInfo {
    private static final Codec<OmDBAccessIdInfo> CODEC = new DelegatedCodec<OmDBAccessIdInfo, OzoneManagerProtocolProtos.ExtendedUserAccessIdInfo>(Proto2Codec.get(OzoneManagerProtocolProtos.ExtendedUserAccessIdInfo.getDefaultInstance()), OmDBAccessIdInfo::getFromProtobuf, OmDBAccessIdInfo::getProtobuf, OmDBAccessIdInfo.class, DelegatedCodec.CopyType.SHALLOW);
    private final String tenantId;
    private final String userPrincipal;
    private final boolean isAdmin;
    private final boolean isDelegatedAdmin;

    public OmDBAccessIdInfo(String tenantId, String userPrincipal, boolean isAdmin, boolean isDelegatedAdmin) {
        this.tenantId = tenantId;
        this.userPrincipal = userPrincipal;
        this.isAdmin = isAdmin;
        this.isDelegatedAdmin = isDelegatedAdmin;
    }

    public static Codec<OmDBAccessIdInfo> getCodec() {
        return CODEC;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public OzoneManagerProtocolProtos.ExtendedUserAccessIdInfo getProtobuf() {
        return OzoneManagerProtocolProtos.ExtendedUserAccessIdInfo.newBuilder().setTenantId(this.tenantId).setUserPrincipal(this.userPrincipal).setIsAdmin(this.isAdmin).setIsDelegatedAdmin(this.isDelegatedAdmin).build();
    }

    public static OmDBAccessIdInfo getFromProtobuf(OzoneManagerProtocolProtos.ExtendedUserAccessIdInfo infoProto) {
        return new Builder().setTenantId(infoProto.getTenantId()).setUserPrincipal(infoProto.getUserPrincipal()).setIsAdmin(infoProto.getIsAdmin()).setIsDelegatedAdmin(infoProto.getIsDelegatedAdmin()).build();
    }

    public String getUserPrincipal() {
        return this.userPrincipal;
    }

    public boolean getIsAdmin() {
        return this.isAdmin;
    }

    public boolean getIsDelegatedAdmin() {
        return this.isDelegatedAdmin;
    }

    public static final class Builder {
        private String tenantId;
        private String userPrincipal;
        private boolean isAdmin;
        private boolean isDelegatedAdmin;

        public Builder setTenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder setUserPrincipal(String userPrincipal) {
            this.userPrincipal = userPrincipal;
            return this;
        }

        public Builder setIsAdmin(boolean isAdmin) {
            this.isAdmin = isAdmin;
            return this;
        }

        public Builder setIsDelegatedAdmin(boolean isDelegatedAdmin) {
            this.isDelegatedAdmin = isDelegatedAdmin;
            return this;
        }

        public OmDBAccessIdInfo build() {
            return new OmDBAccessIdInfo(this.tenantId, this.userPrincipal, this.isAdmin, this.isDelegatedAdmin);
        }
    }
}

