/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.ozone.common.ChecksumByteBuffer;
import org.apache.hadoop.ozone.common.ChecksumByteBufferFactory;
import org.apache.hadoop.ozone.common.ChecksumCache;
import org.apache.hadoop.ozone.common.ChecksumData;
import org.apache.hadoop.ozone.common.ChunkBuffer;
import org.apache.hadoop.ozone.common.OzoneChecksumException;
import org.apache.hadoop.ozone.common.utils.BufferUtils;
import org.apache.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.ozone.shaded.com.google.common.primitives.Ints;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Checksum {
    private static final Logger LOG = LoggerFactory.getLogger(Checksum.class);
    private final ContainerProtos.ChecksumType checksumType;
    private final int bytesPerChecksum;
    private final ChecksumCache checksumCache;

    private static Function<ByteBuffer, ByteString> newMessageDigestFunction(String algorithm) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Failed to get MessageDigest for " + algorithm, e);
        }
        return data -> {
            md.reset();
            md.update((ByteBuffer)data);
            return ByteString.copyFrom(md.digest());
        };
    }

    public static ByteString int2ByteString(int n) {
        return UnsafeByteOperations.unsafeWrap(Ints.toByteArray(n));
    }

    private static Function<ByteBuffer, ByteString> newChecksumByteBufferFunction(Supplier<ChecksumByteBuffer> constructor) {
        ChecksumByteBuffer algorithm = constructor.get();
        return data -> {
            algorithm.reset();
            algorithm.update((ByteBuffer)data);
            return Checksum.int2ByteString((int)algorithm.getValue());
        };
    }

    public boolean clearChecksumCache() {
        if (this.checksumCache != null) {
            this.checksumCache.clear();
            return true;
        }
        return false;
    }

    public Checksum(ContainerProtos.ChecksumType type, int bytesPerChecksum) {
        this.checksumType = type;
        this.bytesPerChecksum = bytesPerChecksum;
        this.checksumCache = null;
    }

    public Checksum(ContainerProtos.ChecksumType type, int bytesPerChecksum, boolean allowChecksumCache) {
        this.checksumType = type;
        this.bytesPerChecksum = bytesPerChecksum;
        LOG.debug("allowChecksumCache = {}", (Object)allowChecksumCache);
        this.checksumCache = allowChecksumCache ? new ChecksumCache(bytesPerChecksum) : null;
    }

    public ChecksumData computeChecksum(byte[] data, int off, int len) throws OzoneChecksumException {
        return this.computeChecksum(ByteBuffer.wrap(data, off, len));
    }

    public ChecksumData computeChecksum(byte[] data) throws OzoneChecksumException {
        return this.computeChecksum(ByteBuffer.wrap(data));
    }

    public ChecksumData computeChecksum(ByteBuffer data) throws OzoneChecksumException {
        return this.computeChecksum(data, false);
    }

    public ChecksumData computeChecksum(ByteBuffer data, boolean useChecksumCache) throws OzoneChecksumException {
        if (this.checksumType == ContainerProtos.ChecksumType.NONE) {
            return new ChecksumData(this.checksumType, this.bytesPerChecksum);
        }
        if (!data.isReadOnly()) {
            data = data.asReadOnlyBuffer();
        }
        return this.computeChecksum(ChunkBuffer.wrap(data), useChecksumCache);
    }

    public ChecksumData computeChecksum(List<ByteString> byteStrings) throws OzoneChecksumException {
        List<ByteBuffer> buffers = BufferUtils.getReadOnlyByteBuffers(byteStrings);
        return this.computeChecksum(ChunkBuffer.wrap(buffers));
    }

    public ChecksumData computeChecksum(ChunkBuffer data) throws OzoneChecksumException {
        return this.computeChecksum(data, false);
    }

    public ChecksumData computeChecksum(ChunkBuffer data, boolean useCache) throws OzoneChecksumException {
        ArrayList<ByteString> checksumList;
        Function<ByteBuffer, ByteString> function;
        if (this.checksumType == ContainerProtos.ChecksumType.NONE) {
            return new ChecksumData(this.checksumType, this.bytesPerChecksum);
        }
        try {
            function = Algorithm.valueOf(this.checksumType).newChecksumFunction();
        }
        catch (Exception e) {
            throw new OzoneChecksumException("Failed to get the checksum function for " + this.checksumType, e);
        }
        if (this.checksumCache == null || !useCache) {
            checksumList = new ArrayList();
            for (ByteBuffer b : data.iterate(this.bytesPerChecksum)) {
                checksumList.add(Checksum.computeChecksum(b, function, this.bytesPerChecksum));
            }
        } else {
            checksumList = this.checksumCache.computeChecksum(data, function);
        }
        return new ChecksumData(this.checksumType, this.bytesPerChecksum, checksumList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ByteString computeChecksum(ByteBuffer data, Function<ByteBuffer, ByteString> function, int maxLength) {
        int limit = data.limit();
        try {
            int maxIndex = data.position() + maxLength;
            if (limit > maxIndex) {
                data.limit(maxIndex);
            }
            ByteString byteString = function.apply(data);
            return byteString;
        }
        finally {
            data.limit(limit);
        }
    }

    public static void verifyChecksum(ByteBuffer data, ChecksumData checksumData, int startIndex) throws OzoneChecksumException {
        Checksum.verifyChecksum(ChunkBuffer.wrap(data), checksumData, startIndex);
    }

    public static void verifyChecksum(ChunkBuffer data, ChecksumData checksumData, int startIndex) throws OzoneChecksumException {
        ContainerProtos.ChecksumType checksumType = checksumData.getChecksumType();
        if (checksumType == ContainerProtos.ChecksumType.NONE) {
            return;
        }
        int bytesPerChecksum = checksumData.getBytesPerChecksum();
        Checksum checksum = new Checksum(checksumType, bytesPerChecksum);
        ChecksumData computed = checksum.computeChecksum(data);
        checksumData.verifyChecksumDataMatches(startIndex, computed);
    }

    public static void verifyChecksum(List<ByteString> byteStrings, ChecksumData checksumData, int startIndex) throws OzoneChecksumException {
        ContainerProtos.ChecksumType checksumType = checksumData.getChecksumType();
        if (checksumType == ContainerProtos.ChecksumType.NONE) {
            return;
        }
        if (byteStrings.size() == 1) {
            Checksum.verifyChecksum(byteStrings.get(0).asReadOnlyByteBuffer(), checksumData, startIndex);
            return;
        }
        List<ByteBuffer> buffers = BufferUtils.getReadOnlyByteBuffers(byteStrings);
        int bytesPerChecksum = checksumData.getBytesPerChecksum();
        Checksum checksum = new Checksum(checksumType, bytesPerChecksum);
        ChecksumData computed = checksum.computeChecksum(ChunkBuffer.wrap(buffers));
        checksumData.verifyChecksumDataMatches(startIndex, computed);
    }

    @VisibleForTesting
    public static ContainerProtos.ChecksumData getNoChecksumDataProto() {
        return new ChecksumData(ContainerProtos.ChecksumType.NONE, 0).getProtoBufMessage();
    }

    static enum Algorithm {
        NONE(() -> data -> ByteString.EMPTY),
        CRC32(() -> Checksum.access$100(ChecksumByteBufferFactory::crc32Impl)),
        CRC32C(() -> Checksum.access$100(ChecksumByteBufferFactory::crc32CImpl)),
        SHA256(() -> Checksum.access$000("SHA-256")),
        MD5(() -> Checksum.access$000("MD5"));

        private final Supplier<Function<ByteBuffer, ByteString>> constructor;

        static Algorithm valueOf(ContainerProtos.ChecksumType type) {
            return Algorithm.valueOf(type.name());
        }

        private Algorithm(Supplier<Function<ByteBuffer, ByteString>> constructor) {
            this.constructor = constructor;
        }

        Function<ByteBuffer, ByteString> newChecksumFunction() {
            return this.constructor.get();
        }
    }
}

