/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.s3.tenant;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.S3SecretManager;
import org.apache.hadoop.ozone.om.helpers.OmDBUserPrincipalInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"s3SecretTable", "tenantAccessIdTable", "principalToAccessIdsTable"})
public class OMTenantRevokeUserAccessIdResponse
extends OMClientResponse {
    private String principal;
    private String accessId;
    private OmDBUserPrincipalInfo omDBUserPrincipalInfo;
    private S3SecretManager s3SecretManager;

    public OMTenantRevokeUserAccessIdResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull String accessId, @Nonnull String principal, @Nonnull OmDBUserPrincipalInfo omDBUserPrincipalInfo, @Nonnull S3SecretManager s3SecretManager) {
        super(omResponse);
        this.principal = principal;
        this.accessId = accessId;
        this.omDBUserPrincipalInfo = omDBUserPrincipalInfo;
        this.s3SecretManager = s3SecretManager;
    }

    public OMTenantRevokeUserAccessIdResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        assert (this.accessId != null);
        if (this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.OK) {
            if (this.s3SecretManager.isBatchSupported()) {
                this.s3SecretManager.batcher().deleteWithBatch((AutoCloseable)batchOperation, this.accessId);
            } else {
                this.s3SecretManager.revokeSecret(this.accessId);
            }
        }
        omMetadataManager.getTenantAccessIdTable().deleteWithBatch(batchOperation, (Object)this.accessId);
        if (!this.omDBUserPrincipalInfo.getAccessIds().isEmpty()) {
            omMetadataManager.getPrincipalToAccessIdsTable().putWithBatch(batchOperation, (Object)this.principal, (Object)this.omDBUserPrincipalInfo);
        } else {
            omMetadataManager.getPrincipalToAccessIdsTable().deleteWithBatch(batchOperation, (Object)this.principal);
        }
    }
}

