/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.client.ContainerBlockID;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.AllocatedBlock;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenSecretManager;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OmConfig;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.PrefixManager;
import org.apache.hadoop.ozone.om.ResolvedBucket;
import org.apache.hadoop.ozone.om.ScmClient;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketEncryptionKeyInfo;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.KeyValueUtil;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OmPrefixInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.helpers.QuotaUtil;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OzoneLockStrategy;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.OMClientRequestUtils;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OMKeyRequest
extends OMClientRequest {
    private static final long MAX_NUM_OF_RECURSIVE_DIRS = 255L;
    protected static final Logger LOG = LoggerFactory.getLogger(OMKeyRequest.class);
    private BucketLayout bucketLayout = BucketLayout.DEFAULT;

    public OMKeyRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    public OMKeyRequest(OzoneManagerProtocolProtos.OMRequest omRequest, BucketLayout bucketLayoutArg) {
        super(omRequest);
        this.bucketLayout = bucketLayoutArg;
    }

    public BucketLayout getBucketLayout() {
        return this.bucketLayout;
    }

    protected OzoneManagerProtocolProtos.KeyArgs resolveBucketLink(OzoneManager ozoneManager, OzoneManagerProtocolProtos.KeyArgs keyArgs, Map<String, String> auditMap) throws IOException {
        ResolvedBucket bucket = ozoneManager.resolveBucketLink(keyArgs, (OMClientRequest)this);
        keyArgs = bucket.update(keyArgs);
        bucket.audit(auditMap);
        return keyArgs;
    }

    protected OzoneManagerProtocolProtos.KeyArgs resolveBucketLink(OzoneManager ozoneManager, OzoneManagerProtocolProtos.KeyArgs keyArgs) throws IOException {
        ResolvedBucket bucket = ozoneManager.resolveBucketLink(keyArgs, (OMClientRequest)this);
        keyArgs = bucket.update(keyArgs);
        return keyArgs;
    }

    protected OzoneManagerProtocolProtos.KeyArgs resolveBucketAndCheckKeyAcls(OzoneManagerProtocolProtos.KeyArgs keyArgs, OzoneManager ozoneManager, IAccessAuthorizer.ACLType aclType) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs resolvedArgs = this.resolveBucketLink(ozoneManager, keyArgs);
        this.checkKeyAcls(ozoneManager, resolvedArgs.getVolumeName(), resolvedArgs.getBucketName(), keyArgs.getKeyName(), aclType, OzoneObj.ResourceType.KEY);
        return resolvedArgs;
    }

    protected OzoneManagerProtocolProtos.KeyArgs resolveBucketAndCheckKeyAclsWithFSO(OzoneManagerProtocolProtos.KeyArgs keyArgs, OzoneManager ozoneManager, IAccessAuthorizer.ACLType aclType) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs resolvedArgs = this.resolveBucketLink(ozoneManager, keyArgs);
        this.checkACLsWithFSO(ozoneManager, resolvedArgs.getVolumeName(), resolvedArgs.getBucketName(), keyArgs.getKeyName(), aclType);
        return resolvedArgs;
    }

    protected OzoneManagerProtocolProtos.KeyArgs resolveBucketAndCheckOpenKeyAcls(OzoneManagerProtocolProtos.KeyArgs keyArgs, OzoneManager ozoneManager, IAccessAuthorizer.ACLType aclType, long clientId) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs resolvedArgs = this.resolveBucketLink(ozoneManager, keyArgs);
        this.checkKeyAclsInOpenKeyTable(ozoneManager, resolvedArgs.getVolumeName(), resolvedArgs.getBucketName(), keyArgs.getKeyName(), aclType, clientId);
        return resolvedArgs;
    }

    protected List<OmKeyLocationInfo> allocateBlock(ScmClient scmClient, OzoneBlockTokenSecretManager secretManager, ReplicationConfig replicationConfig, ExcludeList excludeList, long requestedSize, long scmBlockSize, int preallocateBlocksMax, boolean grpcBlockTokenEnabled, String serviceID, OMMetrics omMetrics, boolean shouldSortDatanodes, OzoneManagerProtocolProtos.UserInfo userInfo) throws IOException {
        List allocatedBlocks;
        int dataGroupSize = replicationConfig instanceof ECReplicationConfig ? ((ECReplicationConfig)replicationConfig).getData() : 1;
        int numBlocks = (int)Math.min((long)preallocateBlocksMax, (requestedSize - 1L) / (scmBlockSize * (long)dataGroupSize) + 1L);
        String clientMachine = "";
        if (shouldSortDatanodes) {
            clientMachine = userInfo.getRemoteAddress();
        }
        ArrayList<OmKeyLocationInfo> locationInfos = new ArrayList<OmKeyLocationInfo>(numBlocks);
        String remoteUser = this.getRemoteUser().getShortUserName();
        try {
            allocatedBlocks = scmClient.getBlockClient().allocateBlock(scmBlockSize, numBlocks, replicationConfig, serviceID, excludeList, clientMachine);
        }
        catch (SCMException ex) {
            omMetrics.incNumBlockAllocateCallFails();
            if (ex.getResult().equals((Object)SCMException.ResultCodes.SAFE_MODE_EXCEPTION)) {
                throw new OMException(ex.getMessage(), OMException.ResultCodes.SCM_IN_SAFE_MODE);
            }
            throw ex;
        }
        for (AllocatedBlock allocatedBlock : allocatedBlocks) {
            BlockID blockID = new BlockID(allocatedBlock.getBlockID());
            OmKeyLocationInfo.Builder builder = new OmKeyLocationInfo.Builder().setBlockID(blockID).setLength(scmBlockSize).setOffset(0L).setPipeline(allocatedBlock.getPipeline());
            if (grpcBlockTokenEnabled) {
                builder.setToken(secretManager.generateToken(remoteUser, blockID, EnumSet.of(HddsProtos.BlockTokenSecretProto.AccessModeProto.READ, HddsProtos.BlockTokenSecretProto.AccessModeProto.WRITE), scmBlockSize));
            }
            locationInfos.add(builder.build());
        }
        return locationInfos;
    }

    protected UserGroupInformation getRemoteUser() throws IOException {
        UserGroupInformation ugi = Server.getRemoteUser();
        return ugi != null ? ugi : UserGroupInformation.getCurrentUser();
    }

    public void validateBucketAndVolume(OMMetadataManager omMetadataManager, String volumeName, String bucketName) throws IOException {
        String bucketKey = omMetadataManager.getBucketKey(volumeName, bucketName);
        if (!omMetadataManager.getBucketTable().isExist((Object)bucketKey)) {
            String volumeKey = omMetadataManager.getVolumeKey(volumeName);
            if (!omMetadataManager.getVolumeTable().isExist((Object)volumeKey)) {
                throw new OMException("Volume not found " + volumeName, OMException.ResultCodes.VOLUME_NOT_FOUND);
            }
            throw new OMException("Bucket not found " + bucketName, OMException.ResultCodes.BUCKET_NOT_FOUND);
        }
        OMClientRequestUtils.checkClientRequestPrecondition(((OmBucketInfo)omMetadataManager.getBucketTable().get((Object)bucketKey)).getBucketLayout(), this.getBucketLayout());
    }

    protected String getVolumeOwner(OMMetadataManager omMetadataManager, String volumeName) throws IOException {
        String dbVolumeKey = omMetadataManager.getVolumeKey(volumeName);
        OmVolumeArgs volumeArgs = (OmVolumeArgs)omMetadataManager.getVolumeTable().get((Object)dbVolumeKey);
        if (volumeArgs == null) {
            throw new OMException("Volume not found " + volumeName, OMException.ResultCodes.VOLUME_NOT_FOUND);
        }
        return volumeArgs.getOwnerName();
    }

    protected static Optional<FileEncryptionInfo> getFileEncryptionInfo(OzoneManager ozoneManager, OmBucketInfo bucketInfo) throws IOException {
        Optional<FileEncryptionInfo> encInfo = Optional.empty();
        BucketEncryptionKeyInfo ezInfo = bucketInfo.getEncryptionKeyInfo();
        if (ezInfo != null) {
            String ezKeyName = ezInfo.getKeyName();
            KeyProviderCryptoExtension.EncryptedKeyVersion edek = OMKeyRequest.generateEDEK(ozoneManager, ezKeyName);
            encInfo = Optional.of(new FileEncryptionInfo(ezInfo.getSuite(), ezInfo.getVersion(), edek.getEncryptedKeyVersion().getMaterial(), edek.getEncryptedKeyIv(), ezKeyName, edek.getEncryptionKeyVersionName()));
        }
        return encInfo;
    }

    private static KeyProviderCryptoExtension.EncryptedKeyVersion generateEDEK(final OzoneManager ozoneManager, final String ezKeyName) throws IOException {
        if (ezKeyName == null) {
            return null;
        }
        long generateEDEKStartTime = Time.monotonicNow();
        KeyProviderCryptoExtension.EncryptedKeyVersion edek = (KeyProviderCryptoExtension.EncryptedKeyVersion)SecurityUtil.doAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<KeyProviderCryptoExtension.EncryptedKeyVersion>(){

            @Override
            public KeyProviderCryptoExtension.EncryptedKeyVersion run() throws IOException {
                try {
                    return ozoneManager.getKmsProvider().generateEncryptedKey(ezKeyName);
                }
                catch (GeneralSecurityException e) {
                    throw new IOException(e);
                }
            }
        });
        long generateEDEKTime = Time.monotonicNow() - generateEDEKStartTime;
        LOG.debug("generateEDEK takes {} ms", (Object)generateEDEKTime);
        Preconditions.checkNotNull((Object)edek);
        return edek;
    }

    protected List<OzoneAcl> getAclsForKey(OzoneManagerProtocolProtos.KeyArgs keyArgs, OmBucketInfo bucketInfo, OMFileRequest.OMPathInfo omPathInfo, PrefixManager prefixManager, OmConfig config) throws OMException {
        OmPrefixInfo prefixInfo;
        List<OmPrefixInfo> prefixList;
        ArrayList<OzoneAcl> acls = new ArrayList();
        acls.addAll(OzoneAclUtil.getDefaultAclList((UserGroupInformation)this.createUGIForApi(), (OmConfig)config));
        if (keyArgs.getAclsList() != null) {
            acls.addAll(OzoneAclUtil.fromProtobuf((List)keyArgs.getAclsList()));
        }
        if (prefixManager != null && !(prefixList = prefixManager.getLongestPrefixPath("/" + keyArgs.getVolumeName() + "/" + keyArgs.getBucketName() + "/" + keyArgs.getKeyName())).isEmpty() && (prefixInfo = prefixList.get(prefixList.size() - 1)) != null && OzoneAclUtil.inheritDefaultAcls(acls, (List)prefixInfo.getAcls(), (OzoneAcl.AclScope)OzoneAcl.AclScope.ACCESS)) {
            acls = acls.stream().distinct().collect(Collectors.toList());
            return acls;
        }
        if (omPathInfo != null && OzoneAclUtil.inheritDefaultAcls(acls, omPathInfo.getAcls(), (OzoneAcl.AclScope)OzoneAcl.AclScope.ACCESS)) {
            acls = acls.stream().distinct().collect(Collectors.toList());
            return acls;
        }
        if (bucketInfo != null && OzoneAclUtil.inheritDefaultAcls(acls, (List)bucketInfo.getAcls(), (OzoneAcl.AclScope)OzoneAcl.AclScope.ACCESS)) {
            acls = acls.stream().distinct().collect(Collectors.toList());
            return acls;
        }
        acls = acls.stream().distinct().collect(Collectors.toList());
        return acls;
    }

    protected List<OzoneAcl> getAclsForDir(OzoneManagerProtocolProtos.KeyArgs keyArgs, OmBucketInfo bucketInfo, OMFileRequest.OMPathInfo omPathInfo, OmConfig config) throws OMException {
        ArrayList<OzoneAcl> acls = new ArrayList();
        acls.addAll(OzoneAclUtil.getDefaultAclList((UserGroupInformation)this.createUGIForApi(), (OmConfig)config));
        if (omPathInfo != null) {
            OzoneAclUtil.inheritDefaultAcls(acls, omPathInfo.getAcls(), (OzoneAcl.AclScope)OzoneAcl.AclScope.DEFAULT);
        }
        if (acls.isEmpty() && bucketInfo != null) {
            OzoneAclUtil.inheritDefaultAcls(acls, (List)bucketInfo.getAcls(), (OzoneAcl.AclScope)OzoneAcl.AclScope.DEFAULT);
        }
        acls.addAll(OzoneAclUtil.fromProtobuf((List)keyArgs.getAclsList()));
        acls = acls.stream().distinct().collect(Collectors.toList());
        return acls;
    }

    protected List<OmDirectoryInfo> getAllMissingParentDirInfo(OzoneManager ozoneManager, OzoneManagerProtocolProtos.KeyArgs keyArgs, OmBucketInfo bucketInfo, OMFileRequest.OMPathInfoWithFSO pathInfo, long trxnLogIndex) throws IOException {
        ArrayList<OmDirectoryInfo> missingParentInfos = new ArrayList<OmDirectoryInfo>();
        long baseObjId = ozoneManager.getObjectIdFromTxId(trxnLogIndex);
        long maxObjId = baseObjId + 255L;
        long objectCount = 1L;
        String volumeName = keyArgs.getVolumeName();
        String bucketName = keyArgs.getBucketName();
        String keyName = keyArgs.getKeyName();
        long lastKnownParentId = pathInfo.getLastKnownParentId();
        List<String> missingParents = pathInfo.getMissingParents();
        for (String missingKey : missingParents) {
            long nextObjId = baseObjId + objectCount;
            if (nextObjId > maxObjId) {
                throw new OMException("Too many directories in path. Exceeds limit of 255. Unable to create directory: " + keyName + " in volume/bucket: " + volumeName + "/" + bucketName, OMException.ResultCodes.INVALID_KEY_NAME);
            }
            LOG.debug("missing parent {} getting added to DirectoryTable", (Object)missingKey);
            OmDirectoryInfo dirInfo = this.createDirectoryInfoWithACL(missingKey, keyArgs, nextObjId, lastKnownParentId, trxnLogIndex, bucketInfo, pathInfo, ozoneManager.getConfig());
            ++objectCount;
            missingParentInfos.add(dirInfo);
            lastKnownParentId = nextObjId;
        }
        pathInfo.setLastKnownParentId(lastKnownParentId);
        pathInfo.setLeafNodeObjectId(baseObjId + objectCount);
        return missingParentInfos;
    }

    protected List<OmKeyInfo> getAllParentInfo(OzoneManager ozoneManager, OzoneManagerProtocolProtos.KeyArgs keyArgs, List<String> missingParents, OmBucketInfo bucketInfo, OMFileRequest.OMPathInfo omPathInfo, long trxnLogIndex) throws IOException {
        ArrayList<OmKeyInfo> missingParentInfos = new ArrayList<OmKeyInfo>();
        long baseObjId = ozoneManager.getObjectIdFromTxId(trxnLogIndex);
        long maxObjId = baseObjId + 255L;
        long objectCount = 1L;
        String volumeName = keyArgs.getVolumeName();
        String bucketName = keyArgs.getBucketName();
        String keyName = keyArgs.getKeyName();
        for (String missingKey : missingParents) {
            long nextObjId = baseObjId + objectCount;
            if (nextObjId > maxObjId) {
                throw new OMException("Too many directories in path. Exceeds limit of 255. Unable to create directory: " + keyName + " in volume/bucket: " + volumeName + "/" + bucketName, OMException.ResultCodes.INVALID_KEY_NAME);
            }
            LOG.debug("missing parent {} getting added to KeyTable", (Object)missingKey);
            OmKeyInfo parentKeyInfo = this.createDirectoryKeyInfoWithACL(missingKey, keyArgs, nextObjId, bucketInfo, omPathInfo, trxnLogIndex, ozoneManager.getDefaultReplicationConfig(), ozoneManager.getConfig());
            ++objectCount;
            missingParentInfos.add(parentKeyInfo);
        }
        return missingParentInfos;
    }

    protected OmDirectoryInfo createDirectoryInfoWithACL(String dirName, OzoneManagerProtocolProtos.KeyArgs keyArgs, long objectId, long parentObjectId, long transactionIndex, OmBucketInfo bucketInfo, OMFileRequest.OMPathInfo omPathInfo, OmConfig config) throws OMException {
        return OmDirectoryInfo.newBuilder().setName(dirName).setOwner(keyArgs.getOwnerName()).setCreationTime(keyArgs.getModificationTime()).setModificationTime(keyArgs.getModificationTime()).setObjectID(objectId).setUpdateID(transactionIndex).setParentObjectID(parentObjectId).setAcls(this.getAclsForDir(keyArgs, bucketInfo, omPathInfo, config)).build();
    }

    protected OmKeyInfo createDirectoryKeyInfoWithACL(String keyName, OzoneManagerProtocolProtos.KeyArgs keyArgs, long objectId, OmBucketInfo bucketInfo, OMFileRequest.OMPathInfo omPathInfo, long transactionIndex, ReplicationConfig serverDefaultReplConfig, OmConfig config) throws OMException {
        return this.dirKeyInfoBuilderNoACL(keyName, keyArgs, objectId, serverDefaultReplConfig).setAcls(this.getAclsForDir(keyArgs, bucketInfo, omPathInfo, config)).setUpdateID(transactionIndex).build();
    }

    protected OmKeyInfo.Builder dirKeyInfoBuilderNoACL(String keyName, OzoneManagerProtocolProtos.KeyArgs keyArgs, long objectId, ReplicationConfig serverDefaultReplConfig) {
        String dirName = OzoneFSUtils.addTrailingSlashIfNeeded((String)keyName);
        OmKeyInfo.Builder keyInfoBuilder = new OmKeyInfo.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(dirName).setOwnerName(keyArgs.getOwnerName()).setOmKeyLocationInfos(Collections.singletonList(new OmKeyLocationInfoGroup(0L, new ArrayList()))).setCreationTime(keyArgs.getModificationTime()).setModificationTime(keyArgs.getModificationTime()).setDataSize(0L);
        if (keyArgs.getFactor() != null && keyArgs.getFactor() != HddsProtos.ReplicationFactor.ZERO && keyArgs.getType() != HddsProtos.ReplicationType.EC) {
            keyInfoBuilder.setReplicationConfig(ReplicationConfig.fromProtoTypeAndFactor((HddsProtos.ReplicationType)keyArgs.getType(), (HddsProtos.ReplicationFactor)keyArgs.getFactor()));
        } else if (keyArgs.getType() == HddsProtos.ReplicationType.EC) {
            keyInfoBuilder.setReplicationConfig((ReplicationConfig)new ECReplicationConfig(keyArgs.getEcReplicationConfig()));
        } else {
            keyInfoBuilder.setReplicationConfig(serverDefaultReplConfig);
        }
        keyInfoBuilder.setObjectID(objectId);
        return keyInfoBuilder;
    }

    protected void checkBucketAcls(OzoneManager ozoneManager, String volume, String bucket, String key, IAccessAuthorizer.ACLType aclType) throws IOException {
        if (ozoneManager.getAclsEnabled()) {
            this.checkAcls(ozoneManager, OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, aclType, volume, bucket, key);
        }
    }

    protected void checkKeyAcls(OzoneManager ozoneManager, String volume, String bucket, String key, IAccessAuthorizer.ACLType aclType, OzoneObj.ResourceType resourceType) throws IOException {
        if (ozoneManager.getAclsEnabled()) {
            this.checkAcls(ozoneManager, resourceType, OzoneObj.StoreType.OZONE, aclType, volume, bucket, key);
        }
    }

    protected void checkKeyAcls(OzoneManager ozoneManager, String volume, String bucket, String key, IAccessAuthorizer.ACLType aclType, OzoneObj.ResourceType resourceType, String volumeOwner) throws IOException {
        if (ozoneManager.getAclsEnabled()) {
            this.checkAcls(ozoneManager, resourceType, OzoneObj.StoreType.OZONE, aclType, volume, bucket, key, volumeOwner, ozoneManager.getBucketOwner(volume, bucket, aclType, resourceType));
        }
    }

    protected void checkKeyAclsInOpenKeyTable(OzoneManager ozoneManager, String volume, String bucket, String key, IAccessAuthorizer.ACLType aclType, long clientId) throws IOException {
        String keyNameForAclCheck = key;
        if (ozoneManager.getAccessAuthorizer().isNative()) {
            keyNameForAclCheck = String.valueOf(key) + "/" + clientId;
        }
        this.checkKeyAcls(ozoneManager, volume, bucket, keyNameForAclCheck, aclType, OzoneObj.ResourceType.KEY);
    }

    protected void generateRequiredEncryptionInfo(OzoneManagerProtocolProtos.KeyArgs keyArgs, OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs, OzoneManager ozoneManager) throws IOException {
        String volumeName = keyArgs.getVolumeName();
        String bucketName = keyArgs.getBucketName();
        boolean acquireLock = false;
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        OmBucketInfo bucketInfo = null;
        if (ozoneManager.getKmsProvider() != null) {
            Optional<FileEncryptionInfo> encryptionInfo;
            try {
                this.mergeOmLockDetails(omMetadataManager.getLock().acquireReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                acquireLock = this.getOmLockDetails().isLockAcquired();
                bucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)omMetadataManager.getBucketKey(volumeName, bucketName));
                if (bucketInfo.isLink()) {
                    ResolvedBucket resolvedBucket = ozoneManager.resolveBucketLink((Pair<String, String>)Pair.of((Object)keyArgs.getVolumeName(), (Object)keyArgs.getBucketName()));
                    bucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)omMetadataManager.getBucketKey(resolvedBucket.realVolume(), resolvedBucket.realBucket()));
                }
            }
            catch (Throwable throwable) {
                if (acquireLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                }
                throw throwable;
            }
            if (acquireLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
            if (bucketInfo != null && (encryptionInfo = OMKeyRequest.getFileEncryptionInfo(ozoneManager, bucketInfo)).isPresent()) {
                newKeyArgs.setFileEncryptionInfo(OMPBHelper.convert((FileEncryptionInfo)encryptionInfo.get()));
            }
        }
    }

    protected void getFileEncryptionInfoForMpuKey(OzoneManagerProtocolProtos.KeyArgs keyArgs, OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs, OzoneManager ozoneManager) throws IOException {
        String volumeName = keyArgs.getVolumeName();
        String bucketName = keyArgs.getBucketName();
        boolean acquireLock = false;
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        if (ozoneManager.getKmsProvider() != null) {
            this.mergeOmLockDetails(omMetadataManager.getLock().acquireReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            acquireLock = this.getOmLockDetails().isLockAcquired();
            try {
                ResolvedBucket resolvedBucket = ozoneManager.resolveBucketLink((Pair<String, String>)Pair.of((Object)keyArgs.getVolumeName(), (Object)keyArgs.getBucketName()));
                String dbMultipartOpenKey = this.getDBMultipartOpenKey(resolvedBucket.realVolume(), resolvedBucket.realBucket(), keyArgs.getKeyName(), keyArgs.getMultipartUploadID(), omMetadataManager);
                OmKeyInfo omKeyInfo = (OmKeyInfo)omMetadataManager.getOpenKeyTable(this.getBucketLayout()).get((Object)dbMultipartOpenKey);
                if (omKeyInfo != null) {
                    if (omKeyInfo.getFileEncryptionInfo() != null) {
                        newKeyArgs.setFileEncryptionInfo(OMPBHelper.convert((FileEncryptionInfo)omKeyInfo.getFileEncryptionInfo()));
                    }
                } else {
                    LOG.warn("omKeyInfo not found. Key: " + dbMultipartOpenKey + ". The upload id " + keyArgs.getMultipartUploadID() + " may be invalid.");
                }
            }
            catch (Throwable throwable) {
                if (acquireLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                }
                throw throwable;
            }
            if (acquireLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
        }
    }

    protected FileEncryptionInfo getFileEncryptionInfo(OzoneManagerProtocolProtos.KeyArgs keyArgs) {
        FileEncryptionInfo encryptionInfo = null;
        if (keyArgs.hasFileEncryptionInfo()) {
            encryptionInfo = OMPBHelper.convert((OzoneManagerProtocolProtos.FileEncryptionInfoProto)keyArgs.getFileEncryptionInfo());
        }
        return encryptionInfo;
    }

    protected void checkBucketQuotaInBytes(OMMetadataManager metadataManager, OmBucketInfo omBucketInfo, long allocateSize) throws IOException {
        if (omBucketInfo.getQuotaInBytes() > -1L) {
            long usedBytes = omBucketInfo.getTotalBucketSpace();
            long quotaInBytes = omBucketInfo.getQuotaInBytes();
            if (quotaInBytes - usedBytes < allocateSize) {
                throw new OMException("The DiskSpace quota of bucket:" + omBucketInfo.getBucketName() + " exceeded quotaInBytes: " + quotaInBytes + " Bytes but diskspace consumed: " + (usedBytes + allocateSize) + " Bytes.", OMException.ResultCodes.QUOTA_EXCEEDED);
            }
        }
    }

    protected void checkBucketQuotaInNamespace(OmBucketInfo omBucketInfo, long allocatedNamespace) throws IOException {
        if (omBucketInfo.getQuotaInNamespace() > -1L) {
            long toUseNamespaceInTotal;
            long usedNamespace = omBucketInfo.getTotalBucketNamespace();
            long quotaInNamespace = omBucketInfo.getQuotaInNamespace();
            if (quotaInNamespace < (toUseNamespaceInTotal = usedNamespace + allocatedNamespace)) {
                throw new OMException("The namespace quota of Bucket:" + omBucketInfo.getBucketName() + " exceeded: quotaInNamespace: " + quotaInNamespace + " but namespace consumed: " + toUseNamespaceInTotal + ".", OMException.ResultCodes.QUOTA_EXCEEDED);
            }
        }
    }

    protected boolean checkDirectoryAlreadyExists(String volumeName, String bucketName, String keyName, OMMetadataManager omMetadataManager) throws IOException {
        return omMetadataManager.getKeyTable(this.getBucketLayout()).isExist((Object)omMetadataManager.getOzoneDirKey(volumeName, bucketName, keyName));
    }

    public static long sumBlockLengths(OmKeyInfo omKeyInfo) {
        long bytesUsed = 0L;
        for (OmKeyLocationInfoGroup group : omKeyInfo.getKeyLocationVersions()) {
            for (OmKeyLocationInfo locationInfo : group.getLocationList()) {
                bytesUsed += QuotaUtil.getReplicatedSize((long)locationInfo.getLength(), (ReplicationConfig)omKeyInfo.getReplicationConfig());
            }
        }
        return bytesUsed;
    }

    @Nullable
    public static OmBucketInfo getBucketInfo(OMMetadataManager omMetadataManager, String volume, String bucket) {
        String bucketKey = omMetadataManager.getBucketKey(volume, bucket);
        CacheValue value = omMetadataManager.getBucketTable().getCacheValue(new CacheKey((Object)bucketKey));
        return value != null ? (OmBucketInfo)value.getCacheValue() : null;
    }

    protected OmKeyInfo prepareKeyInfo(@Nonnull OMMetadataManager omMetadataManager, @Nonnull OzoneManagerProtocolProtos.KeyArgs keyArgs, OmKeyInfo dbKeyInfo, long size, @Nonnull List<OmKeyLocationInfo> locations, @Nullable FileEncryptionInfo encInfo, @Nonnull PrefixManager prefixManager, @Nullable OmBucketInfo omBucketInfo, OMFileRequest.OMPathInfo omPathInfo, long transactionLogIndex, long objectID, ReplicationConfig replicationConfig, OmConfig config) throws IOException {
        return this.prepareFileInfo(omMetadataManager, keyArgs, dbKeyInfo, size, locations, encInfo, prefixManager, omBucketInfo, omPathInfo, transactionLogIndex, objectID, replicationConfig, config);
    }

    protected OmKeyInfo prepareFileInfo(@Nonnull OMMetadataManager omMetadataManager, @Nonnull OzoneManagerProtocolProtos.KeyArgs keyArgs, OmKeyInfo dbKeyInfo, long size, @Nonnull List<OmKeyLocationInfo> locations, @Nullable FileEncryptionInfo encInfo, @Nonnull PrefixManager prefixManager, @Nullable OmBucketInfo omBucketInfo, OMFileRequest.OMPathInfo omPathInfo, long transactionLogIndex, long objectID, ReplicationConfig replicationConfig, OmConfig config) throws IOException {
        if (keyArgs.getIsMultipartKey()) {
            return this.prepareMultipartFileInfo(omMetadataManager, keyArgs, size, locations, encInfo, prefixManager, omBucketInfo, omPathInfo, transactionLogIndex, objectID, config);
        }
        if (dbKeyInfo != null) {
            dbKeyInfo.addNewVersion(locations, false, omBucketInfo.getIsVersionEnabled());
            long newSize = size;
            if (omBucketInfo.getIsVersionEnabled()) {
                newSize += dbKeyInfo.getDataSize();
            }
            dbKeyInfo.setDataSize(newSize);
            dbKeyInfo.setModificationTime(keyArgs.getModificationTime());
            dbKeyInfo.setUpdateID(transactionLogIndex);
            dbKeyInfo.setReplicationConfig(replicationConfig);
            dbKeyInfo.getMetadata().clear();
            dbKeyInfo.getMetadata().putAll(KeyValueUtil.getFromProtobuf((List)keyArgs.getMetadataList()));
            dbKeyInfo.getTags().clear();
            dbKeyInfo.getTags().putAll(KeyValueUtil.getFromProtobuf((List)keyArgs.getTagsList()));
            if (keyArgs.hasExpectedDataGeneration()) {
                dbKeyInfo.setExpectedDataGeneration(Long.valueOf(keyArgs.getExpectedDataGeneration()));
            }
            dbKeyInfo.setFileEncryptionInfo(encInfo);
            return dbKeyInfo;
        }
        return this.createFileInfo(keyArgs, locations, replicationConfig, keyArgs.getDataSize(), encInfo, prefixManager, omBucketInfo, omPathInfo, transactionLogIndex, objectID, config);
    }

    protected OmKeyInfo createFileInfo(@Nonnull OzoneManagerProtocolProtos.KeyArgs keyArgs, @Nonnull List<OmKeyLocationInfo> locations, @Nonnull ReplicationConfig replicationConfig, long size, @Nullable FileEncryptionInfo encInfo, @Nonnull PrefixManager prefixManager, @Nullable OmBucketInfo omBucketInfo, OMFileRequest.OMPathInfo omPathInfo, long transactionLogIndex, long objectID, OmConfig config) throws OMException {
        OmKeyInfo.Builder builder = new OmKeyInfo.Builder();
        builder.setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).setOmKeyLocationInfos(Collections.singletonList(new OmKeyLocationInfoGroup(0L, locations))).setCreationTime(keyArgs.getModificationTime()).setModificationTime(keyArgs.getModificationTime()).setDataSize(size).setReplicationConfig(replicationConfig).setFileEncryptionInfo(encInfo).setAcls(this.getAclsForKey(keyArgs, omBucketInfo, omPathInfo, prefixManager, config)).addAllMetadata(KeyValueUtil.getFromProtobuf((List)keyArgs.getMetadataList())).addAllTags(KeyValueUtil.getFromProtobuf((List)keyArgs.getTagsList())).setUpdateID(transactionLogIndex).setOwnerName(keyArgs.getOwnerName()).setFile(true);
        if (omPathInfo instanceof OMFileRequest.OMPathInfoWithFSO) {
            OMFileRequest.OMPathInfoWithFSO omPathInfoFSO = (OMFileRequest.OMPathInfoWithFSO)omPathInfo;
            objectID = omPathInfoFSO.getLeafNodeObjectId();
            builder.setParentObjectID(omPathInfoFSO.getLastKnownParentId());
            builder.setFileName(omPathInfoFSO.getLeafNodeName());
        }
        builder.setObjectID(objectID);
        return builder.build();
    }

    private OmKeyInfo prepareMultipartFileInfo(@Nonnull OMMetadataManager omMetadataManager, @Nonnull OzoneManagerProtocolProtos.KeyArgs args, long size, @Nonnull List<OmKeyLocationInfo> locations, FileEncryptionInfo encInfo, @Nonnull PrefixManager prefixManager, @Nullable OmBucketInfo omBucketInfo, OMFileRequest.OMPathInfo omPathInfo, @Nonnull long transactionLogIndex, long objectID, OmConfig configuration) throws IOException {
        Preconditions.checkArgument((args.getMultipartNumber() > 0 ? 1 : 0) != 0, (Object)"PartNumber Should be greater than zero");
        String uploadID = args.getMultipartUploadID();
        Preconditions.checkNotNull((Object)uploadID);
        String multipartKey = "";
        if (omPathInfo instanceof OMFileRequest.OMPathInfoWithFSO) {
            OMFileRequest.OMPathInfoWithFSO omPathInfoFSO = (OMFileRequest.OMPathInfoWithFSO)omPathInfo;
            long volumeId = omMetadataManager.getVolumeId(args.getVolumeName());
            long bucketId = omMetadataManager.getBucketId(args.getVolumeName(), args.getBucketName());
            multipartKey = omMetadataManager.getMultipartKey(volumeId, bucketId, omPathInfoFSO.getLastKnownParentId(), omPathInfoFSO.getLeafNodeName(), uploadID);
        } else {
            multipartKey = omMetadataManager.getMultipartKey(args.getVolumeName(), args.getBucketName(), args.getKeyName(), uploadID);
        }
        OmKeyInfo partKeyInfo = (OmKeyInfo)omMetadataManager.getOpenKeyTable(this.getBucketLayout()).get((Object)multipartKey);
        if (partKeyInfo == null) {
            throw new OMException("No such Multipart upload is with specified uploadId " + uploadID, OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
        }
        return this.createFileInfo(args, locations, partKeyInfo.getReplicationConfig(), size, encInfo, prefixManager, omBucketInfo, omPathInfo, transactionLogIndex, objectID, configuration);
    }

    protected String getDBMultipartOpenKey(String volumeName, String bucketName, String keyName, String uploadID, OMMetadataManager omMetadataManager) throws IOException {
        return omMetadataManager.getMultipartKey(volumeName, bucketName, keyName, uploadID);
    }

    protected RepeatedOmKeyInfo getOldVersionsToCleanUp(@Nonnull OmKeyInfo keyToDelete, long bucketId, long trxnLogIndex) throws IOException {
        return OmUtils.prepareKeyForDelete((long)bucketId, (OmKeyInfo)keyToDelete, (long)trxnLogIndex);
    }

    protected OzoneLockStrategy getOzoneLockStrategy(OzoneManager ozoneManager) {
        return ozoneManager.getOzoneLockProvider().createLockStrategy(this.getBucketLayout());
    }

    protected OmKeyInfo wrapUncommittedBlocksAsPseudoKey(List<OmKeyLocationInfo> uncommitted, OmKeyInfo omKeyInfo) {
        if (uncommitted.isEmpty()) {
            return null;
        }
        LOG.debug("Detect allocated but uncommitted blocks {} in key {}.", uncommitted, (Object)omKeyInfo.getKeyName());
        OmKeyInfo pseudoKeyInfo = omKeyInfo.copyObject();
        pseudoKeyInfo.setObjectID(0L);
        ArrayList<OmKeyLocationInfoGroup> uncommittedGroups = new ArrayList<OmKeyLocationInfoGroup>();
        uncommittedGroups.add(new OmKeyLocationInfoGroup(0L, uncommitted));
        pseudoKeyInfo.setKeyLocationVersions(uncommittedGroups);
        return pseudoKeyInfo;
    }

    protected static Map<String, RepeatedOmKeyInfo> addKeyInfoToDeleteMap(OzoneManager om, long trxnLogIndex, String ozoneKey, long bucketId, OmKeyInfo keyInfo, Map<String, RepeatedOmKeyInfo> deleteMap) {
        if (keyInfo == null) {
            return deleteMap;
        }
        long pseudoObjId = om.getObjectIdFromTxId(trxnLogIndex);
        String delKeyName = om.getMetadataManager().getOzoneDeletePathKey(pseudoObjId, ozoneKey);
        if (deleteMap == null) {
            deleteMap = new HashMap<String, RepeatedOmKeyInfo>();
        }
        deleteMap.computeIfAbsent(delKeyName, key -> new RepeatedOmKeyInfo(bucketId)).addOmKeyInfo(keyInfo);
        return deleteMap;
    }

    protected Pair<Map<OmKeyInfo, List<OmKeyLocationInfo>>, Integer> filterOutBlocksStillInUse(OmKeyInfo referenceKey, RepeatedOmKeyInfo keysToBeFiltered) {
        LOG.debug("Before block filtering, keysToBeFiltered = {}", (Object)keysToBeFiltered);
        Map cbIdSet = referenceKey.getKeyLocationVersions().stream().flatMap(e -> e.getLocationList().stream()).collect(Collectors.toMap(omKeyLocationInfo -> omKeyLocationInfo.getBlockID().getContainerBlockID(), Function.identity()));
        HashMap<OmKeyInfo, List> filteredOutBlocks = new HashMap<OmKeyInfo, List>();
        Iterator iterOmKeyInfo = keysToBeFiltered.getOmKeyInfoList().iterator();
        int emptyKeyRemovedCount = 0;
        while (iterOmKeyInfo.hasNext()) {
            OmKeyInfo oldOmKeyInfo = (OmKeyInfo)iterOmKeyInfo.next();
            Iterator iterKeyLocInfoGroup = oldOmKeyInfo.getKeyLocationVersions().iterator();
            while (iterKeyLocInfoGroup.hasNext()) {
                OmKeyLocationInfoGroup keyLocInfoGroup = (OmKeyLocationInfoGroup)iterKeyLocInfoGroup.next();
                Iterator iterVerMap = keyLocInfoGroup.getLocationVersionMap().entrySet().iterator();
                while (iterVerMap.hasNext()) {
                    Map.Entry mapEntry = iterVerMap.next();
                    List omKeyLocationInfoList = (List)mapEntry.getValue();
                    Iterator iterKeyLocInfo = omKeyLocationInfoList.iterator();
                    while (iterKeyLocInfo.hasNext()) {
                        OmKeyLocationInfo keyLocationInfo = (OmKeyLocationInfo)iterKeyLocInfo.next();
                        ContainerBlockID cbId = keyLocationInfo.getBlockID().getContainerBlockID();
                        if (!cbIdSet.containsKey(cbId)) continue;
                        filteredOutBlocks.computeIfAbsent(oldOmKeyInfo, k -> new ArrayList()).add(keyLocationInfo);
                        iterKeyLocInfo.remove();
                        LOG.debug("Filtered out block: {}", (Object)cbId);
                    }
                    if (!omKeyLocationInfoList.isEmpty()) continue;
                    iterVerMap.remove();
                }
                if (!keyLocInfoGroup.getLocationVersionMap().isEmpty()) continue;
                iterKeyLocInfoGroup.remove();
            }
            if (!oldOmKeyInfo.getKeyLocationVersions().isEmpty()) continue;
            ++emptyKeyRemovedCount;
            iterOmKeyInfo.remove();
        }
        LOG.debug("After block filtering,  keysToBeFiltered = {}", (Object)keysToBeFiltered);
        return Pair.of(filteredOutBlocks, (Object)emptyKeyRemovedCount);
    }

    protected void validateEncryptionKeyInfo(OmBucketInfo bucketInfo, OzoneManagerProtocolProtos.KeyArgs keyArgs) throws OMException {
        if (bucketInfo.getEncryptionKeyInfo() != null && !keyArgs.hasFileEncryptionInfo()) {
            throw new OMException("Attempting to create unencrypted file " + keyArgs.getKeyName() + " in encrypted bucket " + keyArgs.getBucketName(), OMException.ResultCodes.INVALID_REQUEST);
        }
    }
}

