/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.ratis;

import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeFloat;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.metrics2.lib.MutableStat;

public class OzoneManagerDoubleBufferMetrics {
    private static OzoneManagerDoubleBufferMetrics instance;
    private static final String SOURCE_NAME;
    @Metric(about="Total Number of flush operations happened in OzoneManagerDoubleBuffer.")
    private MutableCounterLong totalNumOfFlushOperations;
    @Metric(about="Total Number of flushed transactions happened in OzoneManagerDoubleBuffer.")
    private MutableCounterLong totalNumOfFlushedTransactions;
    @Metric(about="Max Number of transactions flushed in a iteration in OzoneManagerDoubleBuffer. This will provide a value which is maximum number of transactions flushed in a single flush iteration till now.")
    private MutableCounterLong maxNumberOfTransactionsFlushedInOneIteration;
    @Metric(about="DoubleBuffer flushTime. This metrics particularly captures rocksdb batch commit time.")
    private MutableRate flushTime;
    @Metric(about="Average number of transactions flushed in a single iteration")
    private MutableGaugeFloat avgFlushTransactionsInOneIteration;
    @Metric(about="DoubleBuffer queue size.", valueName="Size")
    private MutableStat queueSize;

    static {
        SOURCE_NAME = OzoneManagerDoubleBufferMetrics.class.getSimpleName();
    }

    public static synchronized OzoneManagerDoubleBufferMetrics create() {
        OzoneManagerDoubleBufferMetrics omDoubleBufferMetrics;
        if (instance != null) {
            return instance;
        }
        MetricsSystem ms = DefaultMetricsSystem.instance();
        instance = omDoubleBufferMetrics = (OzoneManagerDoubleBufferMetrics)ms.register(SOURCE_NAME, "OzoneManager DoubleBuffer Metrics", (Object)new OzoneManagerDoubleBufferMetrics());
        return omDoubleBufferMetrics;
    }

    public void incrTotalNumOfFlushOperations() {
        this.totalNumOfFlushOperations.incr();
    }

    public void incrTotalNumOfFlushOperations(long flushedOperations) {
        this.totalNumOfFlushOperations.incr(flushedOperations);
    }

    public void incrTotalSizeOfFlushedTransactions(long flushedTransactions) {
        this.totalNumOfFlushedTransactions.incr(flushedTransactions);
    }

    public void setMaxNumberOfTransactionsFlushedInOneIteration(long maxTransactions) {
        this.maxNumberOfTransactionsFlushedInOneIteration.incr(Math.negateExact(this.getMaxNumberOfTransactionsFlushedInOneIteration()) + maxTransactions);
    }

    public long getTotalNumOfFlushOperations() {
        return this.totalNumOfFlushOperations.value();
    }

    public long getTotalNumOfFlushedTransactions() {
        return this.totalNumOfFlushedTransactions.value();
    }

    public long getMaxNumberOfTransactionsFlushedInOneIteration() {
        return this.maxNumberOfTransactionsFlushedInOneIteration.value();
    }

    public void updateFlushTime(long time) {
        this.flushTime.add(time);
    }

    MutableRate getFlushTime() {
        return this.flushTime;
    }

    public float getAvgFlushTransactionsInOneIteration() {
        return this.avgFlushTransactionsInOneIteration.value();
    }

    public void setAvgFlushTransactionsInOneIteration(float count) {
        this.avgFlushTransactionsInOneIteration.set(count);
    }

    public void updateQueueSize(long size) {
        this.queueSize.add(size);
    }

    public void updateFlush(int flushedTransactionsInOneIteration) {
        this.incrTotalNumOfFlushOperations();
        this.incrTotalSizeOfFlushedTransactions(flushedTransactionsInOneIteration);
        this.setAvgFlushTransactionsInOneIteration((float)this.getTotalNumOfFlushedTransactions() / (float)this.getTotalNumOfFlushOperations());
        long max = this.getMaxNumberOfTransactionsFlushedInOneIteration();
        if ((long)flushedTransactionsInOneIteration > max) {
            this.maxNumberOfTransactionsFlushedInOneIteration.incr((long)flushedTransactionsInOneIteration - max);
        }
        this.updateQueueSize(flushedTransactionsInOneIteration);
    }

    MutableStat getQueueSize() {
        return this.queueSize;
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }
}

