/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.ha;

import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.OzoneIllegalArgumentException;
import org.apache.hadoop.ozone.ha.ConfUtils;
import org.apache.hadoop.ozone.om.helpers.OMNodeDetails;
import org.apache.hadoop.ozone.util.OzoneNetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMHANodeDetails {
    private static String[] genericConfigKeys = new String[]{"ozone.om.http-address", "ozone.om.https-address", "ozone.om.http-bind-host", "ozone.om.https-bind-host", "ozone.om.db.dirs", "ozone.om.address"};
    private static final Logger LOG = LoggerFactory.getLogger(OMHANodeDetails.class);
    private final OMNodeDetails localNodeDetails;
    private final List<OMNodeDetails> peerNodeDetails;

    public OMHANodeDetails(OMNodeDetails localNodeDetails, List<OMNodeDetails> peerNodeDetails) {
        this.localNodeDetails = localNodeDetails;
        this.peerNodeDetails = peerNodeDetails;
    }

    public OMNodeDetails getLocalNodeDetails() {
        return this.localNodeDetails;
    }

    public Map<String, OMNodeDetails> getPeerNodesMap() {
        HashMap<String, OMNodeDetails> peerNodesMap = new HashMap<String, OMNodeDetails>();
        for (OMNodeDetails peeNode : this.peerNodeDetails) {
            peerNodesMap.put(peeNode.getNodeId(), peeNode);
        }
        return peerNodesMap;
    }

    public static OMHANodeDetails loadOMHAConfig(OzoneConfiguration conf) {
        Collection<String> omServiceIds;
        InetSocketAddress localRpcAddress = null;
        String localOMServiceId = null;
        String localOMNodeId = null;
        int localRatisPort = 0;
        boolean localIsListener = false;
        localOMServiceId = conf.getTrimmed("ozone.om.internal.service.id");
        if (localOMServiceId == null) {
            LOG.info("{} is not defined, falling back to {} to find serviceID for OzoneManager if it is HA enabled cluster", (Object)"ozone.om.internal.service.id", (Object)"ozone.om.service.ids");
            omServiceIds = conf.getTrimmedStringCollection("ozone.om.service.ids");
        } else {
            LOG.info("ServiceID for OzoneManager is {}", (Object)localOMServiceId);
            omServiceIds = Collections.singletonList(localOMServiceId);
        }
        String knownOMNodeId = conf.get("ozone.om.node.id");
        int found = 0;
        boolean isOMAddressSet = false;
        for (String serviceId : omServiceIds) {
            Collection omNodeIds = OmUtils.getActiveOMNodeIds((ConfigurationSource)conf, (String)serviceId);
            Collection listenerOmNodeIds = OmUtils.getListenerOMNodeIds((ConfigurationSource)conf, (String)serviceId);
            if (omNodeIds.isEmpty()) {
                OMHANodeDetails.throwConfException("Configuration does not have any value set for %s for the service %s. List of OM Node ID's should be specified for an OM service", "ozone.om.nodes", serviceId);
                return null;
            }
            ArrayList<OMNodeDetails> peerNodesList = new ArrayList<OMNodeDetails>();
            for (String nodeId : omNodeIds) {
                boolean isPeer = knownOMNodeId != null && !knownOMNodeId.equals(nodeId);
                String rpcAddrKey = ConfUtils.addKeySuffixes((String)"ozone.om.address", (String[])new String[]{serviceId, nodeId});
                String rpcAddrStr = OmUtils.getOmRpcAddress((ConfigurationSource)conf, (String)rpcAddrKey);
                if (rpcAddrStr == null || rpcAddrStr.isEmpty()) {
                    OMHANodeDetails.throwConfException("Configuration does not have any value set for %s. OM RPC Address should be set for all nodes in an OM service.", rpcAddrKey);
                    return null;
                }
                isOMAddressSet = true;
                String ratisPortKey = ConfUtils.addKeySuffixes((String)"ozone.om.ratis.port", (String[])new String[]{serviceId, nodeId});
                int ratisPort = conf.getInt(ratisPortKey, 9872);
                InetSocketAddress addr = null;
                try {
                    addr = NetUtils.createSocketAddr((String)rpcAddrStr);
                }
                catch (Exception e) {
                    LOG.error("Couldn't create socket address for OM {} : {}", new Object[]{nodeId, rpcAddrStr, e});
                    throw e;
                }
                boolean flexibleFqdnResolutionEnabled = conf.getBoolean("ozone.network.flexible.fqdn.resolution.enabled", false);
                if (OzoneNetUtils.isUnresolved((boolean)flexibleFqdnResolutionEnabled, (InetSocketAddress)addr)) {
                    LOG.error("Address for OM {} : {} couldn't be resolved. Proceeding with unresolved host to create Ratis ring.", (Object)nodeId, (Object)rpcAddrStr);
                }
                boolean isListener = listenerOmNodeIds.contains(nodeId);
                if (!isPeer && OzoneNetUtils.isAddressLocal((boolean)flexibleFqdnResolutionEnabled, (InetSocketAddress)addr)) {
                    localRpcAddress = addr;
                    localOMServiceId = serviceId;
                    localOMNodeId = nodeId;
                    localRatisPort = ratisPort;
                    localIsListener = isListener;
                    ++found;
                    continue;
                }
                peerNodesList.add(OMHANodeDetails.getHAOMNodeDetails(conf, serviceId, nodeId, addr, ratisPort, isListener));
            }
            if (found == 1) {
                LOG.info("Found matching OM address with OMServiceId: {}, OMNodeId: {}, RPC Address: {} ,Ratis port: {} and isListener: {}", new Object[]{localOMServiceId, localOMNodeId, NetUtils.getHostPortString(localRpcAddress), localRatisPort, localIsListener});
                ConfUtils.setNodeSpecificConfigs((String[])genericConfigKeys, (OzoneConfiguration)conf, (String)localOMServiceId, localOMNodeId, (Logger)LOG);
                return new OMHANodeDetails(OMHANodeDetails.getHAOMNodeDetails(conf, localOMServiceId, localOMNodeId, localRpcAddress, localRatisPort, localIsListener), peerNodesList);
            }
            if (found <= true) continue;
            OMHANodeDetails.throwConfException("Configuration has multiple %s addresses that match local node's address. Please configure the system with %s and %s", "ozone.om.address", "ozone.om.service.ids", "ozone.om.address");
            return null;
        }
        if (!isOMAddressSet) {
            InetSocketAddress omAddress = OmUtils.getOmAddress((ConfigurationSource)conf);
            int ratisPort = conf.getInt("ozone.om.ratis.port", 9872);
            LOG.info("Configuration does not have {} set. Falling back to the default OM address {}", (Object)"ozone.om.address", (Object)omAddress);
            return new OMHANodeDetails(OMHANodeDetails.getOMNodeDetailsForNonHA(conf, null, null, omAddress, ratisPort), new ArrayList<OMNodeDetails>());
        }
        OMHANodeDetails.throwConfException("Configuration has no %s address that matches local node's address.", "ozone.om.address");
        return null;
    }

    public static OMNodeDetails getOMNodeDetailsForNonHA(OzoneConfiguration conf, String serviceId, String nodeId, InetSocketAddress rpcAddress, int ratisPort) {
        return OMHANodeDetails.getOMNodeDetailsForNonHA(conf, serviceId, nodeId, rpcAddress, ratisPort, false);
    }

    public static OMNodeDetails getOMNodeDetailsForNonHA(OzoneConfiguration conf, String serviceId, String nodeId, InetSocketAddress rpcAddress, int ratisPort, boolean isListener) {
        if (serviceId == null) {
            serviceId = "omServiceIdDefault";
            LOG.info("OM Service ID is not set. Setting it to the default ID: {}", (Object)serviceId);
        }
        if (nodeId == null) {
            nodeId = "om1";
            LOG.info("OM Node ID is not set. Setting it to the default ID: {}", (Object)nodeId);
        }
        String httpAddr = OmUtils.getHttpAddressForOMPeerNode((ConfigurationSource)conf, null, null, (String)rpcAddress.getHostName());
        String httpsAddr = OmUtils.getHttpsAddressForOMPeerNode((ConfigurationSource)conf, null, null, (String)rpcAddress.getHostName());
        return new OMNodeDetails.Builder().setOMServiceId(serviceId).setOMNodeId(nodeId).setRpcAddress(rpcAddress).setRatisPort(ratisPort).setHttpAddress(httpAddr).setHttpsAddress(httpsAddr).setIsListener(isListener).build();
    }

    public static OMNodeDetails getHAOMNodeDetails(OzoneConfiguration conf, String serviceId, String nodeId, InetSocketAddress rpcAddress, int ratisPort) {
        return OMHANodeDetails.getHAOMNodeDetails(conf, serviceId, nodeId, rpcAddress, ratisPort, false);
    }

    public static OMNodeDetails getHAOMNodeDetails(OzoneConfiguration conf, String serviceId, String nodeId, InetSocketAddress rpcAddress, int ratisPort, boolean isListener) {
        Preconditions.checkNotNull((Object)serviceId);
        Preconditions.checkNotNull((Object)nodeId);
        String httpAddr = OmUtils.getHttpAddressForOMPeerNode((ConfigurationSource)conf, (String)serviceId, (String)nodeId, (String)rpcAddress.getHostName());
        String httpsAddr = OmUtils.getHttpsAddressForOMPeerNode((ConfigurationSource)conf, (String)serviceId, (String)nodeId, (String)rpcAddress.getHostName());
        return new OMNodeDetails.Builder().setOMServiceId(serviceId).setOMNodeId(nodeId).setRpcAddress(rpcAddress).setRatisPort(ratisPort).setHttpAddress(httpAddr).setHttpsAddress(httpsAddr).setIsListener(isListener).build();
    }

    private static void throwConfException(String message, String ... arguments) throws IllegalArgumentException {
        String exceptionMsg = String.format(message, arguments);
        LOG.error(exceptionMsg);
        throw new OzoneIllegalArgumentException(exceptionMsg);
    }
}

