/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.util.Map;
import org.apache.hadoop.ozone.common.BlockGroup;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;

public class PendingKeysDeletion {
    private final Map<String, RepeatedOmKeyInfo> keysToModify;
    private final Map<String, PurgedKey> purgedKeys;
    private int notReclaimableKeyCount;

    public PendingKeysDeletion(Map<String, PurgedKey> purgedKeys, Map<String, RepeatedOmKeyInfo> keysToModify, int notReclaimableKeyCount) {
        this.keysToModify = keysToModify;
        this.purgedKeys = purgedKeys;
        this.notReclaimableKeyCount = notReclaimableKeyCount;
    }

    public Map<String, RepeatedOmKeyInfo> getKeysToModify() {
        return this.keysToModify;
    }

    public Map<String, PurgedKey> getPurgedKeys() {
        return this.purgedKeys;
    }

    public int getNotReclaimableKeyCount() {
        return this.notReclaimableKeyCount;
    }

    public static class PurgedKey {
        private final String volume;
        private final String bucket;
        private final long bucketId;
        private final BlockGroup blockGroup;
        private final long purgedBytes;
        private final boolean isCommittedKey;
        private final String deleteKeyName;

        public PurgedKey(String volume, String bucket, long bucketId, BlockGroup group, String deleteKeyName, long purgedBytes, boolean isCommittedKey) {
            this.volume = volume;
            this.bucket = bucket;
            this.bucketId = bucketId;
            this.blockGroup = group;
            this.purgedBytes = purgedBytes;
            this.isCommittedKey = isCommittedKey;
            this.deleteKeyName = deleteKeyName;
        }

        public BlockGroup getBlockGroup() {
            return this.blockGroup;
        }

        public long getPurgedBytes() {
            return this.purgedBytes;
        }

        public String getVolume() {
            return this.volume;
        }

        public String getBucket() {
            return this.bucket;
        }

        public long getBucketId() {
            return this.bucketId;
        }

        public boolean isCommittedKey() {
            return this.isCommittedKey;
        }

        public String getDeleteKeyName() {
            return this.deleteKeyName;
        }

        public String toString() {
            return "PurgedKey{blockGroup=" + this.blockGroup + ", volume='" + this.volume + '\'' + ", bucket='" + this.bucket + '\'' + ", bucketId=" + this.bucketId + ", purgedBytes=" + this.purgedBytes + ", isCommittedKey=" + this.isCommittedKey + ", deleteKeyName='" + this.deleteKeyName + '\'' + '}';
        }
    }
}

