/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.erasurecode.rawcoder;

import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.ozone.erasurecode.rawcoder.NativeXORRawDecoder;
import org.apache.ozone.erasurecode.rawcoder.NativeXORRawEncoder;
import org.apache.ozone.erasurecode.rawcoder.RawErasureCoderFactory;
import org.apache.ozone.erasurecode.rawcoder.RawErasureDecoder;
import org.apache.ozone.erasurecode.rawcoder.RawErasureEncoder;

@InterfaceAudience.Private
public class NativeXORRawErasureCoderFactory
implements RawErasureCoderFactory {
    public static final String CODER_NAME = "xor_native";

    @Override
    public RawErasureEncoder createEncoder(ECReplicationConfig ecReplicationConfig) {
        return new NativeXORRawEncoder(ecReplicationConfig);
    }

    @Override
    public RawErasureDecoder createDecoder(ECReplicationConfig ecReplicationConfig) {
        return new NativeXORRawDecoder(ecReplicationConfig);
    }

    @Override
    public String getCoderName() {
        return CODER_NAME;
    }

    @Override
    public String getCodecName() {
        return ECReplicationConfig.EcCodec.XOR.name().toLowerCase();
    }
}

