/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.erasurecode.rawcoder;

import java.nio.ByteBuffer;
import org.apache.ozone.erasurecode.rawcoder.ByteBufferDecodingState;
import org.apache.ozone.erasurecode.rawcoder.CoderUtil;
import org.apache.ozone.erasurecode.rawcoder.DecodingState;
import org.apache.ozone.erasurecode.rawcoder.RawErasureDecoder;

class ByteArrayDecodingState
extends DecodingState {
    byte[][] inputs;
    int[] inputOffsets;
    int[] erasedIndexes;
    byte[][] outputs;
    int[] outputOffsets;

    ByteArrayDecodingState(RawErasureDecoder decoder, byte[][] inputs, int[] erasedIndexes, byte[][] outputs) {
        this.decoder = decoder;
        this.inputs = inputs;
        this.outputs = outputs;
        this.erasedIndexes = erasedIndexes;
        byte[] validInput = (byte[])CoderUtil.findFirstValidInput(inputs);
        this.decodeLength = validInput.length;
        this.checkParameters((T[])inputs, erasedIndexes, (T[])outputs);
        this.checkInputBuffers(inputs);
        this.checkOutputBuffers(outputs);
        this.inputOffsets = new int[inputs.length];
        this.outputOffsets = new int[outputs.length];
    }

    ByteArrayDecodingState(RawErasureDecoder decoder, int decodeLength, int[] erasedIndexes, byte[][] inputs, int[] inputOffsets, byte[][] outputs, int[] outputOffsets) {
        this.decoder = decoder;
        this.decodeLength = decodeLength;
        this.erasedIndexes = erasedIndexes;
        this.inputs = inputs;
        this.outputs = outputs;
        this.inputOffsets = inputOffsets;
        this.outputOffsets = outputOffsets;
    }

    ByteBufferDecodingState convertToByteBufferState() {
        int i;
        ByteBuffer[] newInputs = new ByteBuffer[this.inputs.length];
        ByteBuffer[] newOutputs = new ByteBuffer[this.outputs.length];
        for (i = 0; i < this.inputs.length; ++i) {
            newInputs[i] = CoderUtil.cloneAsDirectByteBuffer(this.inputs[i], this.inputOffsets[i], this.decodeLength);
        }
        for (i = 0; i < this.outputs.length; ++i) {
            newOutputs[i] = ByteBuffer.allocateDirect(this.decodeLength);
        }
        ByteBufferDecodingState bbdState = new ByteBufferDecodingState(this.decoder, this.decodeLength, this.erasedIndexes, newInputs, newOutputs);
        return bbdState;
    }

    void checkInputBuffers(byte[][] buffers) {
        int validInputs = 0;
        for (byte[] buffer : buffers) {
            if (buffer == null) continue;
            if (buffer.length != this.decodeLength) {
                throw new IllegalArgumentException("Invalid buffer, not of length " + this.decodeLength);
            }
            ++validInputs;
        }
        if (validInputs < this.decoder.getNumDataUnits()) {
            throw new IllegalArgumentException("No enough valid inputs are provided, not recoverable");
        }
    }

    void checkOutputBuffers(byte[][] buffers) {
        for (byte[] buffer : buffers) {
            if (buffer == null) {
                throw new IllegalArgumentException("Invalid buffer found, not allowing null");
            }
            if (buffer.length == this.decodeLength) continue;
            throw new IllegalArgumentException("Invalid buffer not of length " + this.decodeLength);
        }
    }
}

