/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.rocksdiff;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksDB;
import org.apache.ozone.compaction.log.CompactionFileInfo;
import org.apache.ozone.rocksdiff.CompactionNode;
import org.rocksdb.LiveFileMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RocksDiffUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RocksDiffUtils.class);

    private RocksDiffUtils() {
    }

    public static boolean isKeyWithPrefixPresent(String prefixForColumnFamily, String firstDbKey, String lastDbKey) {
        String firstKeyPrefix = RocksDiffUtils.constructBucketKey(firstDbKey);
        String endKeyPrefix = RocksDiffUtils.constructBucketKey(lastDbKey);
        return firstKeyPrefix.compareTo(prefixForColumnFamily) <= 0 && prefixForColumnFamily.compareTo(endKeyPrefix) <= 0;
    }

    public static String constructBucketKey(String keyName) {
        if (!keyName.startsWith("/")) {
            keyName = "/".concat(keyName);
        }
        String[] elements = keyName.split("/");
        String volume = elements[1];
        String bucket = elements[2];
        StringBuilder builder = new StringBuilder().append("/").append(volume);
        if (StringUtils.isNotBlank((CharSequence)bucket)) {
            builder.append("/").append(bucket);
        }
        builder.append("/");
        return builder.toString();
    }

    public static void filterRelevantSstFiles(Set<String> inputFiles, Map<String, String> tableToPrefixMap, ManagedRocksDB ... dbs) {
        RocksDiffUtils.filterRelevantSstFiles(inputFiles, tableToPrefixMap, Collections.emptyMap(), dbs);
    }

    public static void filterRelevantSstFiles(Set<String> inputFiles, Map<String, String> tableToPrefixMap, Map<String, CompactionNode> preExistingCompactionNodes, ManagedRocksDB ... dbs) {
        HashMap liveFileMetaDataMap = new HashMap();
        int dbIdx = 0;
        Iterator<String> fileIterator = inputFiles.iterator();
        while (fileIterator.hasNext()) {
            String filename = FilenameUtils.getBaseName((String)fileIterator.next());
            while (!preExistingCompactionNodes.containsKey(filename) && !liveFileMetaDataMap.containsKey(filename) && dbIdx < dbs.length) {
                liveFileMetaDataMap.putAll(dbs[dbIdx].getLiveMetadataForSSTFiles());
                ++dbIdx;
            }
            CompactionNode compactionNode = preExistingCompactionNodes.get(filename);
            if (compactionNode == null) {
                compactionNode = new CompactionNode(new CompactionFileInfo.Builder(filename).setValues((LiveFileMetaData)liveFileMetaDataMap.get(filename)).build());
            }
            if (!RocksDiffUtils.shouldSkipNode(compactionNode, tableToPrefixMap)) continue;
            fileIterator.remove();
        }
    }

    @VisibleForTesting
    static boolean shouldSkipNode(CompactionNode node, Map<String, String> columnFamilyToPrefixMap) {
        if (node.getStartKey() == null || node.getEndKey() == null || node.getColumnFamily() == null) {
            LOG.debug("Compaction node with fileName: {} doesn't have startKey, endKey and columnFamily details.", (Object)node.getFileName());
            return false;
        }
        if (MapUtils.isEmpty(columnFamilyToPrefixMap)) {
            LOG.debug("Provided columnFamilyToPrefixMap is null or empty.");
            return false;
        }
        if (!columnFamilyToPrefixMap.containsKey(node.getColumnFamily())) {
            LOG.debug("SstFile node: {} is for columnFamily: {} while filter map contains columnFamilies: {}.", new Object[]{node.getFileName(), node.getColumnFamily(), columnFamilyToPrefixMap.keySet()});
            return true;
        }
        String keyPrefix = columnFamilyToPrefixMap.get(node.getColumnFamily());
        return !RocksDiffUtils.isKeyWithPrefixPresent(keyPrefix, node.getStartKey(), node.getEndKey());
    }
}

