/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.AddErasureCodingPolicyResponse;
import org.apache.hadoop.hdfs.protocol.ECTopologyVerifierResult;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyInfo;
import org.apache.hadoop.hdfs.protocol.NoECPolicySetException;
import org.apache.hadoop.hdfs.tools.AdminHelper;
import org.apache.hadoop.hdfs.util.ECPolicyLoader;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.tools.TableListing;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Private
public class ECAdmin
extends Configured
implements Tool {
    public static final String NAME = "ec";
    private static final AdminHelper.Command[] COMMANDS = new AdminHelper.Command[]{new ListECPoliciesCommand(), new AddECPoliciesCommand(), new GetECPolicyCommand(), new RemoveECPolicyCommand(), new SetECPolicyCommand(), new UnsetECPolicyCommand(), new ListECCodecsCommand(), new EnableECPolicyCommand(), new DisableECPolicyCommand(), new VerifyClusterSetupCommand()};

    public static void main(String[] args) throws Exception {
        ECAdmin admin = new ECAdmin(new Configuration());
        int res = ToolRunner.run((Tool)admin, (String[])args);
        System.exit(res);
    }

    public ECAdmin(Configuration conf) {
        super(conf);
    }

    public int run(String[] args) throws Exception {
        if (args.length == 0) {
            AdminHelper.printUsage(false, NAME, COMMANDS);
            ToolRunner.printGenericCommandUsage((PrintStream)System.err);
            return 1;
        }
        AdminHelper.Command command = AdminHelper.determineCommand(args[0], COMMANDS);
        if (command == null) {
            System.err.println("Can't understand command '" + args[0] + "'");
            if (!args[0].startsWith("-")) {
                System.err.println("Command names must start with dashes.");
            }
            AdminHelper.printUsage(false, NAME, COMMANDS);
            ToolRunner.printGenericCommandUsage((PrintStream)System.err);
            return 1;
        }
        LinkedList<String> argsList = new LinkedList<String>();
        argsList.addAll(Arrays.asList(args).subList(1, args.length));
        try {
            return command.run(this.getConf(), argsList);
        }
        catch (IllegalArgumentException e) {
            System.err.println(AdminHelper.prettifyException(e));
            return -1;
        }
    }

    private static class VerifyClusterSetupCommand
    implements AdminHelper.Command {
        private VerifyClusterSetupCommand() {
        }

        @Override
        public String getName() {
            return "-verifyClusterSetup";
        }

        @Override
        public String getShortUsage() {
            return "[" + this.getName() + " [-policy <policy>...<policy>]]\n";
        }

        @Override
        public String getLongUsage() {
            TableListing listing = AdminHelper.getOptionDescriptionListing();
            listing.addRow(new String[]{"<policy>", "The name of the erasure coding policy"});
            return this.getShortUsage() + "\nVerify if the cluster setup can support all enabled erasure coding policies. If optional parameter -policy is specified, verify if the cluster setup can support the given policy.\n";
        }

        @Override
        public int run(Configuration conf, List<String> args) throws IOException {
            boolean isPolicyOption = StringUtils.popOption((String)"-policy", args);
            DistributedFileSystem dfs = AdminHelper.getDFS(conf);
            ECTopologyVerifierResult result = null;
            if (isPolicyOption) {
                CommandFormat c = new CommandFormat(1, Integer.MAX_VALUE, new String[0]);
                c.parse(args);
                String[] parameters = args.toArray(new String[args.size()]);
                try {
                    result = dfs.getECTopologyResultForPolicies(parameters);
                }
                catch (RemoteException e) {
                    if (e.getClassName().contains("HadoopIllegalArgumentException")) {
                        throw new HadoopIllegalArgumentException(e.getMessage());
                    }
                    throw e;
                }
            } else {
                if (args.size() > 0) {
                    System.err.println(this.getName() + ": Too many arguments");
                    return 1;
                }
                result = dfs.getECTopologyResultForPolicies(new String[0]);
            }
            System.out.println(result.getResultMessage());
            if (result.isSupported()) {
                return 0;
            }
            return 2;
        }
    }

    private static class DisableECPolicyCommand
    implements AdminHelper.Command {
        private DisableECPolicyCommand() {
        }

        @Override
        public String getName() {
            return "-disablePolicy";
        }

        @Override
        public String getShortUsage() {
            return "[" + this.getName() + " -policy <policy>]\n";
        }

        @Override
        public String getLongUsage() {
            TableListing listing = AdminHelper.getOptionDescriptionListing();
            listing.addRow(new String[]{"<policy>", "The name of the erasure coding policy"});
            return this.getShortUsage() + "\nDisable the erasure coding policy.\n\n" + listing.toString();
        }

        @Override
        public int run(Configuration conf, List<String> args) throws IOException {
            String ecPolicyName = StringUtils.popOptionWithArgument((String)"-policy", args);
            if (ecPolicyName == null) {
                System.err.println("Please specify the policy name.\nUsage: " + this.getLongUsage());
                return 1;
            }
            if (args.size() > 0) {
                System.err.println(this.getName() + ": Too many arguments");
                return 1;
            }
            DistributedFileSystem dfs = AdminHelper.getDFS(conf);
            try {
                dfs.disableErasureCodingPolicy(ecPolicyName);
                System.out.println("Erasure coding policy " + ecPolicyName + " is disabled");
            }
            catch (IOException e) {
                System.err.println(AdminHelper.prettifyException(e));
                return 2;
            }
            return 0;
        }
    }

    private static class EnableECPolicyCommand
    implements AdminHelper.Command {
        private EnableECPolicyCommand() {
        }

        @Override
        public String getName() {
            return "-enablePolicy";
        }

        @Override
        public String getShortUsage() {
            return "[" + this.getName() + " -policy <policy>]\n";
        }

        @Override
        public String getLongUsage() {
            TableListing listing = AdminHelper.getOptionDescriptionListing();
            listing.addRow(new String[]{"<policy>", "The name of the erasure coding policy"});
            return this.getShortUsage() + "\nEnable the erasure coding policy.\n\n" + listing.toString();
        }

        @Override
        public int run(Configuration conf, List<String> args) throws IOException {
            String ecPolicyName = StringUtils.popOptionWithArgument((String)"-policy", args);
            if (ecPolicyName == null) {
                System.err.println("Please specify the policy name.\nUsage: " + this.getLongUsage());
                return 1;
            }
            if (args.size() > 0) {
                System.err.println(this.getName() + ": Too many arguments");
                return 1;
            }
            DistributedFileSystem dfs = AdminHelper.getDFS(conf);
            try {
                dfs.enableErasureCodingPolicy(ecPolicyName);
                System.out.println("Erasure coding policy " + ecPolicyName + " is enabled");
                ECTopologyVerifierResult result = dfs.getECTopologyResultForPolicies(new String[]{ecPolicyName});
                if (!result.isSupported()) {
                    System.err.println("Warning: The cluster setup does not support EC policy " + ecPolicyName + ". Reason: " + result.getResultMessage());
                }
            }
            catch (IOException e) {
                System.err.println(AdminHelper.prettifyException(e));
                return 2;
            }
            return 0;
        }
    }

    private static class ListECCodecsCommand
    implements AdminHelper.Command {
        private ListECCodecsCommand() {
        }

        @Override
        public String getName() {
            return "-listCodecs";
        }

        @Override
        public String getShortUsage() {
            return "[" + this.getName() + "]\n";
        }

        @Override
        public String getLongUsage() {
            return this.getShortUsage() + "\nGet the list of supported erasure coding codecs and coders.\nA coder is an implementation of a codec. A codec can have different implementations, thus different coders.\nThe coders for a codec are listed in a fall back order.\n";
        }

        @Override
        public int run(Configuration conf, List<String> args) throws IOException {
            if (args.size() > 0) {
                System.err.println(this.getName() + ": Too many arguments");
                return 1;
            }
            DistributedFileSystem dfs = AdminHelper.getDFS(conf);
            try {
                Map codecs = dfs.getAllErasureCodingCodecs();
                if (codecs.isEmpty()) {
                    System.out.println("No erasure coding codecs are supported on the cluster.");
                } else {
                    System.out.println("Erasure Coding Codecs: Codec [Coder List]");
                    for (Map.Entry codec : codecs.entrySet()) {
                        if (codec == null) continue;
                        System.out.println("\t" + ((String)codec.getKey()).toUpperCase() + " [" + ((String)codec.getValue()).toUpperCase() + "]");
                    }
                }
            }
            catch (IOException e) {
                System.err.println(AdminHelper.prettifyException(e));
                return 2;
            }
            return 0;
        }
    }

    private static class UnsetECPolicyCommand
    implements AdminHelper.Command {
        private UnsetECPolicyCommand() {
        }

        @Override
        public String getName() {
            return "-unsetPolicy";
        }

        @Override
        public String getShortUsage() {
            return "[" + this.getName() + " -path <path>]\n";
        }

        @Override
        public String getLongUsage() {
            TableListing listing = AdminHelper.getOptionDescriptionListing();
            listing.addRow(new String[]{"<path>", "The path of the directory from which the erasure coding policy will be unset."});
            return this.getShortUsage() + "\nUnset the erasure coding policy for a directory.\n\n" + listing.toString();
        }

        @Override
        public int run(Configuration conf, List<String> args) throws IOException {
            String path = StringUtils.popOptionWithArgument((String)"-path", args);
            if (path == null) {
                System.err.println("Please specify a path.\nUsage: " + this.getLongUsage());
                return 1;
            }
            if (args.size() > 0) {
                System.err.println(this.getName() + ": Too many arguments");
                return 1;
            }
            Path p = new Path(path);
            DistributedFileSystem dfs = AdminHelper.getDFS(p.toUri(), conf);
            try {
                dfs.unsetErasureCodingPolicy(p);
                System.out.println("Unset erasure coding policy from " + path);
                RemoteIterator dirIt = dfs.listStatusIterator(p);
                if (dirIt.hasNext()) {
                    System.out.println("Warning: unsetting erasure coding policy on a non-empty directory will not automatically convert existing files to replicated data.");
                }
            }
            catch (NoECPolicySetException e) {
                System.err.println(AdminHelper.prettifyException((Exception)((Object)e)));
                System.err.println("Use '-setPolicy -path <PATH> -replicate' to enforce default replication policy irrespective of EC policy defined on parent.");
                return 2;
            }
            catch (Exception e) {
                System.err.println(AdminHelper.prettifyException(e));
                return 2;
            }
            return 0;
        }
    }

    private static class SetECPolicyCommand
    implements AdminHelper.Command {
        private SetECPolicyCommand() {
        }

        @Override
        public String getName() {
            return "-setPolicy";
        }

        @Override
        public String getShortUsage() {
            return "[" + this.getName() + " -path <path> [-policy <policy>] [-replicate]]\n";
        }

        @Override
        public String getLongUsage() {
            TableListing listing = AdminHelper.getOptionDescriptionListing();
            listing.addRow(new String[]{"<path>", "The path of the file/directory to set the erasure coding policy"});
            listing.addRow(new String[]{"<policy>", "The name of the erasure coding policy"});
            listing.addRow(new String[]{"-replicate", "force 3x replication scheme on the directory"});
            return this.getShortUsage() + "\nSet the erasure coding policy for a file/directory.\n\n" + listing.toString() + "\n-replicate and -policy are optional arguments. They cannot been used at the same time.\n";
        }

        @Override
        public int run(Configuration conf, List<String> args) throws IOException {
            String path = StringUtils.popOptionWithArgument((String)"-path", args);
            if (path == null) {
                System.err.println("Please specify the path for setting the EC policy.\nUsage: " + this.getLongUsage());
                return 1;
            }
            String ecPolicyName = StringUtils.popOptionWithArgument((String)"-policy", args);
            boolean replicate = StringUtils.popOption((String)"-replicate", args);
            if (args.size() > 0) {
                System.err.println(this.getName() + ": Too many arguments");
                return 1;
            }
            if (replicate) {
                if (ecPolicyName != null) {
                    System.err.println(this.getName() + ": -replicate and -policy cannot been used at the same time");
                    return 2;
                }
                ecPolicyName = "replication";
            }
            Path p = new Path(path);
            DistributedFileSystem dfs = AdminHelper.getDFS(p.toUri(), conf);
            try {
                dfs.setErasureCodingPolicy(p, ecPolicyName);
                if (ecPolicyName == null) {
                    ecPolicyName = "default";
                }
                System.out.println("Set " + ecPolicyName + " erasure coding policy on " + path);
                RemoteIterator dirIt = dfs.listStatusIterator(p);
                if (dirIt.hasNext()) {
                    System.out.println("Warning: setting erasure coding policy on a non-empty directory will not automatically convert existing files to " + ecPolicyName + " erasure coding policy");
                }
            }
            catch (Exception e) {
                System.err.println(AdminHelper.prettifyException(e));
                return 3;
            }
            return 0;
        }
    }

    private static class RemoveECPolicyCommand
    implements AdminHelper.Command {
        private RemoveECPolicyCommand() {
        }

        @Override
        public String getName() {
            return "-removePolicy";
        }

        @Override
        public String getShortUsage() {
            return "[" + this.getName() + " -policy <policy>]\n";
        }

        @Override
        public String getLongUsage() {
            TableListing listing = AdminHelper.getOptionDescriptionListing();
            listing.addRow(new String[]{"<policy>", "The name of the erasure coding policy"});
            return this.getShortUsage() + "\nRemove an user defined erasure coding policy.\n" + listing.toString();
        }

        @Override
        public int run(Configuration conf, List<String> args) throws IOException {
            String ecPolicyName = StringUtils.popOptionWithArgument((String)"-policy", args);
            if (ecPolicyName == null) {
                System.err.println("Please specify the policy name.\nUsage: " + this.getLongUsage());
                return 1;
            }
            if (args.size() > 0) {
                System.err.println(this.getName() + ": Too many arguments");
                return 1;
            }
            DistributedFileSystem dfs = AdminHelper.getDFS(conf);
            try {
                dfs.removeErasureCodingPolicy(ecPolicyName);
                System.out.println("Erasure coding policy " + ecPolicyName + "is removed");
            }
            catch (IOException e) {
                System.err.println(AdminHelper.prettifyException(e));
                return 2;
            }
            return 0;
        }
    }

    private static class GetECPolicyCommand
    implements AdminHelper.Command {
        private GetECPolicyCommand() {
        }

        @Override
        public String getName() {
            return "-getPolicy";
        }

        @Override
        public String getShortUsage() {
            return "[" + this.getName() + " -path <path>]\n";
        }

        @Override
        public String getLongUsage() {
            TableListing listing = AdminHelper.getOptionDescriptionListing();
            listing.addRow(new String[]{"<path>", "The path of the file/directory for getting the erasure coding policy"});
            return this.getShortUsage() + "\nGet the erasure coding policy of a file/directory.\n\n" + listing.toString();
        }

        @Override
        public int run(Configuration conf, List<String> args) throws IOException {
            String path = StringUtils.popOptionWithArgument((String)"-path", args);
            if (path == null) {
                System.err.println("Please specify the path with -path.\nUsage: " + this.getLongUsage());
                return 1;
            }
            if (args.size() > 0) {
                System.err.println(this.getName() + ": Too many arguments");
                return 1;
            }
            Path p = new Path(path);
            DistributedFileSystem dfs = AdminHelper.getDFS(p.toUri(), conf);
            try {
                ErasureCodingPolicy ecPolicy = dfs.getErasureCodingPolicy(p);
                if (ecPolicy != null) {
                    System.out.println(ecPolicy.getName());
                } else {
                    System.out.println("The erasure coding policy of " + path + " is unspecified");
                }
            }
            catch (Exception e) {
                System.err.println(AdminHelper.prettifyException(e));
                return 2;
            }
            return 0;
        }
    }

    private static class AddECPoliciesCommand
    implements AdminHelper.Command {
        private AddECPoliciesCommand() {
        }

        @Override
        public String getName() {
            return "-addPolicies";
        }

        @Override
        public String getShortUsage() {
            return "[" + this.getName() + " -policyFile <file>]\n";
        }

        @Override
        public String getLongUsage() {
            TableListing listing = AdminHelper.getOptionDescriptionListing();
            listing.addRow(new String[]{"<file>", "The path of the xml file which defines the EC policies to add"});
            return this.getShortUsage() + "\nAdd a list of user defined erasure coding policies.\n" + listing.toString();
        }

        @Override
        public int run(Configuration conf, List<String> args) throws IOException {
            String filePath = StringUtils.popOptionWithArgument((String)"-policyFile", args);
            if (filePath == null) {
                System.err.println("Please specify the path with -policyFile.\nUsage: " + this.getLongUsage());
                return 1;
            }
            if (args.size() > 0) {
                System.err.println(this.getName() + ": Too many arguments");
                return 1;
            }
            DistributedFileSystem dfs = AdminHelper.getDFS(conf);
            try {
                List policies = new ECPolicyLoader().loadPolicy(filePath);
                if (policies.size() > 0) {
                    AddErasureCodingPolicyResponse[] responses;
                    for (AddErasureCodingPolicyResponse response : responses = dfs.addErasureCodingPolicies(policies.toArray(new ErasureCodingPolicy[policies.size()]))) {
                        System.out.println(response);
                    }
                } else {
                    System.out.println("No EC policy parsed out from " + filePath);
                }
            }
            catch (IOException e) {
                System.err.println(AdminHelper.prettifyException(e));
                return 2;
            }
            return 0;
        }
    }

    private static class ListECPoliciesCommand
    implements AdminHelper.Command {
        private ListECPoliciesCommand() {
        }

        @Override
        public String getName() {
            return "-listPolicies";
        }

        @Override
        public String getShortUsage() {
            return "[" + this.getName() + "]\n";
        }

        @Override
        public String getLongUsage() {
            return this.getShortUsage() + "\nGet the list of all erasure coding policies.\n";
        }

        @Override
        public int run(Configuration conf, List<String> args) throws IOException {
            if (args.size() > 0) {
                System.err.println(this.getName() + ": Too many arguments");
                return 1;
            }
            DistributedFileSystem dfs = AdminHelper.getDFS(conf);
            try {
                Collection policies = dfs.getAllErasureCodingPolicies();
                if (policies.isEmpty()) {
                    System.out.println("There is no erasure coding policies in the cluster.");
                } else {
                    System.out.println("Erasure Coding Policies:");
                    for (ErasureCodingPolicyInfo policy : policies) {
                        if (policy == null) continue;
                        System.out.println(policy);
                    }
                }
            }
            catch (IOException e) {
                System.err.println(AdminHelper.prettifyException(e));
                return 2;
            }
            return 0;
        }
    }
}

